/************************************************************************
*                                                                       *
*			1988 - Jim Schimpf				*
*                                                                       *
*                           SERIAL I/O CODE                             *
*                                                                       *
*               Module:transfer.c                                       *
*                                                                       *
*       Version    Date         Person          Description             *
*-----------------------------------------------------------------------*
*       0.1     14-May-88       J.Schimpf       Initial Version         *
*	0.2	15-May-88	J.Schimpf	Change for REAL I/O fcns*
*	0.3	29-May-91	J.Schimpf	Re-orgainze for one	*
*						module			*
*	0.4	13-Jun-91	J.Schimpf	Keep count of <CR>'s	*
*						seen			*
*                                                                       *
*       DESCRIPTION:                                                    *
*               This code controls either serial port			*
*                                                                       *
*       Procedures:                                                     *
*                                                                       *
*       Written+                Name    Description                     *
*-----------------------------------------------------------------------*
*<--------------OPEN/CLOSE/CNTL ROUTINES------------------------------->*
*	y	ser_init()	Init serial port and baud rate		*
*	y	close_ser()	Close serial port			*
*	y	clean_ser()	Clean serial data port			*
*<--------------STRING I/O FUNCTIONS----------------------------------->*
*	y	getsers()	Get string from serial data port	*
*	y	putsers()	Send string to serial data port		*
*	y	serline()	Check for LINE input to serial		*
*<--------------SINGLE CHAR I/O FUNCTIONS------------------------------>*
*	y	getser()	Get 1 serial character			*
*	y	putser()	Send 1 serial character			*
*	y	serhit()	Check for serial input			*
*	y	cntl_dtr()	Control DTR				*
*	y	cntl_rts()	Control RTS				*
*
************************************************************************/

#ifndef _SERCOM_
#define _SERCOM_        1

/******* INCLUDE FILES ******/

#include <stdio.h>
#include <bios.h>

/*  SERIAL FUNCTION EQUATES - PORT AND BAUD RATE DATA */

#define PORT_A		0		/*  COM1 */
#define PORT_B		1		/*  COM2 */

/*  Baud rate descriptors */

#define BAUD_9600	_COM_9600
#define BAUD_4800	_COM_4800
#define BAUD_2400	_COM_2400
#define BAUD_1200	_COM_1200
#define BAUD_600	_COM_600
#define BAUD_300        _COM_300
#define BAUD_110	_COM_110

/*  Data structure for Serial operation */

typedef struct  {
		BOOLEAN         ready;          /* TRUE when ready */
		unsigned	com_base;	/* 8250 Base Address */
		char		irq_mask;	/* IRQ Enable Mask */
		char		irq_eoi;	/* EOI reply for this port */
		char		int_number;	/* Interrupt # used */
		void (_interrupt _far *old)( void );	/* Old Interrupt */
		
		/*  Buffers for I/O */
		
		char		*in_buf;	/* Input buffer */
		int		in_tail;	/* Input buffer TAIL ptr */
		int		in_head;	/* Input buffer HEAD ptr */
		int		in_size;	/* Input buffer size */
		int		in_crcnt;	/* Input <CR> count */
		BOOLEAN		in_mt;		/* Input buffer FLAG */

		char		*out_buf;	/* Output buffer */
		int		out_tail;	/* Output buffer TAIL ptr */
		int		out_head;	/* Output buffer HEAD ptr */
		int		out_size;	/* Output buffer size */
		BOOLEAN		out_full;	/* Output buffer FLAG */
		BOOLEAN		out_mt;		/* Output buffer MT */
	} COM;

/*  USER INTERFACE - FUNCTIONS */
	
	/*  Open/close CNTL */
	
COM *ser_init( int port,int baud,int bit,int parity,int isize,int osize );
void ser_close( COM *c );

	/*  STRING I/O */

int getsers( COM *c,int len,char *str );
int putsers( char *str, COM *c );
BOOLEAN serline( COM *c );

	/*  Single character and line control */

int getser( COM *c );
BOOLEAN serhit(COM *c);
BOOLEAN putser(char outch,COM *c);
void cntl_rts(int flag,COM *c);
void cntl_dtr(int flag,COM *c);
void clean_ser( COM *c );

#endif

