/*

TERMINAL.C

This is a sample TERMINAL program that you can use as a building block..

					Adrian J. Michaud
*/

#include "string.h"
#include "stdio.h"
#include "conio.h"
#include "stdlib.h"
#include "promodem.h"

void main(void);
void main(void)
{
char ch;
AJMS cb1;
unsigned int irq=0, base_address=0;
char com_port[80];
char baud_rate[80];
long baudRate=0;

while (!irq && !base_address)
  {
  printf("\nEnter Com port [1 or 2]: ");
  gets(com_port);

  if (strstr(com_port, "1"))
     {
     base_address = 0x3f8;
     irq          = 4;
     }

  else
  if (strstr(com_port, "2"))
     {
     base_address = 0x2f8;
     irq          = 3;
     }
  }

#define BUFFER_SIZE 4096  /* Use a 4K IRQ Buffer */

SetupControlBlock(&cb1 , base_address , irq , BUFFER_SIZE);

if (OpenCom(&cb1) != SUCCESSFUL)          /* Open Com Port    */
   {
   printf("\nCan't Open Com Port!");
   return;
   }

while (!baudRate)   /* Obtain desired Baud Rate */
  {
  printf("\nEnter Baud Rate (300,2400,9600,19200,38400,....): ");
  gets(baud_rate);

  baudRate = atol(baud_rate);
  }

SetBaudRate(&cb1, baudRate);  /*  Sets up Baud Rate */
SetDataFormat(&cb1, BITS_8|NO_PARITY|STOP_BITS_1); /*  8-N-1               */

if (SetFIFOMode(&cb1) == FIFO_ENABLED)              /* Enable 16550 if any */
   {
   SetFIFOTriggerLevel(&cb1, FIFO_16_TRIGGER); /* Turn on 16 byte RCVR FIFO */
   printf("\nUART is a 16550! FIFO's Enabled.\n");
   }
else printf("\nUART is a 16540 or 8250.\n");

if (GetCTSRTSStatus(&cb1) == ENABLED) /* Check if CTS/RTS is on */
   printf("\nCTS/RTS Hardware Handshaking Enabled!\n");
else
   printf("\nCTS/RTS Hardware Handshaking Disabled!\n");

printf("\nLoad ANSI.SYS if you wish to display ANSI.\n");
printf("\nPress [ESC] to Exit this Sample Terminal Program..\n");

printf("\nUse Hayes AT Commands to Talk to your modem.  If you don't get a");
printf("\nresponse, try the other COM port, or change your IRQ setting.\n");

for ( ; ; ) /* Mini Terminal Program.. (REQUIRES ANSI.SYS loaded for ansi) */
   {
   if (kbhit())                              /* Check if Key Press */
     {
     ch = (char)getch();                     /* Get Character from Keyboard */
     if (ch == 27) break;                    /* if ESC, ABORT!              */
     SendCharacter(&cb1, (unsigned char)ch); /* Send character to modem     */
     }
   if (CheckQueue(&cb1)==CHARACTERS_WAITING)  /* Check IRQ buffer for chars */
      printf("%c", (unsigned char)GetCharacter(&cb1)); /* Display Them */
   }
CloseCom(&cb1);
DropDTR(&cb1);   /* Disable Data Terminal Ready */
}

