title		MAGSAVE.ASM ;derived from SAVEALL.ASM for use
;		            in MAGNIFY.BAS.
 
;		by: e. w. schwittek    revised:6/6/84

page ,132

;equates:
aport		equ [0201h] ;game port
sample_delay	equ 12
line_delay	equ 576

data		segment
fullbyte	db 0 ;sample collection byte
count_4		db 4 ;4 samples of 2 bits each make fullbyte
count_320	dw 320 ;bytes in each line of wefax picture
count_64000	dw 64000 ;bytes used in one eseg
sampl_delay_ctr	dw 0 ;set to sample_delay value after dec to 0
data		ends

code		segment
start		proc  far
		assume ds:data,cs:code

;save bp,es,ss and ds for return to basic program
		push bp ;save bp
		mov bp,sp ;get current stack position into bp
		push es
		push ss
		push ds

;gets value of "A" from basic as parameter
		mov si,[bp]+6 ;get addr of para A into si
		mov ax,[si] ;get value of para A
		mov si,ax ;put para A into si for storage

;establish addressability for data segment
		mov ax,cs
		add ax,si
		add ax,10 ;diff between cs & ds
		mov ds,ax

 
;initializes registers
		mov ax,04000h ;first setting of es reg
		mov es,ax
		sub ax,ax
		mov bx,0000h
 
;sync start routine
		mov cx,255
sync_start:	mov dx,aport
		in al,dx ;put aport into al
		cmp al,64 ;carry flag at 0 if al=>64
		jae sync_start ;jump on cf=0
		loop sync_start

;set counter for later use
		mov cx,line_delay ;counts delay for line sync

 
;sample port and store two bits in fullbyte
begin:		mov dx,aport
		in al,dx ;put aport into al
		rcl al,1 ;put bit 7 of aport in carry flag
		rcl fullbyte,1 ;put carry flag in bit 0 of fullbyte
		rcl al,1 ;put bit 6 of aport in carry flag
		rcl fullbyte,1 ;put carry flag in bit 0 of fullbyte 
;		and move bit 0 to position 1

;cause delay for proper sample rate
		mov ax,sample_delay
		mov sampl_delay_ctr,ax ;set-reset sampl delay ctr
sample:		dec sampl_delay_ctr
		jnz sample

;fill fullbyte with 8 bits
		dec count_4
		jnz begin ;get another 2 bit sample
		mov count_4,4 ;reset counter
 
;establish fullbyte at proper memory location
                mov al,fullbyte
		mov es:[bx],al ;fullbyte to 4000:0000
		inc bx ;next fullbyte position
		dec count_320
		jz line_sync ;jumps when 320 byte line is complete
continue:       dec count_64000 ;completes 1/4 pix
		jnz begin
		jmp reset
 
line_sync:	mov count_320,320 ;reset line byte counter
wait:		nop
		loop wait
		mov cx,line_delay ;reset cx 
		jmp continue
 
reset:		mov count_64000,64000 ;reset counter
		mov bx,0 ;reset bx
 
;change value of es reg
		mov ax,es
		add ax,01000h
		mov es,ax
 
;determine when es has had four values
		cmp ax,07001h ;carry flag at 0 if ax =>7001h
		jb begin
 
finish:		pop ds
		pop ss
		pop es

		mov sp,bp
		pop bp ;restore stack
                ret 2 ;far return to basic
start		endp
code		ends
		end
