title           REALTIME.ASM
;		by: e. w. schwittek (last revised 6/6/84)

page ,132

;equates:
aport		equ [0201h] ;game port
sample_delay	equ 60
line_delay	equ 15421

data		segment
fullbyte	db 0 ;sample collection byte
count_0		db 0 ;causes alternate pix mem selection
count_4		db 4 ;4 samples of 2 bits each make fullbyte
count_80	db 80 ;80 bytes per picture line
count_200	db 200 ;200 lines per picture
sampl_delay_ctr dw 0 ;set to sample_delay value after dec to 0
line_delay_ctr  dw 0 ;set to line_delay value after dec to 0
equalizer_delay dw 1 ;value equalizes sample rate
data		ends

destination	segment at 0b800h ;begins seg at b800h
pixlow		db 8000 dup(0) ;8000 bytes set to 0
		org 2000h ;begins pixhigh (high half of graghics
;		memory) at b800:2000
pixhigh		db 8000 dup(0) ;8000 bytes set to 0
destination	ends

code		segment
start		proc  far
		assume ds:data,es:destination,cs:code

 ;save bp,es,ss and ds for return to basic program
		push bp ;save bp
		mov bp,sp ; get current stack position into bp
		push es
		push ss
		push ds
 
;this proc gets value of "a" fm basic program
		mov si,[bp]+6 ;get addr of para a into si
		mov ax,[si] ;get value of para a
		mov si,ax ; put para a into si for storage

;establish addressability for data segment
		mov ax,cs
		add ax,si
		add ax,14
		mov ds,ax

;establish addressability for destination segment
		mov ax,destination ;get es base addr
		mov es,ax ;give es base addr
 
;initializes registers
		sub ax,ax
		sub di,di
		mov bx,0000h
 
;sync start routine
		mov cx,255
sync_start:	mov dx,aport
		in al,dx ;put aport into al
		cmp al,64 ;carry flag at 0 if al=>64
		jae sync_start ;jump on cf=0
		loop sync_start
 
;sample port and store two bits in fullbyte
begin:		mov dx,aport
		in al,dx ;put aport into al
		rcl al,1 ;put bit 7 of aport in carry flag
		rcl fullbyte,1 ;put carry flag in bit 0 of fullbyte
		rcl al,1 ;put bit 6 of aport in carry flag
		rcl fullbyte,1 ;put carry flag in bit 0 of fullbyte 
;		and move bit 0 to position 1

;cause delay for proper sample rate
		mov ax,sample_delay
		mov sampl_delay_ctr,ax ;set-reset sampl delay ctr
sample:		dec sampl_delay_ctr
		jnz sample

;fill fullbyte with 8 bits
		dec count_4
		jnz equalizer
		mov count_4,4 ;reset counter
		jmp make_line

;equalize delay between first three samples and forth sample
equalizer:	dec equalizer_delay
		jnz equalizer
		mov equalizer_delay,1 ;reset counter
		jmp begin ;get another 2 bit sample

;establish fullbyte at proper graphics memory position
make_line:	mov al,fullbyte
		mov es:[bx+di],al ;fullbyte to pixlow + di
		inc di ;next fullbyte one position right
		dec count_80 ;completes 80-byte line
		mov fullbyte,0 ;reset fullbyte to 0
		jnz begin
		mov count_80,80 ;reset counter

;determine which graphics range we were in, pixlow or pixhigh
		sub count_0,0
		jnz count_is_one

count_is_zero:	mov bx,02000h ;changes graphics mem range
		inc count_0 ;sets count for next pass
		sub di,80 ;sets di to beginning of next line
		jmp joint

count_is_one:	mov bx,0000h ;change graphics mem range
		dec count_0 ;sets count_0 for next pass
		add di,0 ;sets di to beginning of next line
		jmp joint

;make 200 lines
joint:		mov ax,line_delay
		mov line_delay_ctr,ax ;set-reset line delay ctr
line:		dec line_delay_ctr
		jnz line
		mov line_delay_ctr,ax ;reset line delay ctr
line1:		dec line_delay_ctr
		jnz line1
		mov line_delay_ctr,ax ;reset line delay ctr
line2:		dec line_delay_ctr
		jnz line2
		mov line_delay_ctr,ax ;reset line delay ctr
line3:	        dec line_delay_ctr
		jnz line3
                dec count_200 ;counting total picture lines
		jz finish
		jmp begin
 
finish:		pop ds
		pop ss
		pop es
 
		mov sp,bp
		pop bp ;restore stack
                ret 2 ;far return to basic
start		endp
code		ends
		end
