        TITLE"Cmos Setting program"
;	IDEAL
	.MODEL	small
	.STACK 	1024
	DOSSEG

	.DATA

PSP_Address	dw	?
SB_Registers	db	1h,4h,8h,8h,20h,35h,40h,55h,60h,75h,80h,95h,0A0h,0A8h,0B0h,0B8h,0BDh,0BDh,0C0h,0C8h,0E0h,0F5h,00h

Stream		dw	2001h,4010h,60FFh,80FFh,0A02Dh,2301h
		dw	4300h,63F0h,837Fh,0B03Ah
                                     ;7
		dw	2101h,4010h,61FFh,81FFh,0A1DAh,2401h
		dw	4400h,64F0h,847Fh,0B13Ah,0000h
                                     ;7

; Backup, in case I screw up, and fiddle with it wrong.
;Stream		dw	2001h
;		dw	4010h,6080h,8077h,0A02Dh,2301h
;		dw	4300h,63A0h,8377h,0B03Ah
;
;		dw	2101h,4110h,6180h,8177h,0A1DAh,2401h
;		dw	4400h,64A0h,8477h,0B13Ah,0000h



Counter		db	?

	.CODE

Start:
	push	ds			; Save the PSP address
        mov	ax,@data		; Copy address of dataseg into ax
	mov	ds,ax			; And init ds with it

	pop	ax			; Restore the PSP address
	mov	es,ax			; And init es with it

	call	Init_Blaster


	mov	[Counter],00h		; Reset the counter

	mov	bx, offset Stream	; Point bx to stream
	call	Output_To_Blaster	; Call the main procedure


Main_Loop:

; Turning on the sound
	mov	ax,[Stream+12h]		; Load the turn-on byte
	call	Write_To_Blaster	; Write the byte to sb
	mov	ax,[Stream+26h]		; Load the turn-on byte
	call	Write_To_Blaster	; Write the byte to sb

; Waiting 30ms
	mov	ax,0480h		; Reset the timers
	call	Write_To_Blaster	; Call the procedure
	mov	ax,039Bh		; Wait 100 timer ticks
	call	Write_To_Blaster	; Call the procedure
	mov	ax,0402h		; Start the second timer
	call	Write_To_Blaster	; Call the procedure
	call	Wait_For_Blaster	; Wait for timer to overflow
	mov	ax,0480h		; Reset the timers
	call	Write_To_Blaster	; Call the procedure


; Shutting off sound
	mov	ax,[Stream+12h]		; Load the turn-on byte
	and	ax,0FFDFh		; Turn bit 5 off (shut off sound)
	call	Write_To_Blaster	; Write the byte to sb
	mov	ax,[Stream+26h]		; Load the turn-on byte
	and	ax,0FFDFh		; Turn bit 5 off (shut off sound)
	call	Write_To_Blaster	; Write the byte to sb

; Waiting 30ms
	mov	ax,0480h		; Reset the timers
	call	Write_To_Blaster	; Call the procedure
	mov	ax,039Bh		; Wait 100 timer ticks
	call	Write_To_Blaster	; Call the procedure
	mov	ax,0402h		; Start the second timer
	call	Write_to_Blaster	; Call the procedure
	call	Wait_for_Blaster	; Wait for timer to overflow
	mov	ax,0480h		; Reset the timers
	call	Write_To_Blaster	; Call the procedure

        inc	[Counter]
	cmp	[Counter],05
	jne	Main_Loop


	mov	ax,04C00h		; Terminate with exit code 0
	int	21h

;---------------------------------------------------------------------------
; This procedure takes a stream of data and outputs it to SB
; Input:		DS : BX = Pointer to the output stream
; Output:		None
; Registers used:	AX, BX, CX, DX
;---------------------------------------------------------------------------
Output_To_Blaster       PROC	
@@Loop1:
;	mov	ax,[word ds:bx]			; Move the next word into ax
	mov	ax,[bx]			; Move the next word into ax
	cmp	ax,00h				; Is this the last data?
	je	@@Exit				; If yes, then exit
	call	Write_To_Blaster		; Call the subroutine
	add	bx,02h				; Increment the counter
        jmp	@@Loop1				; Loop
@@Exit:
	ret
Output_To_Blaster       ENDP	

;---------------------------------------------------------------------------
; This procedure writes one byte to one of the registers in SB
; Input:		AH = Register
;			AL = Data
; Output:		None
; Registers used:	CX,DX
;---------------------------------------------------------------------------
Write_To_Blaster        PROC
	push	ax			; Save ax register
	mov	al,ah			; move the register address in al
	mov	dx,388h			; SB Address/Status port
	out	dx,al			; Write the register address

; This loop reads the port 6 times to produce the delay required before
; writing to SB data port after providing the address
	mov	cx,06h			; Loop 6 times
@@loop1a:
	in	al,dx			; Read the port
	loop	@@loop1a

	pop	ax			; Restore ax
	inc	dx			; SB Data port
	out	dx,al			; Write the data to port

; This loop reads the port 35 times to produce the delay required before
; writing to SB ports again
	dec	dx			; Decrement dx
	mov	cx,35d			; Loop 35 times
@@loop2:
	in	al,dx			; Read the port
	loop	@@loop2

	ret
Write_To_Blaster        ENDP	


;---------------------------------------------------------------------------
; This procedure initializes the Sound Blaster by writing all zeros to is
; registers.
; Input:		None
; Output:		None
; Used registers:       AX, BX, CX, DX
;---------------------------------------------------------------------------
Init_Blaster    PROC	
	xor	bx,bx			; Zero the offset
;	xor	ch,ch			; Zero the counter
	mov	dx,0388h		; Set dx to the SB address port

@@Loop1b:
;	mov	ah,[byte cs:Sb_Registers+bx]	; Get the next start port number
	mov	ah,[Sb_Registers+bx]	; Get the next start port number
	cmp	ah,00				; is this the end of ports?
	je	@@Exita				; If yes then exit
	inc	bx
;	mov	cl,[byte cs:Sb_Registers+bx]	; Get the next stop port number
	mov	cl,[Sb_Registers+bx]	; Get the next stop port number

@@Loop2a:
	mov	al,ah			; And move it into al
	out	dx,al			; Write the register number into
					; the address port of SB
; Delay, wait, stop, hold-on
	push	cx			; Save CX before overwriting it
	mov	cx,06h			; Loop 6 times
@@Wait1:
	in	al,dx			; Read the port
	loop	@@Wait1			; Loop
	pop	cx			; Restore CX

	inc	dx			; Set dx for the data port
	xor	al,al			; Zero the al register
	out	dx,al			; Zero the data in SB register

; Wait longer, further, better
	push	cx			; Save CX
	mov	cx,35d			; Loop 35 times
@@Wait2:
	in	al,dx			; Read the port
	loop	@@Wait2			; Loop
	pop	cx			; Restore CX

	dec 	dx			; Set dx to the address port again
	inc	ah			; Increment the current port number
	cmp	ah,cl			; Are we at the last port in this section?
	jna	@@Loop2a		; Jump is not greater

	inc	bx			; Increment the offset
	jmp	@@Loop1b			; Looping forever and ever

@@Exita:
	ret				; Return to caller
Init_Blaster    ENDP    


;---------------------------------------------------------------------------
; This procedure just sits and waits until one of the times overflows...
; Input:			None
; Output:			None
; Registers modified:		DX,AL
;---------------------------------------------------------------------------
Wait_for_Blaster        PROC	
	mov	dx,388h			; Address SB status port with dx
@@Wt1:
	in	al,dx			; get the data
	and	al,80h			; mask out bit 7
	cmp	al,80h			; have the timers overflowed?
	jne	@@Wt1			; If not, loop again
	ret				; Return from procedure
Wait_for_Blaster        ENDP	




END	Start
