/* This is taken from the S/Key implementation by Bellcore. I looked for
   any notice that they might have included with their distribution
   but could not find one - mudge.
   S/KEY is a trademark of Bellcore.
*/
void sevenbit(char *);
void f(char *);

/* The one-way function f(). Takes 8 bytes and returns 8 bytes in place */
void f(char *x)
{
        MDstruct md;
#ifndef LITTLE_ENDIAN
        register long tmp;
#endif

        MDbegin(&md);
        MDupdate(&md,(unsigned char *)x,64);

        /* Fold 128 to 64 bits */
        md.buffer[0] ^= md.buffer[2];
        md.buffer[1] ^= md.buffer[3];

#ifdef  LITTLE_ENDIAN
        /* Only works on byte-addressed little-endian machines!! */
        memcpy(x,(char *)md.buffer,8);

#else
        /* Default (but slow) code that will convert to
         * little-endian byte ordering on any machine
         */
        tmp = md.buffer[0];
        *x++ = tmp;
        tmp >>= 8;
        *x++ = tmp;
        tmp >>= 8;
        *x++ = tmp;
        tmp >>= 8;
        *x++ = tmp;

        tmp = md.buffer[1];
        *x++ = tmp;
        tmp >>= 8;
        *x++ = tmp;
        tmp >>= 8;
        *x++ = tmp;
        tmp >>= 8;
        *x = tmp;
#endif
}


/* Crunch a key:
 * concatenate the seed and the password, run through MD4 and
 * collapse to 64 bits. This is defined as the user's starting key.
 */
int keycrunch(char *result,char *seed,char *passwd)
/* result = 8-byte result */
/* seed = Seed, any length */
/* passwd = Password, any length */
{
        char *buf;
        MDstruct md;
        unsigned int buflen;
#ifndef LITTLE_ENDIAN
        int i;
        register long tmp;
#endif

        buflen = strlen(seed) + strlen(passwd);
        if((buf = malloc(buflen+1)) == NULL)
                return -1;
        strcpy(buf,seed);
        strcat(buf,passwd);

        /* Crunch the key through MD4 */
        sevenbit(buf);
        MDbegin(&md);
        MDupdate(&md,(unsigned char *)buf,8*buflen);

        free(buf);

        /* Fold result from 128 to 64 bits */
        md.buffer[0] ^= md.buffer[2];
        md.buffer[1] ^= md.buffer[3];

#ifdef  LITTLE_ENDIAN
        /* Only works on byte-addressed little-endian machines!! */
        memcpy(result,(char *)md.buffer,8);
#else
        /* Default (but slow) code that will convert to
         * little-endian byte ordering on any machine
         */
        for(i=0;i<2;i++){
                tmp = md.buffer[i];
                *result++ = tmp;
                tmp >>= 8;
                *result++ = tmp;
                tmp >>= 8;
                *result++ = tmp;
                tmp >>= 8;
                *result++ = tmp;
        }
#endif

        return 0;
}

void sevenbit(char *s)
{
        /* make sure there are only 7 bit code in the line*/
        while(*s){
                *s = 0x7f & ( *s);
                s++;
        }
}

