/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 * Table of available commands.  Note that they're sorted so that the commands
 * that appear in the spiceinit file are at the top.
 */

#include "spice.h"
#include "cpdefs.h"
#include "ftedefs.h"
#include "ftehelp.h"
#include "suffix.h"

/* Bool fields:     stringargs, spiceonly, major */

struct comm nutcp_coms[] = {
    { "let", com_let, false, false, true,
      { 040000, 040000, 040000, 040000 }, E_DEFHMASK, 0, LOTS,
      arg_let,
      "varname = expr : Assign vector variables." } ,
    { "reshape", com_reshape, false, false, true,
      { 040000, 040000, 040000, 040000 }, E_DEFHMASK, 1, LOTS,
      arg_let,
      "vector ... [ shape ] : change the dimensions of a vector." } ,
    { "define", com_define, false, false, true,
      { 010000, 040000, 040000, 040000 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[[func (args)] stuff] : Define a user-definable function." } ,
    { "set", com_set, false, false, true,
      { 020000, 020000, 020000, 020000 }, E_DEFHMASK, 0, LOTS,
      arg_set,
      "[option] [option = value] ... : Set a variable." } ,
    { "alias", com_alias, false, false, false,
      { 02, 04, 04, 04 }, E_ADVANCED, 0, LOTS,
      (int (*)()) NULL,
      "[[word] alias] : Define an alias." } ,
    { "deftype", com_dftype, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 3, LOTS,
      (int (*)()) NULL,
      "spec name pat ... : Redefine vector and plot types.\n" } ,
    { "plot", com_plot, false, false, true,
      { 041000, 041000, 041000, 041000 }, E_BEGINNING | E_HASPLOTS, 1, LOTS,
      arg_plot,
      "expr ... [vs expr] [xl xlo xhi] [yl ylo yhi] : Plot things." },
    { "display", com_display, false, false, true,
      { 040000, 040000, 040000, 040000 }, E_BEGINNING, 0, LOTS,
      arg_display,
      ": Display vector status." } ,
    { "destroy", com_destroy, false, false, false,
      { 0400, 0400, 0400, 0400 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[plotname] ... : Throw away all the data in the plot." } ,
    { "setplot", com_splot, false, false, true,
      { 0400, 0, 0, 0 }, E_DEFHMASK, 0, 1,
      (int (*)()) NULL,
      "[plotname] : Change the current working plot." } ,
    { "setcirc", NULL, false, true, false,
      { 04, 0, 0, 0 }, E_DEFHMASK, 0, 1,
      (int (*)()) NULL,
      "[circuit name] : Change the current circuit." } ,
    { "setscale", com_setscale, false, false, false,
      { 040000, 0, 0, 0 }, E_DEFHMASK, 0, 1,
      (int (*)()) NULL,
      "[vecname] : Change default scale of current working plot." } ,
    { "transpose", com_transpose, false, false, false,
      { 040000, 040000, 040000, 040000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "varname ... : Perform matrix transposition on multi-D vectors." } ,
    { "xgraph", com_xgraph, false, false, true,
      { 1, 041000, 041000, 041000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "file plotargs : Send plot to Xgraph-11." } ,
    { "hardcopy", com_hardcopy, false, false, true,
      { 1, 041000, 041000, 041000 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "file plotargs : Produce hardcopy plots." } ,
    { "asciiplot", com_asciiplot, false, false, true,
      { 041000, 041000, 041000, 041000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "plotargs : Produce ascii plots." } ,
    { "write", com_write, false, false, true,
      { 1, 040000, 040000, 040000 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "file expr ... : Write data to a file." } ,
    { "compose", com_compose, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 2, LOTS,
      (int (*)()) NULL,
      "var parm=val ... : Compose a vector." } ,
    { "unlet", com_unlet, false, false, false,
      { 040000, 040000, 040000, 040000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "varname ... : Undefine vectors." } ,
    { "print", com_print, false, false, true,
      { 040000, 040000, 040000, 040000 }, E_BEGINNING, 1, LOTS,
      arg_print,
      "[col] expr ... : Print vector values." } ,
    { "load", com_load, false, false, true,
      { 1, 1, 1, 1 }, E_BEGINNING | E_NOPLOTS, 1, LOTS,
      arg_load,
      "file ... : Load in data." } ,
    { "cross", com_cross, false, false, true,
      { 040000, 0, 040000, 040000 }, E_DEFHMASK, 2, LOTS,
      (int (*)()) NULL,
      "vecname number [ vector ... ] : Make a vector in a strange way." } ,
    { "undefine", com_undefine, false, false, false,
      { 010000, 010000, 010000, 010000 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[func ...] : Undefine a user-definable function." } ,
    { "op", NULL, false, true, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[.op line args] : Determine the operating point of the circuit." } ,
    { "tran", NULL, false, true, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[.tran line args] : Do a transient analysis." } ,
    { "ac", NULL, false, true, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[.ac line args] : Do an ac analysis." } ,
    { "dc", NULL, false, true, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[.dc line args] : Do a dc analysis." } ,
    { "pz", NULL, false, true, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[.pz line args] : Do a pole / zero analysis." } ,
    { "sens", NULL, false, true, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[.ac line args] : Do a sensitivity analysis." } ,
    { "disto", NULL, false, true, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[.disto line args] : Do an distortion analysis." } ,
    { "noise", NULL, false, true, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[.noise line args] : Do a noise analysis." } ,
    { "listing", NULL, false, true, true,
      { 0100, 0100, 0100, 0100 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[logical] [physical] [deck] : Print the current circuit." } ,
    { "edit", NULL, false, true, true,
      { 1, 0, 0, 0 }, E_DEFHMASK, 0, 1,
      (int (*)()) NULL,
      "[filename] : Edit a spice deck and then load it in." } ,
    { "dump", NULL, false, true, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Print a dump of the current circuit." } ,
    { "fourier", com_fourier, false, false, true,
      { 0, 040000, 040000, 040000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "fund_freq vector ... : Do a fourier analysis of some data." } ,
    { "show", NULL, false, true, false,
      { 040, 040, 040, 040 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "devspecs ... : parmspecs ... : Print out device parameters." } ,
    { "alter", NULL, false, true, false,
      { 040, 040, 040, 040 }, E_DEFHMASK, 3, LOTS,
      (int (*)()) NULL,
      "devspecs : parmname value : Alter device parameters." } ,
    { "altermod", NULL, false, true, false,
      { 040, 040, 040, 040 }, E_DEFHMASK, 3, LOTS,
      (int (*)()) NULL,
      "devspecs : parmname value : Alter model parameters." } ,
    { "resume", NULL, false, true, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Continue after a stop." } ,
    { "state", NULL, false, true, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "(unimplemented) : Print the state of the circuit." },
    { "stop", NULL, false, true, false,
      { 04200, 04200, 04200, 04200 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[stop args] : Set a breakpoint." } ,
    { "trace", NULL, false, true, false,
      { 0200, 0200, 0200, 0200 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[all] [node ...] : Trace a node." } ,
    { "save", NULL, false, true, false,
      { 0200, 0200, 0200, 0200 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[all] [node ...] : Save a spice output." } ,
    { "iplot", NULL, false, true, true,
      { 0200, 0200, 0200, 0200 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[all] [node ...] : Incrementally plot a node." } ,
    { "status", NULL, false, true, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Print the current breakpoints and traces." } ,
    { "delete", NULL, false, true, false,
      { 020, 020, 020, 020 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[all] [break number ...] : Delete breakpoints and traces." } ,
    { "step", NULL, false, true, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 1,
      (int (*)()) NULL,
      "[number] : Iterate number times, or one." } ,
    { "reset", NULL, false, true, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Terminate a simulation after a breakpoint (formerly 'end')." } ,
    { "run", NULL, false, true, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 1,
      (int (*)()) NULL,
      "[rawfile] : Run the simulation as specified in the input file." } ,
#ifdef notdef
    { "aspice", com_aspice, false, false, false,
      { 1, 1, 1, 1 }, E_DEFHMASK, 1, 2,
      (int (*)()) NULL,
      "file [outfile] : Run a spice job asynchronously." } ,
    { "jobs", com_jobs, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Report on asynchronous spice jobs." } ,
    { "rspice", com_rspice, false, false, false,
      { 1, 1, 1, 1 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[input file] : Run a spice job remotely." } ,
#endif
    { "bug", com_bug, false, false, true,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Report a %s bug." } ,
    { "newhelp", com_ahelp, false, false, true,
      { 010, 010, 010, 010 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[command name] ... : help." },
    { "tutorial", com_ghelp, false, false, true,
      { 023010, 023010, 023010, 023010 }, E_BEGINNING, 0, LOTS,
      (int (*)()) NULL,
      "[subject] ... : Hierarchical documentation browser." } ,
    { "help", com_ghelp, false, false, true,
      { 023010, 023010, 023010, 023010 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[subject] ... : Hierarchical documentation browser." } ,
    { "oldhelp", com_help, false, false, true,
      { 010, 010, 010, 010 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[command name] ... : Print help." } ,
    { "quit", com_quit, false, false, true,
      { 0, 0, 0, 0 }, E_BEGINNING, 0, 0,
      (int (*)()) NULL,
      ": Quit %s." } ,
    { "source", nutcom_source, false, false, true,
      { 1, 1, 1, 1 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "file : Source a %s file." } ,
    { "shift", com_shift, false, false, false,
      { 020000, 0, 0, 0 }, E_DEFHMASK, 0, 2,
      (int (*)()) NULL,
      "[var] [number] : Shift argv or the named list var to the left." } ,
    { "unset", com_unset, false, false, false,
      { 020000, 020000, 020000, 020000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "varname ... : Unset a variable." } ,
    { "unalias", com_unalias, false, false, false,
      { 02, 02, 02, 02 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "word ... : Undefine an alias." } ,
    { "history", com_history, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 2,
      (int (*)()) NULL,
      "[-r] [number] : Print command history." } ,
    { "echo", com_echo, false, false, false,
      { 1, 1, 1, 1 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[stuff ...] : Print stuff." } ,
    { "shell", com_shell, false, false, true,
      { 1, 1, 1, 1 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[args] : Fork a shell, or execute the command." } ,
    { "rusage", com_rusage, false, false, false,
      { 02000, 02000, 02000, 02000 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[resource ...] : Print current resource usage." } ,
    { "cd", com_chdir, false, false, false,
      { 1, 0, 0, 0 }, E_DEFHMASK, 0, 1,
      (int (*)()) NULL,
      "[directory] : Change working directory." } ,
    { "version", com_version, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "[number] : Print the version number." } ,
    { "diff", com_diff, false, false, false,
      { 0400, 0400, 040000, 040000 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      "plotname plotname [vec ...] : 'diff' two plots." } ,
    { "rehash", com_rehash, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Rebuild the unix command database." } ,
    { "while", NULL, false, false, false,
      { 040000, 040000, 040000, 040000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "condition : Execute while the condition is true." } ,
    { "repeat", NULL, false, false, false,
      { 0, 0, 0, 0}, E_DEFHMASK, 0, 1,
      (int (*)()) NULL,
      "[number] : Repeat number times, or forever." } ,
    { "dowhile", NULL, false, false, false,
      { 040000, 040000, 040000, 040000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "condition : Execute while the condition is true." } ,
    { "foreach", NULL, false, false, false,
      { 0, 040000, 040000, 040000 }, E_DEFHMASK, 2, LOTS,
      (int (*)()) NULL,
      "variable value ... : Do once for each value." } ,
    { "if", NULL, false, false, false,
      { 040000, 040000, 040000, 040000 }, E_DEFHMASK, 1, LOTS,
      (int (*)()) NULL,
      "condition : Execute if the condition is true." } ,
    { "else", NULL, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Goes with if." } ,
    { "end", NULL, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": End a block." } ,
    { "break", NULL, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Break out of a block." } ,
    { "continue", NULL, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Continue a loop." } ,
    { "label", NULL, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 1, 1,
      (int (*)()) NULL,
      "word : Create someplace to go to." } ,
    { "goto", NULL, false, false, false,
      { 0100000, 0, 0, 0 }, E_DEFHMASK, 1, 1,
      (int (*)()) NULL,
      "word : Go to a label." } ,
    { "cdump", com_cdump, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 0, 0,
      (int (*)()) NULL,
      ": Dump the current control structures." } ,
    { "settype", com_stype, false, false, false,
      { 0200000, 040000, 040000, 040000 }, E_DEFHMASK, 2, LOTS,
      (int (*)()) NULL,
      "type vec ... : Change the type of a vector." } ,
    { "strcmp", com_strcmp, false, false, false,
      { 0, 0, 0, 0 }, E_DEFHMASK, 3, 3,
      (int (*)()) NULL,
      "varname s1 s2 : Set $varname to strcmp(s1, s2)." } ,
    { "linearize", NULL, false, true, false,
      { 040000, 040000, 040000, 040000 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      " [ vec ... ] : Convert plot into one with linear scale." } ,

    { 0, NULL, false, false, false, { 0, 0, 0, 0 }, E_DEFHMASK, 0, LOTS,
      (int (*)()) NULL,
      NULL }

} ;

