/*## copyright LAST STAGE OF DELIRIUM nov 1999 poland        *://lsd-pl.net/ #*/
/*## autofsd                                                                 #*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <rpc/rpc.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>

#define AUTOFSD_PROG 100099
#define AUTOFSD_VERS 1
#define AUTOFSD_MOUNT 1

#define MAXNAME 255
#define MAXOPTS 255
#define MAXPATH 1024

typedef struct{char *name;char *map;char *opts; char *path; }req_t;
typedef struct{int status;}res_t;

bool_t xdr_req(XDR *xdrs,req_t *objp){
    if(!xdr_string(xdrs,&objp->name,MAXNAME)) return(FALSE);
    if(!xdr_string(xdrs,&objp->map,MAXNAME)) return(FALSE);
    if(!xdr_string(xdrs,&objp->opts,MAXOPTS)) return(FALSE);
    if(!xdr_string(xdrs,&objp->path,MAXPATH)) return(FALSE);
    return(TRUE);
}

bool_t xdr_res(XDR *xdrs,res_t *objp){
    if(!xdr_int(xdrs,&objp->status)) return(FALSE);
    return(TRUE);
}

main(int argc,char **argv){
    char command[10000];
    int i;
    CLIENT *cl;enum clnt_stat stat;
    struct hostent *hp;
    struct sockaddr_in adr;
    struct timeval tm={10,0};
    req_t req;
    res_t res;

    printf("copyright LAST STAGE OF DELIRIUM nov 1999 poland  //lsd-pl.net/\n");
    printf("autofsd for irix 6.4 6.5 6.5.3 IP:all\n\n");

    if(argc!=4){
        printf("usage: %s address \"command\" \"parameters\"\n",argv[0]);
        exit(-1);
    }

    adr.sin_family=AF_INET;    
    adr.sin_port=0;    
    if((adr.sin_addr.s_addr=inet_addr(argv[1]))==-1){
        if((hp=gethostbyname(argv[1]))==NULL){
            errno=EADDRNOTAVAIL;perror("error");exit(-1);
        }
        memcpy(&adr.sin_addr.s_addr,hp->h_addr,4);
    }

    req.path=(char*)strdup("");
    req.map=argv[2];
    req.name=argv[3];
    req.opts=(char*)strdup("");

    i=RPC_ANYSOCK;
    if(!(cl=clntudp_create(&adr,AUTOFSD_PROG,AUTOFSD_VERS,tm,&i))){
        clnt_pcreateerror("error");exit(-1);
    }
    stat=clnt_call(cl,AUTOFSD_MOUNT,xdr_req,&req,xdr_res,&res,tm);
    if(stat!=RPC_SUCCESS) clnt_perror(cl,"error"); 
    else printf("res=%d\n",res.status);
    clnt_destroy(cl);
}

