/*
 *  $Id: egressor.c,v 1.3 2000/04/26 14:17:55 bill Exp $
 *  egressor.c
 *  UDP/TCP/ICMP Packet spoof tester
 *
 *  
 *
 *  (c) 2000 The MITRE Corporation. All rights reserved.
 *  ----------------------------------------------------------------------
 *  Portions of this code based on examples provided in libnet and MD 5
 *  software packages.  Thier respective copyright and disclaimers are
 *  reproduced below:

 *  Copyright (c) 1999, 2000 Mike D. Schiffman <mike@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.

Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.

 *

 * Lamer-Disclaimer:
 * This was a quick and dirty attempt to cook up a very simple tool.
 * Some programming practices herein could be improved. 
 * We know that shows.  We are releasing it in this condition believing
 * that sooner is better than later and, well, it works.
 * TO DO (reviewer comments):
        . Clean up the global variables
        . error checking on 'gethostname'
        . use inet_aton, inet_addr not the supported version.
          (I think the realip conversion can be done cleaner,
           but I don't have time to trouble-shoot right now)
        . Don't like the ip.port, can we separate or at least
          use a ':'
        . a -h or -help command line option to print usage
        . code need formatting help (indents)

 */

#if (HAVE_CONFIG_H)
#include "config.h"
#endif
#include "libnet_test.h"
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include "md5c.c"

/* Prototypes */
static void checkIP (char *);
static void MDString PROTO_LIST ((char *));
static void MDPrint PROTO_LIST ((unsigned char [16]));
extern int send_udp_packet();
extern int send_tcp_packet();
extern int send_icmp_packet();


#define NUM_LOOPS 5
    struct tm *time_ptr;
    time_t lt;
    int sock, c, n, p_num;
    u_long src_ip, dst_ip, user_ip;
    u_short src_prt, dst_prt;
    u_char *cp, *buf;
    struct libnet_arena arena, *arena_p;
    u_char *packets[10]; 
    int ctr;
    u_long srcip;
    char myip[256]; 
    char payload[254];
    char dotip[100];
    char hex_hash[8];
    char tempip[256]; 
    char *x = payload;
    unsigned int spoofip, realip;
    int dotcnt;
    int spoofyes=0;
    int again=0;


/* Build struct for payload of each packet */
struct payload_data 
{
	unsigned int id_num;	/* 4-byte ID Number field */
	unsigned int  seq_num;	/* 4-byte Sequence Number */
	unsigned int spoof_ip;	/* 4-byte user-specified SPOOFED IP */
	unsigned int real_ip;	/* 4-byte REAL IP */
	int key_num;		/* 4-byte hash for web results URL */
	int key_num2;		/* 4-byte additional hash for web results */
} data;

int payload_s=0;
void main(int argc, char **argv)
{
 
struct hostent *myhost;
    data.id_num = 0xA1B2C3D4; 
    data.seq_num = 0x00;
    user_ip = 0;
    src_ip  = 0;
    dst_ip  = 0;
    src_prt = 0;
    dst_prt = 0;
    ctr = 0;


/* Get real IP of the host */
gethostname(myip,sizeof(myip));
myhost = gethostbyname(myip);
 if (myhost == NULL) 
 {
	printf("Sorry, I can't resolve this host IP address.  GETHOSTBYNAME failed...\n");  
	exit(1);
 }
 else
        sprintf(dotip,"%d.%d.%d.%d",(unsigned char )myhost->h_addr_list[0][0], (unsigned char ) myhost->h_addr_list[0][1], (unsigned char ) myhost->h_addr_list[0][2], (unsigned char)myhost->h_addr_list[0][3]);

realip = inet_addr(dotip);

/* MD5 Hash for Key_num */
/* We use TIME as seed for the hash */
lt = time(NULL);
time_ptr = localtime(&lt);
MDString(asctime(time_ptr));

/* MD5 Hash for Key_num2 */
/* Use TIME again as seed */
lt = time(NULL);
lt+=100; /*must do this otherwise, time will be same for Key_num2*/
time_ptr = localtime(&lt);
MDString(asctime(time_ptr));


    while((c = getopt(argc, argv, "d:s:")) != EOF)
    {
        switch (c)
        {
            case 'd':
	        strcpy(tempip,optarg);
		checkIP(tempip);
		if (!(cp = strrchr(optarg, '.')))
		{
		  usage(argv[0]);
		}

		if (dotcnt != 6) 
		{
			usage(argv[0]);
			exit(1);
		}

                *cp++ = 0;
                dst_prt = (u_short)atoi(cp);
                if (!(dst_ip = libnet_name_resolve(optarg, 1)))
                {
                    fprintf(stderr, "Bad destination IP address: %s\n", optarg);
                    exit(1);
                }
                break;
            case 's':
		strcpy(tempip,optarg);
		checkIP(tempip);
		if (!(cp = strrchr(optarg, '.')))
		{
		  usage(argv[0]);
		}

		if (dotcnt !=6) 
		{
			usage(argv[0]);
			exit(1);
		}

                *cp++ = 0;
		spoofyes=1;
                src_prt = (u_short)atoi(cp);
		spoofip = inet_addr(optarg);
                if (!(src_ip = libnet_name_resolve(optarg, 1)))
                {
                    fprintf(stderr, "Bad source IP address: %s\n", optarg);
                    exit(1);
                }
                break;
        }
    }

    if (!src_ip || !src_prt || !dst_ip || !dst_prt)
    {
        usage(argv[0]);
        exit(EXIT_FAILURE);
    }

/* Loop through and send out 5 TCP, 5 UDP, and 5 ICMP packets for each */

/* Send REAL source-packets */
data.real_ip = realip;
data.spoof_ip = realip;
for (ctr=0;ctr<NUM_LOOPS;ctr++)
{
data.seq_num = data.seq_num+0x01;
send_udp_packet(data.real_ip);
send_tcp_packet(data.real_ip);
send_icmp_packet(data.real_ip);
}

/* Send USER-SPECIFIED source-packets */
data.real_ip = realip;
data.spoof_ip = spoofip;
for (ctr=0;ctr<NUM_LOOPS;ctr++)
{

data.seq_num = data.seq_num+0x01;
send_udp_packet(data.spoof_ip);
send_tcp_packet(data.spoof_ip);
send_icmp_packet(data.spoof_ip);
}

/* Send REAL source-packets */
data.real_ip = realip;
data.spoof_ip = realip;
data.seq_num = htonl(0xFF);
for (ctr=0;ctr<NUM_LOOPS;ctr++)
{
send_udp_packet(data.real_ip);
send_tcp_packet(data.real_ip);
send_icmp_packet(data.real_ip);
}



printf("EGRESSOR Packet transmission complete. . .\n\n");
printf("If you are using a webserver for your results, please use the following URL format:\n");
printf("Results:  http://WEBSERVER/results/%x_%x%x.html\n\n",htonl(data.real_ip),htonl(data.key_num),htonl(data.key_num2));
}

/* Validate INPUT IP.PORT */
void checkIP(char *string)
{
char *dotptr;
int done=0;
dotptr = strtok(string,".");
dotcnt=0;
while (!done)
{
	if (dotptr == NULL) done++;
	if ((dotcnt == 5) && (dotptr != NULL)) done++; 
	dotcnt++;	
	dotptr = strtok(NULL,".");
}
}

/* Calculate MD5 on string */
static void MDString(string)
char *string;
{
	MD5_CTX context;
	unsigned char digest[8];
	unsigned int len = strlen (string);

	MD5Init (&context);
	MD5Update (&context, string, len);
	MD5Final (digest, &context);
	MDPrint (digest);
}

/* Print MD5 in hex */
static void MDPrint (digest)
unsigned char digest[8];
{
/* troubleshoot: use this to view both hash */
/*
	unsigned int i;
	for (i = 0; i< 8; i++)
		printf("%02x", digest[i]);
	printf("\n");
*/
if (!again)
	{	
	memcpy(&data.key_num,digest,4);
	again+=1;
	}	
	else {
	memcpy(&data.key_num2,digest,4);
	}
}



int send_udp_packet(src_ip)
{
    payload_s = sizeof(struct payload_data);
    buf = malloc(LIBNET_UDP_H + LIBNET_IP_H + payload_s);
  
    if (!buf)
    {
        perror("No memory for packet");
        exit(EXIT_FAILURE);
    }

    sock = libnet_open_raw_sock(IPPROTO_RAW);
    if (sock == -1)
    {
        perror("No socket");
        exit(EXIT_FAILURE);
    }
    
    libnet_build_ip(LIBNET_UDP_H + payload_s,
            0,
            242,
            0,
            64,
            IPPROTO_UDP,
            src_ip,
            dst_ip,
            NULL,
            0,
            buf);

    libnet_build_udp(src_prt, dst_prt, (char *)&data, payload_s, buf + LIBNET_IP_H);

    libnet_do_checksum(buf, IPPROTO_UDP, LIBNET_UDP_H + payload_s);

    c = libnet_write_ip(sock, buf, LIBNET_UDP_H + LIBNET_IP_H + payload_s);
    if (c < LIBNET_UDP_H + LIBNET_IP_H + payload_s)
    {
        fprintf(stderr, "libnet_write_ip\n");
    }

    free(buf);

    return (c == -1 ? EXIT_FAILURE : EXIT_SUCCESS);
}

int
send_tcp_packet(src_ip)
{
    payload_s = sizeof(struct payload_data);
    buf = malloc(LIBNET_TCP_H + LIBNET_IP_H + payload_s);
    if (!buf)
    {
        perror("No memory for packet");
        exit(EXIT_FAILURE);
    }

     /*  Open raw IP socket */
    sock = libnet_open_raw_sock(IPPROTO_RAW);
    if (sock == -1)
    {
        perror("No socket");
        exit(EXIT_FAILURE);
    }
    
    /*  Build IP header  */
    libnet_build_ip(LIBNET_TCP_H + payload_s, /* Size of the payload */
            0,                              /* IP tos */
            242,                            /* IP ID */
            0,                              /* Frag stuff */
            48,                             /* TTL */
            IPPROTO_TCP,                    /* Transport protocol */
            src_ip,                         /* Source IP */
            dst_ip,                         /* Destination IP */
            NULL,                           /* Pointer to payload (none) */
            0,
            buf);                           /* Packet header memory */

    /* Build TCP header */
    libnet_build_tcp(src_prt,               /* Source TCP port */
            dst_prt,                        /* Destination TCP port */
            11111,                          /* Sequence number */
            99999,                          /* Acknowledgement number */
            TH_SYN,                         /* Control flags */
            1024,                           /* Window size */
            0,                              /* Urgent pointer */
            (char *)&data,                        /* Pointer to payload */
            payload_s,                      /* Payload size */
            buf + LIBNET_IP_H);             /* Packet header memory */

    /* Calculate TCP header checksum */
    libnet_do_checksum(buf, IPPROTO_TCP, LIBNET_TCP_H + payload_s);

    /* Write packet */
    c = libnet_write_ip(sock, buf, LIBNET_TCP_H + LIBNET_IP_H + payload_s);
    if (c < LIBNET_TCP_H + LIBNET_IP_H + payload_s)
    {
        fprintf(stderr, "libnet_write_ip\n");
    }

    free(buf);
    return (c == -1 ? EXIT_FAILURE : EXIT_SUCCESS);
}

int
send_icmp_packet(src_ip)
{
   payload_s = sizeof(struct payload_data);
   arena_p = &arena;
    p_num = 1;

    buf = malloc(LIBNET_ICMP_ECHO_H + LIBNET_IP_H + payload_s);
    if (!buf)
    {
        perror("No memory for packet");
        exit(EXIT_FAILURE);
    }

    if (libnet_init_packet_arena(&arena_p, p_num, LIBNET_ICMP_ECHO_H +
                LIBNET_IP_H) == -1)
    {
        fprintf(stderr, "libnet_init_packet_arena failed\n");
        exit(EXIT_FAILURE);
    }
    else
    {

    }

    /*  Open raw IP socket */
    sock = libnet_open_raw_sock(IPPROTO_RAW);
    if (sock == -1)
    {
        perror("No socket");
        exit(EXIT_FAILURE);
    }

        libnet_build_ip(LIBNET_ICMP_ECHO_H,     /* Size of the payload */
                IPTOS_LOWDELAY | IPTOS_THROUGHPUT, /* IP tos */
                242,                            /* IP ID */
                0,                              /* Frag stuff */
                48,                             /* TTL */
                IPPROTO_ICMP,                   /* Transport protocol */
                src_ip,                         /* Source IP */
                dst_ip,                         /* Destination IP */
                NULL,                           /* Pointer to payload (none) */
                0,
                buf);                    /* Packet header memory */

        /*  Build ICMP header */
        libnet_build_icmp_echo(ICMP_ECHO,       /* type */
                0,                              /* code */
                242,                            /* id */
                1,                              /* seq */
                (char *)&data,                        /* pointer to payload */
                payload_s,                      /* size of payload */
                buf + LIBNET_IP_H);      /* packet header memory */

        if (libnet_do_checksum(buf, IPPROTO_ICMP, LIBNET_ICMP_ECHO_H + payload_s)
                    == -1)
        {
            fprintf(stderr, "Can't do checksum!\n");
        }

        /*  Write ICMP packet */
        c = libnet_write_ip(sock, buf, LIBNET_ICMP_ECHO_H + LIBNET_IP_H + payload_s);
        if (c < LIBNET_ICMP_ECHO_H + LIBNET_IP_H + payload_s)
        {
            fprintf(stderr, "write_ip\n");
        }

    libnet_destroy_packet_arena(&arena_p);
    
    return (c == -1 ? EXIT_FAILURE : EXIT_SUCCESS);
}



void
usage(u_char *name)
{
    fprintf(stderr,
        "usage: %s -s source_ip.source_port -d destination_ip.destination_port\n",
        name);
}

/* EOF */
