#!/usr/bin/perl
# $Id: egressor_server.pl,v 1.5 2000/04/26 13:43:09 bill Exp $
#(c) 2000 The MITRE Corporation. All rights reserved.
#----------------------------------------------------------------------

# * Lamer-Disclaimer:
# * This was a quick and dirty attempt to cook up a very simple tool.
# * Some programming practices herein could be improved. 
# * We know that shows.  We are releasing it in this condition believing
# * that sooner is better than later and, well, it works.
# * TO DO (reviewer comments):
#        . should 'use Strict;'
#        . should use 'use Getopt;' module instead of getopt.pl
#        . should have a -h or -help option to output usage
#        . on 'open's, using 'or die "<ERROR MSG HERE>: $!\n";' is cleaner 
#           than setting $badopen. 
#        . for next rev... may want to use format for output, it
#           tends to be a little cleaner.


use Net::RawIP; 
require 'getopts.pl';

#################################################
#  Make sure the following variables are set
#################################################
$ALLOWED_TIME=20; # How long to wait for an entire session (seconds)
$ALLOWED_CLEANUP_TIME=20; # How long to wait for straggler packets (seconds)
$CHECK_TIME=15;   # How of to check for timeouts in sessions (seconds)
$OUTPUT_DIR="results"; # directory where results will be put (make sure it exists) (no really, make sure)
################################################

$output_html=0;
$daemon_mode=0;
$do_reap=0;
$valid_proto{1}="icmp";
$valid_proto{6}="tcp ";
$valid_proto{17}="udp ";
$perform_next=0;

if(!( -d $OUTPUT_DIR)){
    print "The directory \"$OUTPUT_DIR\" does not exist. Please create it or change the \"OUTPUT_DIR\" variable at the top of $0\n";
    exit(-1);
}

Getopts('d:h:i:');
if(! $opt_i){
    print "Usage $0 -i <interface> [-html] [-daemon]\n";
    print "    -i <interface> - interface for server to listen on\n";
    print "    -html - print output in html format (default is plain text)\n";
    print "    -daemon - run until killed (default is die after first session)\n";
    exit(-1);
}

if($opt_h =~ /^tml$/){
    $output_html=1;
}
if($opt_d =~ /^aemon$/){
    $daemon_mode=1;
}

$filter = "(icmp and (icmp[0:1]&0x8=0x8) and (icmp[8:4]&0xd4c3b2a1=0xd4c3b2a1)) or (tcp and tcp[20:4]&0xd4c3b2a1=0xd4c3b2a1) or (udp and udp[8:4]&0xd4c3b2a1=0xd4c3b2a1)";
$psize = 100;
$interface = $opt_i;
$timeout = 1;

$raw = new Net::RawIP;
my $pcap = $raw->pcapinit($interface,$filter,$psize,$timeout);
$SIG{ALRM}=\&reap_old;
alarm $CHECK_TIME;
while(1){
    loop $pcap,1,\&process_pkt,\@raw;
}

sub reap_old{
    my($cleanup_time)=time-$ALLOWED_CLEANUP_TIME;
    my($embed_ip);
    foreach $embed_ip(keys %cleanup_wait){
        if($cleanup_wait{$embed_ip}<$cleanup_time){
            delete $cleanup_wait{$embed_ip};
        }
    }
    if($perform_next==0){
        &perform_reap;
        $do_reap=0;
    }
    else{
        $do_reap=1;
    }
    alarm $CHECK_TIME;
}

sub perform_reap{
    my($drop_time)=time-$ALLOWED_TIME;
    my($embed_ip);
    foreach $embed_ip(keys %got_init){
        if($got_init{$embed_ip}<$drop_time  && (! defined $cleanup_wait{"${embed_ip}_$key_array{$embed_ip}"})){
            handle_finish($embed_ip);
        }
    }
}

sub process_pkt {
    $perform_next=1;
    $raw->bset(substr( $_[2],14));
    $pkt=$raw->packet;
    $pkt_str=unpack("H*",$pkt);
    $src_addr=substr($pkt_str,24,2).substr($pkt_str,26,2).substr($pkt_str,28,2).substr($pkt_str,30,2);
    $proto=hex(substr($pkt_str,18,2));
    if($proto == 6){
        $data_offset=80;
    }
    elsif($proto == 1 || $proto == 17){
        $data_offset=56;
    }
    $id=substr($pkt_str,$data_offset,8);
    $count=hex(substr($pkt_str,($data_offset+8),8));
    $embed_spoofed_ip=substr($pkt_str,($data_offset+16),8);
    $embed_ip=substr($pkt_str,($data_offset+24),8);
    $keystr=substr($pkt_str,($data_offset+32),16);
    my($try_key)="${embed_ip}_${keystr}";
    if($cleanup_wait{$try_key}>0){
        return;
    }
    $key_array{$embed_ip}=$keystr;
    $init=0;
    if($count==0){
        $init=1;
        if(! defined $got_init{$embed_ip}){
            $got_init{$embed_ip}=time;
        }
    }
    if($embed_spoofed_ip ne $embed_ip){
        if(! defined $got_init{$embed_ip}){
            $got_init{$embed_ip}=time;
        }
        $got_spoof{$embed_ip}{$proto}=1;
        $spoof_status{$embed_ip}=1;
    }
    else{
        if(! defined $got_init{$embed_ip}){
            $got_init{$embed_ip}=time;
        }
        $got_nonspoof{$embed_ip}{$proto}=1;
    }
    if($count==0xff){
        &handle_finish($embed_ip);
    }
    if($do_reap==1){
        perform_reap;
        $do_reap=0;
    }
    $perform_next=0;
} 

sub handle_finish{
    my($embed_ip)=@_;
    if(! defined $got_init{$embed_ip}){
        return;
    }
    $badopen=0;
    my($keystr)=$key_array{$embed_ip};
    if($output_html){
        open(OUTFILE,"> $OUTPUT_DIR/${embed_ip}_${keystr}.html") || sub {$badopen=1};
        if(! $badopen){
            print OUTFILE "<html><title>Egressor Test Results</title>\n";
            if ($spoof_status{$embed_ip} != 1)
            {
	       print OUTFILE "<body BGCOLOR=\"#00FF00\">";
               print OUTFILE "<center><p><img SRC=\"egressor.gif\" height=94 width=503><br><br>";
	       print OUTFILE "<b><font size=+2>RESULTS PAGE";
	       print OUTFILE "<br><br><br>";
	       print OUTFILE "<b><font size=+3>No spoofed packets were seen!</font></b></center>";
	       print OUTFILE "<br><br>";
            }
    	    else{
               print OUTFILE "<body BGCOLOR=\"#FF0000\">";
	       print OUTFILE "<center><p><img SRC=\"egressor.gif\" height=94 width=503><br><br>";
	       print OUTFILE "<b><font size=+2>RESULTS PAGE";
	       print OUTFILE "<br><br><br>";
	       print OUTFILE "<b><font size=+3>SPOOFED PACKETS MADE IT TO THE SERVER!  This may represent a misconfigured router.<br>";
	       print OUTFILE "<br><br>";
            }
            print OUTFILE "<table BORDER COLS=3>";
            print OUTFILE "<tr>";
            print OUTFILE "<td>";
            print OUTFILE "Proto";
            print OUTFILE "</td>";
            print OUTFILE "<td>";
            print OUTFILE "Nonspoof";
            print OUTFILE "</td>";
            print OUTFILE "<td>";
            print OUTFILE "Spoof";
            print OUTFILE "</td>";
            print OUTFILE "</tr>\n";
            foreach $p(sort keys(%valid_proto)){
                print OUTFILE "<tr>";
                print OUTFILE "<td>";
                print OUTFILE "$valid_proto{$p}";
                print OUTFILE "</td>";
                print OUTFILE "<td>";
                if($got_nonspoof{$embed_ip}{$p}){
                    print OUTFILE "X";
                }
                else{
                    print " ";
                }
                print OUTFILE "</td>";
                print OUTFILE "<td>";
                if($got_spoof{$embed_ip}{$p}){
                    print OUTFILE "X";
                }
                else{
                    print " ";
                }
                print OUTFILE "</td>";
                print OUTFILE "</tr>\n";
            }
            print OUTFILE "</table>\n";
    	    print OUTFILE "<BR><BR><BR><BR><BR><center>The MITRE Corporation</center>";
            print OUTFILE "</body>\n";
            print OUTFILE "</html>\n";
            close(OUTFILE);
        }
        else{
            print "Can't open $OUTPUT_DIR\n";
        }
    }
    else{
        open(OUTFILE,"> $OUTPUT_DIR/${embed_ip}_${keystr}.txt") || sub {$badopen=1};
        if(! $badopen){
            print OUTFILE "\t\tEgressor Test Results\n\n";
            if ($spoof_status{$embed_ip} != 1){
                print OUTFILE "No spoofed packets were seen!\n";
            }
            else{
                print OUTFILE "SPOOFED PACKETS MADE IT TO THE SERVER!  This may represent a misconfigured router.\n";
            }
            print OUTFILE "Proto\tNon-spoof\t Spoof\n";
            foreach $p(sort keys(%valid_proto)){
                print OUTFILE "$valid_proto{$p}";
                if($got_nonspoof{$embed_ip}{$p}){
                    print OUTFILE "       X\t\t";
                }
                else{
                    print OUTFILE "     \t\t";
                }
                if($got_spoof{$embed_ip}{$p}){
                    print OUTFILE "   X";
                }
                else{
                    print OUTFILE " ";
                }
                print OUTFILE "\n";
            }
            print OUTFILE "\nThe MITRE Corporation\n";
            close(OUTFILE);
        }
        else{
            print "Can't open $OUTPUT_DIR\n";
        }
    }
    $cleanup_wait{"${embed_ip}_${keystr}"}=time;
    delete $got_init{$embed_ip};
    delete $got_spoof{$embed_ip};
    delete $got_nonspoof{$embed_ip};
    delete $spoof_status{$embed_ip};
    delete $key_array{$embed_ip};

    if($daemon_mode != 1){
        exit(0);
    }
}
