/*
 *  $Id: firepack.h,v 1.2 1998/10/19 23:36:36 route Exp $
 *
 *  Firewalk
 *  firepack interface
 *
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _FIREPACK_H
#define _FIREPACK_H

#include <unistd.h>
#include <pcap.h>
#include "./port_list.h"

/*
 *  Firewalk control structure.
 */

struct firepack
{
    u_short ttl;                    /* Starting IP TTL */
    u_short gway_hop_cnt;           /* Hop count of firewall */
    u_short dest_hop_cnt;           /* Hop count of destination */
    u_short sport;                  /* Source port */
    u_short init_probe_port;        /* Initial port used for ramping */
    struct port_list *plist;        /* Linked list of ports */
    int protocol;                   /* Firewalking protocol to use */
    int red_cnt;                    /* Redundancy count */
    int red_flag;                   /* Redundancy flag */ 
    u_short id;                     /* Firepack packet ID */
    struct sockaddr_in sin;         /* Socket address structure */
    u_long destination;             /* Ultimate destination */
    u_long gateway;                 /* Gateway to probe */
    u_short use_name;               /* Use domain names or dotted decimals (-n) */
    u_char bound;                   /* Bound scan or not */
    int sock;                       /* Socket file descriptor */
    int quiet;                      /* Quiet mode */
    int pcap_timeout;               /* Packet capturing timeout */
    int write_pause;                /* Network writing pause */
    pcap_t *pd;                     /* Pcap listening structure */
    int packet_offset;              /* IP packet offset */
    u_long p_sent;                  /* packets sent */
    u_long p_reply;                 /* packets we got replies back */
};


/*
 *  Initialize the firepack structure with program defaults.
 */

void
init_firepack();


#endif  /* _FIREPACK_H */

/* EOF */
