/*
 *  $Id: firewalk.c,v 1.2 1998/10/19 23:42:13 route Exp $
 *
 *  Firewalk
 *  firewalk implementation
 *  firewalk.c - Sets up the firewalk and calls the appropriate walking module.
 *
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "./firewalk.h"
#include "./firepack.h"
#include "./listener.h"
#include "./signal.h"
#include "./port_list.h"


void
init_firepack()
{
    /*
     *  Initialize firewalking structure with defaults.
     */
    fp->ttl                   = 1;      /* initial probe IP TTL */
    fp->gway_hop_cnt          = 0;      /* set later */
    fp->dest_hop_cnt          = 0;      /* set later */
    fp->sport                 = 10001;  /* source port (TCP and UDP) */
    fp->init_probe_port       = 33434;  /* ala traceroute */
    fp->plist                 = NULL;   /* Linked list of ports */
    fp->protocol              = IPPROTO_UDP;
    fp->red_cnt               = 1;      /* how many probes to send */
    fp->red_flag              = 0;      /* Are we being redundant? */
    fp->id                    = getpid();
    fp->destination           = 0;      /* host we bounce replies from */
    fp->gateway               = 0;      /* host we are scanning through */
    fp->use_name              = 1;      /* use DNS names */
    fp->bound                 = 0;      /* Unbound scan initially */
    fp->sock                  = 0;      /* socket fd */
    fp->quiet                 = 0;      /* quiet mode off */
    fp->pcap_timeout          = REPLY_TIMEOUT;
    fp->write_pause           = WRITE_PAUSE;
    memset(&fp->sin, 0, sizeof(struct sockaddr_in));
    fp->pd                    = NULL;   /* pcap stuff */
    fp->p_sent                = 0;
    fp->p_reply               = 0;
}


void
firewalk(u_char *device)
{
    set_up_listener(fp, device);
    if (catch_sig(SIGINT, catch_sigint) == -1)
    {
        perror("firewalk: cannot catch SIGINT");
        destroy_listener(fp);
        exit(1);
    }

    switch (fp->protocol)
    {
        case IPPROTO_TCP:
            /*
             *  We want to randomize TCP SYN numbers to obfuscate NIDS
             *  signaturing of firewalk.
             */
            seed_prand();
        case IPPROTO_UDP:
            udptcpwalk(fp);
            break;
        case IPPROTO_ICMP:      /* UNSUP */
            break;
        default:
            fprintf(stderr, "Unknown firewalking protocol\n");
            destroy_listener(fp);
            exit(1);
    }
    destroy_listener(fp);
}

/* EOF */
