/*
 *  $Id: firewalk.h,v 1.3 1998/12/05 18:24:52 route Exp $
 *
 *  Firewalk
 *  firewalk interface
 *
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _FIREWALK_H
#define _FIREWALK_H

#include "./main.h"
#include "./firepack.h"

#define MAX_HOP     25      /* the maximum number of hops we will tolerate */
#define WRITE_PAUSE 0       /* default pause before writing to the network */

/*
 *  Host reply types.
 */

#define UNREACH_GW_REPLY    1
#define EXPIRED_GW_REPLY    2
#define UNREACH_DEST_REPLY  3
#define EXPIRED_DEST_REPLY  4
#define UNREACH_REPLY       5
#define EXPIRED_REPLY       6
#define NO_REPLY            7


extern struct firepack *fp;
extern u_char *packet;    

/*
 *  Sets up the listener and starts the walk.
 */

void
firewalk(
    u_char *                /* pointer to the network device to use */
    );


/*
 *  Does the walk.
 */

void
udptcpwalk(
    struct firepack *       /* pointer to the firepack structure */
    );

#endif /* _FIREWALK_H */

/* EOF */
