/*
 * $Id: listener.h,v 1.3 1998/11/02 22:27:26 route Exp $
 *
 *  Firewalk
 *  listener interface
 *
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _LISTENER_H
#define _LISTENER_H

#include "./firewalk.h"

#define REPLY_TIMEOUT           2   /* Wait this many seconds for replies */

#define PROMISCUITY_DECISION    0   /* 1 or 0 (on or off)  We are capturing
                                     * packets destined for an interface on
                                     * our machine, there should be no need
                                     * to put an interface in promiscuous mode
                                     */

#define GET_RAW(X, Y) ((u_char *)pcap_next(X, Y))

extern sigjmp_buf env;
u_char *packet;

/* 
 *  Sets up the pcap listener.  A simple wrapper to init_pcap_machine().
 */

void
set_up_listener(
    struct firepack *,      /* pointer to the firepack structure */
    u_char *                /* pointer the device (NULL terminated string) */
    );


/*
 *  Tear down the pcap listener.  We need to do this to free up heap memory
 *  and remove the device from prmomiscuous mode.
 */

void
destroy_listener(
    struct firepack *       /* pointer to the firepack structure */
    );

/*
 *  Takes packets from pcap and passes them to the verification modules.
 *  Network read timeouts happen here also.
 */

int
listener(
    struct firepack *       /* pointer to the firepack structure */
    );

#endif  /* _LISTENER_H */

/* EOF */
