/*
 *  $Id: main.h,v 1.3 1998/10/28 09:49:15 route Exp $
 *
 *  Firewalk
 *  main client interface
 *
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MAIN_H
#define _MAIN_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <setjmp.h>
#include <ctype.h>
#include <pcap.h>
#include <libnet.h>

#define BANNER  "Firewalk (c) 1998 Mike D. Schiffman and David H. Goldsmith \
for Cambridge\nTechnology Partners, Enterprise Security Services. \
Distribution is unlimited\nprovided due credit is given and no fee is \
charged.\nhttp://www.es2.net/research/firewalk for more information.\n"

#if (__DEBUG)
#define _DEBUG(fmt, arg...) fprintf(stderr, fmt, ##arg)
#else
#define _DEBUG(fmt, arg...)
#endif


struct firepack *fp;            /* Needs to be global for SIGSTOP catcher */


void
usage(
    u_char *                    /* pointer to argv[0] */
    );

#endif /* _MAIN_H */

/* EOF */
