/*
 *  $Id: signal.c,v 1.2 1998/10/19 23:36:40 route Exp $
 *
 *  Firewalk
 *  signal implemenation
 *  signal.c - Signal handling code
 *
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "./signal.h"
#include "./firewalk.h"
#include "./listener.h"
#include "./packet.h"


sigjmp_buf env;

extern struct firepack *fp;

int
catch_sig(int signo, void (*handler)())
{
    struct sigaction action;

    /*
     *  Set the new handler.
     */
    action.sa_handler = handler;

    /*
     *  Unblock all other signals.
     */
    sigemptyset(&action.sa_mask);
    action.sa_flags = 0;
    if (sigaction(signo, &action, NULL) == -1) return (-1);
    else return (1);
}


void
expired_timer(int nada)
{
    alarm(0);
    siglongjmp(env, 1);
}


void
catch_sigint(int nil)
{
    destroy_listener(fp);
    fprintf(stdout, "\n");
    p_stats(fp);
    free(fp);

    /*
     *  Should explicitly free up heap memory and whutnot.  Oh well.
     */
    exit(1);
}

/* EOF */
