/*
 *  $Id: gtk_cb.h,v 1.1.1.1 1999/04/26 22:44:53 route Exp $
 *
 *  Firewalk
 *  gtk callback interface
 *
 *  Copyright (c) 1999 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _GTK_CB_H
#define _GTK_CB_H

#include <gtk/gtk.h>


/*
 *  Main interface quitting callback.  Quits the interface.
 */
void
gtk_quit_main_cb(
    GtkWidget *,    /* Pointer to the widget that emitted the signal */
    gpointer        /* Optional data */
    );


/*
 *  Firewalking callback.  Calls firewalk.
 */
void
gtk_firewalk_cb(
    GtkWidget *,    /* Pointer to the widget that emitted the signal */
    gpointer        /* Optional data */
    );


/*
 *  Control panel callback.  Brings up the control panel.
 */
void
gtk_cp_cb(
    GtkWidget *,    /* Pointer to the widget that emitted the signal */
    gpointer        /* Optional data */
    );


/*
 *  Control panel set button callback.  Sets the options into program.
 */
void
gtk_set_cp_cb(
    GtkWidget *,    /* Pointer to the widget that emitted the signal */
    gpointer        /* Optional data */
    );


/*
 *  Control panel quit callback.  Quits the control panel.
 */
void
gtk_quit_cp_cb(
    GtkWidget *,    /* Pointer to the widget that emitted the signal */
    gpointer        /* Optional data */
    );


/*
 *  File select button callback.  Opens a file selection dialog.
 */
void
gtk_fsb_cb(
    GtkWidget *,    /* Pointer to the widget that emitted the signal */
    gpointer        /* Optional data */
    );


/*
 *  File select quit button callback.  Quits the file selection dialog.
 */
void
gtk_quit_fsb_cb(
    GtkWidget *,    /* Pointer to the widget that emitted the signal */
    gpointer        /* Optional data */
    );


/*
 *  File select ok button callback.  Quits the file selection dialog.
 */
void
gtk_ok_fsb_cb(
    GtkWidget *,    /* Pointer to the widget that emitted the signal */
    gpointer        /* Optional data */
    );


#endif /* _GTK_CB_H */

/* EOF */
