/*
 *  $Id: p_cap.h,v 1.1.1.1 1999/04/26 22:44:53 route Exp $
 *
 *  Firewalk
 *  p_cap interface
 *
 *  Copyright (c) 1999 Mike D. Schiffman <mike@infonexus.com>
 *  Copyright (c) 1998 Mike D. Schiffman <mds@es2.net>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef  _P_CAP_H
#define  _P_CAP_H

#include "./firewalk.h"

#define DEVICE_SIZE 0xa

/*
 *  An ethernet header, IP header,  TCP header.
 */
#define LOW_SNAPLEN     ETH_H + IP_H + TCP_H

/*
 *  An ethernet header, IP header,  TCP header, 2048 bytes of data.
 */
#define MED_SNAPLEN     LOW_SNAPLEN + 0x800

/*
 *  An ethernet header, IP header,  TCP header, 8192 bytes of data.
 */
#define HIGH_SNAPLEN    LOW_SNAPLEN + 0x2000

#define MAXLINE         0x1000
#define DEVICE_BUF_SIZE 0xa

/*#define FILTER  "ip proto \\icmp and \\icmp[0] == 3 or \\icmp[0] == 11"*/
#define FILTER  "icmp"

#ifndef DLT_RAW
#define DLT_RAW 12   /* LLC/SNAP encapsulated atm */
#endif

u_char errbuf[PCAP_ERRBUF_SIZE];

/*
 *  Opens the pcap device.
 */

pcap_t *                /* pointer to the pcap device or NULL if error */
init_pcap_machine(
    int,                /* The snap length */
    int,                /* 1 to put the device in promiscuous mode, 0 not to */
    int,                /* read timeout in miliseconds */
    u_char *            /* pointer to a buffer containing possible error msg */
    );
    

int                     /* datalink type */
get_datalink_offset(
    pcap_t *            /* pointer to the pcap device */
    );   


/*
 *  Prints pcap error messages.
 */

void
pcap_err(
    u_char *,           /* pointer to name of module where the err occured */
    u_char *            /* buf containing error msg */
    );
    

/*
 *  Sets a bpf style pcap filter on a device.
 */

int                     /* 1 upon success, -1 upon failure */
set_pcap_filter(
    pcap_t *,           /* pointer to the pcap device */
    u_char *,           /* pointer to the ACSII name of the device */
    char *              /* poiner to the BPF filter */
    );


#endif  /* _P_CAP_H */

/* EOF */
