/*
 *  $Id: dns_chaos.h,v 1.5 2004/10/13 07:50:37 mike Exp $
 *
 *  Hummingbird - Asynchronous scanning engine
 *  Originally based off of sift.c from the book 
 *  Building Open Source Network Security Tools
 *  Copyright (c) 2002 - 2005 Mike D. Schiffman <stolencreditcard@gmail.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <libnet.h>
#include <pcap.h>
#include <pthread.h>
#include "../version.h"
#include "./config.h"

/* module specific defines */
#define SOURCE_PORT     14358       /* SP, pcap filter template */
#define DNS_CHAOS_FILTER "udp src port 53 and dst port 14358 and udp[8:2] = "
#define CHAOS_QUERY_S    18         /* our chaos class RR is 18 bytes */
#define DNS_NOTIMPL     0x0004      /* DNS server flag not implemented */
#define DNS_SERVFAILED  0x0002      /* DNS server flag server failed */
#define DNS_FORMATERR   0x0001      /* DNS server flag format error */

/* module specific datatypes */
struct dns_chaos_injector
{
    libnet_ptag_t dns;              /* DNS header */
    libnet_ptag_t udp;              /* UDP header */
    libnet_ptag_t ip;               /* IP header */
};

struct dns_chaos_listener
{
    char *pcap_filter;              /* pcap filter */
    u_int32_t total_responses;      /* total responses received */
    u_int32_t valid_responses;      /* real responses received */
    u_int32_t not_implemented;      /* DNS servers NI */
    u_int32_t server_failed;        /* DNS server failed */
    u_int32_t format_error;         /* DNS server format errors */
};

/* module specific functions */
void *dns_chaos_user_create_injector(char *);
void *dns_chaos_user_create_listener(char *);
int dns_chaos_user_init_injector(injector_t *);
int dns_chaos_user_init_listener(listener_t *);
int dns_chaos_builder(void *);
void dns_chaos_decoder(u_char *, const struct pcap_pkthdr *, const u_char *);
void dns_chaos_reporter(listener_t *, injector_t *, int);
int dns_chaos_parser(listener_t *, injector_t *, char *);

/* EOF */
