/*
 *  $Id: hummingbird.h,v 1.9 2004/10/20 08:41:07 mike Exp $
 *
 *  Hummingbird - Asynchronous scanning engine
 *  Originally based off of sift.c from the book 
 *  Building Open Source Network Security Tools
 *  Copyright (c) 2002 - 2005 Mike D. Schiffman <stolencreditcard@gmail.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <libnet.h>
#include <pcap.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <pthread.h>
#include "../version.h"
#include "./config.h"

/* misc defines */ 
#define HB_PREAMBLE     0           /* reporter uses this to dump preamble */
#define HB_DENOUEMENT   1           /* reporter uses this to dump summary */
#define HB_SNAPLEN      350         /* 350 bytes should be enough for pcap */
#define HB_PROMISC      0           /* dont need to be in promisc mode */
#if (PCAP_ZEROTIMEOUT)
#define HB_TIMEOUT      0           /* no timeout, return immediately */
#else
#define HB_TIMEOUT      1           /* 1 sec timeout, return asap */
#endif

/* simple way to subtract timeval based timers */
#define PTIMERSUB(tvp, uvp, vvp)                                             \
    do                                                                       \
    {                                                                        \
            (vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;                   \
            (vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;                \
            if ((vvp)->tv_usec < 0)                                          \
            {                                                                \
                (vvp)->tv_sec--;                                             \
                (vvp)->tv_usec += 1000000;                                   \
            }                                                                \
    } while (0)

/* monolithic control context for the injector */
struct mcc_injector
{
    u_int16_t id;                   /* session id */
    libnet_t *l;                    /* libnet descriptor */
    FILE *in;                       /* file to read hosts from */
    int libnet_mode;                /* libnet mode */
    int targettype;                 /* targettype */
#define TT_IPV4 0x01                /* ipv4 */
#define TT_IPV6 0x02                /* ipv6 */
#define TT_ETH  0x04                /* ethernet */
    u_int32_t src_ip;               /* source ip */
    u_int32_t dst_ip;               /* dest ip */
    struct libnet_ether_addr *src_mac;/* source mac */
    struct libnet_ether_addr *dst_mac;/* dest mac */
    u_int16_t throttle;             /* ms to usleep every 10 packets sent */
    u_int32_t sent_probes;          /* number of sent probes */
    int repeat;                     /* number of times to repeat a probe */
    void *user;                     /* user defined data */
    int (*build)();                 /* packet builder function */
    void *(*user_init)();           /* user init function */
    char errbuf[LIBNET_ERRBUF_SIZE];
};
typedef struct mcc_injector injector_t;

/* monolithic control context for the listener */
struct mcc_listener
{
    u_int16_t id;                   /* session id */
    pcap_t *p;                      /* pcap descriptor */
    FILE *out;                      /* results written here */
    char *outname;                  /* out filename */
    int pcap_snaplen;               /* pcap snapshot length */
    int pcap_promisc;               /* promisc flag */
    int pcap_to_ms;                 /* pcap timeout */
    char *device;                   /* network interface in use */
    struct timeval timer;           /* timer */
    void *user;                     /* user defined data */
    void (*decode)();               /* decoding function */
    void *(*user_init)();           /* user init function */
    char errbuf[LIBNET_ERRBUF_SIZE];
};
typedef struct mcc_listener listener_t;

injector_t *create_injector(char *, void *(*)());
listener_t *create_listener(char *, void *(*)());
int initialize_injector(injector_t *, char *, u_int16_t, u_int16_t, char *, 
int (*)(), int (*)());
int initialize_listener(listener_t *, char *, u_int16_t, void (*)(),
int (*)());
void *run_injector(void *);
void *run_listener(void *);
void destroy_injector(injector_t *);
void destroy_listener(listener_t *);
void shutitdown(listener_t *, injector_t *);
void dump_scantypes();
void usage(char *);
void version();
int load_module_index(char *);
xmlNodePtr setup_xml_parser(char *, xmlDocPtr, char *, char *);

/* moduldes */
#include "./dns_chaos.h"
#include "./tcp_port.h"
#include "./icmp_echo.h"
#include "./arp_whohas.h"

/* EOF */
