/*
 *  $Id: icmp_echo.h,v 1.3 2004/10/13 07:50:37 mike Exp $
 *
 *  Hummingbird - Asynchronous scanning engine
 *  Originally based off of sift.c from the book 
 *  Building Open Source Network Security Tools
 *  Copyright (c) 2002 - 2005 Mike D. Schiffman <stolencreditcard@gmail.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <libnet.h>
#include <pcap.h>
#include <pthread.h>
#include "../version.h"
#include "./config.h"

/* module specific defines */
#define ICMP_ECHO_FILTER "icmp[0] = 0 && icmp[4:2] ="

/* module specific datatypes */
struct icmp_echo_injector
{
    libnet_ptag_t icmp;              /* ICMP header */
    libnet_ptag_t ip;                /* IP header */
    u_int16_t seq;                   /* sequence */
};

struct icmp_echo_listener
{
    char *pcap_filter;              /* pcap filter */
    u_int32_t total_responses;      /* total responses received */
};

/* module specific functions */
void *icmp_echo_user_create_injector(char *);
void *icmp_echo_user_create_listener(char *);
int icmp_echo_user_init_injector(injector_t *);
int icmp_echo_user_init_listener(listener_t *);
int icmp_echo_builder(void *);
void icmp_echo_decoder(u_char *, const struct pcap_pkthdr *, const u_char *);
void icmp_echo_reporter(listener_t *, injector_t *, int);
int icmp_echo_parser(listener_t *, injector_t *, char *);

/* EOF */
