/*
 *  $Id: scantypes.h,v 1.6 2004/10/20 08:41:07 mike Exp $
 *
 *  Hummingbird - Asynchronous scanning engine
 *  Originally based off of sift.c from the book 
 *  Building Open Source Network Security Tools
 *  Copyright (c) 2002 - 2005 Mike D. Schiffman <stolencreditcard@gmail.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

struct scantypes
{
    char *name;
    char *version;
};

/**
 * This is the toplevel array containing scanning module common names and 
 * version information. It is MANDATORY that entries in this array have 
 * corresponding entries in each of the eight following function pointer 
 * arrays. Hummingbird internal module linkage logic expects this If not, your 
 * scanning module will fail spectacularly.
 */
struct scantypes scantype_table[] =
{
    {"dns_chaos",  "1.0"},
    {"tcp_port",   "1.1"},
    {"icmp_echo",  "1.0"},
    {"arp_whohas", "1.0"},
    {NULL,          NULL}
};

/** function pointer array for user defined data creators (listener) */
void *(*user_create_listener[])(char *) = 
{
    dns_chaos_user_create_listener,
    tcp_port_user_create_listener,
    icmp_echo_user_create_listener,
    arp_whohas_user_create_listener,
    NULL
};

/** function pointer array for user defined data creators (injector) */
void *(*user_create_injector[])(char *) = 
{
    dns_chaos_user_create_injector,
    tcp_port_user_create_injector,
    icmp_echo_user_create_injector,
    arp_whohas_user_create_injector,
    NULL
};

/** function pointer array for user defined data initializers (listener) */
int (*user_init_listener[])(listener_t *) = 
{
    dns_chaos_user_init_listener,
    tcp_port_user_init_listener,
    icmp_echo_user_init_listener,
    arp_whohas_user_init_listener,
    NULL
};

/** function pointer array for user defined data initializers (injector) */
int (*user_init_injector[])(injector_t *) = 
{
    dns_chaos_user_init_injector,
    tcp_port_user_init_injector,
    icmp_echo_user_init_injector,
    arp_whohas_user_init_injector,
    NULL
};

/** function pointer array for builders */
int (*builder[])(void *) = 
{
    dns_chaos_builder,
    tcp_port_builder,
    icmp_echo_builder,
    arp_whohas_builder,
    NULL
};

/** function pointer array for listeners */
void (*decoder[])(u_char *, const struct pcap_pkthdr *, const u_char *) = 
{
    dns_chaos_decoder,
    tcp_port_decoder,
    icmp_echo_decoder,
    arp_whohas_decoder,
    NULL
};

/** function pointer array for reporters */
void (*reporter[])(listener_t *, injector_t *, int) = 
{
    dns_chaos_reporter,
    tcp_port_reporter,
    icmp_echo_reporter,
    arp_whohas_reporter,
    NULL
};

/** function pointer array for configuration parsers */
int (*parser[])(listener_t *, injector_t *, char *) = 
{
    dns_chaos_parser,
    tcp_port_parser,
    icmp_echo_parser,
    arp_whohas_parser,
    NULL
};

/** EOF */
