/*
 *  $Id: tcp_port.h,v 1.6 2004/10/21 18:09:19 mike Exp $
 *
 *  Hummingbird - Asynchronous scanning engine
 *  Originally based off of sift.c from the book 
 *  Building Open Source Network Security Tools
 *  Copyright (c) 2002 - 2005 Mike D. Schiffman <stolencreditcard@gmail.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <libnet.h>
#include <pcap.h>
#include <pthread.h>
#include "../version.h"
#include "./config.h"

/* module specific defines */
#define TCP_SOURCE_PORT 29481
#define TCP_PORT_FILTER "tcp src port %d and dst port %d"

/* module specific datatypes */
struct tcp_port_injector
{
    libnet_ptag_t tcp;              /* TCP header */
    libnet_ptag_t ip;               /* IP header */
    u_int16_t dst_port;             /* destination port */
    char *message;                  /* optional payload */
    u_int32_t message_s;            /* payload size */
};

struct tcp_port_listener
{
    char *pcap_filter;              /* pcap filter */
    u_int16_t dst_port;             /* destination port */
    u_int32_t total_responses;      /* total responses received */
    u_int32_t synacks;              /* ports open */
    u_int32_t rsts;                 /* ports closed */
    u_int32_t seq;                  /* sequence number */
    u_int32_t message_s;            /* payload size (needed to calculate ACK) */
};

/* module specific functions */
void *tcp_port_user_create_injector(char *);
void *tcp_port_user_create_listener(char *);
int tcp_port_user_init_injector(injector_t *);
int tcp_port_user_init_listener(listener_t *);
int tcp_port_builder(void *);
void tcp_port_decoder(u_char *, const struct pcap_pkthdr *, const u_char *);
void tcp_port_reporter(listener_t *, injector_t *, int);
int tcp_port_parser(listener_t *, injector_t *, char *);

/* EOF */
