/*
 *  $Id: xml.c,v 1.1 2004/10/13 06:45:54 mike Exp $
 *
 *  Hummingbird - Asynchronous scanning engine
 *  Originally based off of sift.c from the book 
 *  Building Open Source Network Security Tools
 *  Copyright (c) 2002 - 2005 Mike D. Schiffman <stolencreditcard@gmail.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
 
#include "./hummingbird.h"

xmlNodePtr
setup_xml_parser(char *config, xmlDocPtr doc, char *scantype, char *errbuf)
{
    xmlChar *keyword;
    xmlNodePtr node1, node2;

    /** open parse the xml document into a document structure */
    doc = xmlParseFile(config);
    if (doc == NULL)
    {
        sprintf(errbuf, "xmlParseFile(): failure\n");
        return (NULL);
    }

    /** get the root element */
    node1 = xmlDocGetRootElement(doc);
    if (node1 == NULL)
    {
        sprintf(errbuf, "xmlDocGetRootElement(): empty config file?\n");
        xmlFreeDoc(doc);
        return (NULL);
    }

    /** make sure the root element is a hummingbird config file */
    if (xmlStrcmp(node1->name, (const xmlChar *)"hummingbird_config"))
    {
        sprintf(errbuf, "xml file isn't hummingbird config file\n");
        xmlFreeDoc(doc);
        return (NULL);
    }

    /** iterate through document looking for "scantype" elements */
    for (node1 = node1->children; node1; node1 = node1->next)
    {
        if ((xmlStrcmp(node1->name, (const xmlChar *)"scantype")) == 0)
        {
            /** look for the "name" element */
            for (node2 = node1->children; node2; node2 = node2->next)
            {
                if ((xmlStrcmp(node2->name, (const xmlChar *)"name")) == 0)
                {
                    keyword = xmlNodeListGetString(doc, node2->children, 1);
                    /** look for our scantype element */
                    if ((xmlStrcmp(keyword, (const xmlChar *)scantype)) == 0)
                    {
                        xmlFree(keyword);
                        /** return the node pointing to the first option */
                        return (node2);
                    }
                }
            }
        }
    }
    sprintf(errbuf, "didn't find scantype \"%s\"\n", scantype);
    xmlFreeDoc(doc);
    return (NULL);
}

/** EOF */
