/*
 *  $Id: resolve.c,v 1.1.1.1 2004/09/21 17:40:59 mike Exp $
 *
 *  resolve.c - resolves a \n delimited list of hostnames
 *  Copyright (c) 2005 Mike D. Schiffman <stolencreditcard@gmail.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
 
#include <libnet.h>

int
main(int argc, char **argv)
{
    u_int32_t addr;
    libnet_t *l;
    FILE *in;
    char errbuf[LIBNET_ERRBUF_SIZE], buf[512];
 
    if (argc != 2)
    {
        fprintf(stderr, "file?\n");
        return (EXIT_FAILURE);
    }

    l = libnet_init(LIBNET_RAW4, NULL, errbuf);
    if (l == NULL)
    {
        fprintf(stderr, "libnet_init(): %s\n", errbuf);
        return (EXIT_FAILURE);
    }

    in = fopen (argv[1], "r");
    if (in == NULL)
    {
        fprintf(stderr, "fopen(): %s %s\n", argv[1], strerror(errno));
        libnet_destroy(l);
        return (EXIT_FAILURE);
    }

    memset (buf, 0, sizeof (buf));
    while (fgets(buf, sizeof (buf) - 1, in))
    {
        buf[strlen(buf) - 1]  = 0;
        addr = libnet_name2addr4(l, buf, 1);
        if (addr == -1)
        {
            fprintf(stderr, "%s: FAILURE: %s", buf, libnet_geterror(l));
        }
        else
        {
            fprintf(stderr, "%s: %s\n", buf, libnet_addr2name4(addr, 0));
        }
        memset (buf, 0, sizeof (buf));
    }
    return (EXIT_SUCCESS);
}
