#include "./libipgeo.h"


int
main(int argc, char **argv)
{
    ipgeo_t *ipg;
    FILE *fp;
    char buf[IPGEO_BUF_SIZE];
    char err_buf[IPGEO_ERRBUF_SIZE];

    if (argc != 3)
    {
        fprintf(stderr, "usage: ipgeo_db ip_list\n");
        return (EXIT_FAILURE);
    }

    ipg = ipgeo_init(argv[1], 0, err_buf);
    if (ipg == NULL)
    {
        fprintf(stderr, "%s\n", err_buf);
        return (EXIT_FAILURE);
    }    

    printf("ipgeo database opened successfully\n");

    fp = fopen(argv[2], "r");
    if (fp == NULL)
    {
        fprintf(stderr, "%s\n", strerror(errno));
        return (EXIT_FAILURE);
    }

    printf("ip list database opened successfully\n");

    while (fgets(buf, IPGEO_BUF_SIZE, fp))
    {
        buf[strlen(buf) - 1] = 0;
        printf("%s:\t\t", buf);
     
        switch (ipgeo_lookup(ipgeo_ipa2ipn(buf), 0, ipg))
        {

            case 0:
                printf("not found\n");
                break;
            case 1:
                printf("%s ", ipgeo_get_cc(ipg));
                printf("%s ", ipgeo_get_country(ipg));
                printf("%s ", ipgeo_get_region(ipg));
                printf("%s ", ipgeo_get_city(ipg));
                printf("%s ", ipgeo_get_isp(ipg));
                printf("%.4f ", ipgeo_get_lat(ipg));
                printf("%.4f\n", ipgeo_get_long(ipg));
                break;
            case -1:
                printf("suddenly the dungeon collapses: %s\n", 
                    ipgeo_geterror(ipg));
                ipgeo_destroy(ipg);
                return (EXIT_FAILURE);
                break;
        }
    }
    printf("Made %d total comparisons\n", ipgeo_getcomps(ipg));
    ipgeo_destroy(ipg);
    return (EXIT_SUCCESS);
}

/* EOF */

