#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>

#include "types.h"

#define MASKA(ip)	(ip & htonl(0xff000000))
#define MASKB(ip)	((ip & htonl(0x00ff0000)) >> 8)
#define MASKB4(ip)	((ip & htonl(0x00f00000)) >> 8)

bool
is_reserved_A(u32 ip)
{
	switch(MASKA(ip)) {
		case 0: case 1: case 2: case 5: case 7: case 10: case 23: case 27: case 31: case 36: case 37: case 39: case 41: case 42: case 58: case 59: case 71: case 72: case 73: case 74: case 75: case 76: case 77: case 78: case 79: case 85: case 86: case 87: case 88: case 89: case 90: case 91: case 92: case 93: case 94: case 95: case 96: case 97: case 98: case 99: case 100: case 101: case 102: case 103: case 104: case 105: case 106: case 107: case 108: case 109: case 110: case 111: case 112: case 113: case 114: case 115: case 116: case 117: case 118: case 119: case 120: case 121: case 122: case 123: case 124: case 125: case 126: case 127: case 173: case 174: case 175: case 176: case 177: case 178: case 179: case 180: case 181: case 182: case 183: case 184: case 185: case 186: case 187: case 189: case 190: case 197: case 223: case 240: case 241: case 242: case 243: case 244: case 245: case 246: case 247: case 248: case 249: case 250: case 251: case 252: case 253: case 254: case 255: 
		return true;
	}
	return false;
}

bool
is_reserved_special(u32 ip)
{
	if (MASKA(ip) == 192 && MASKB(ip) == 168) return true;
	if (MASKA(ip) == 176 && MASKB4(ip) == 16) return true;
	return false;
}

int
main()
{
	u32 ip;

	while (read(STDIN_FILENO, (void *)&ip, sizeof(ip)) == sizeof(ip)) {
		if (is_reserved_A(ip) || is_reserved_special(ip)) continue;
		write(STDOUT_FILENO, (const void *)&ip, sizeof(ip));
	}

	return EXIT_SUCCESS;
}
