#!/usr/bin/env ruby

require 'net/http'

IANA_HOST = 'www.iana.org'
IANA_PATH = '/assignments/ipv4-address-space'

records = Net::HTTP.new(IANA_HOST).get(IANA_PATH).body.split("\r\n")

badrecords = records.grep(/^[0-9]{3}\/8.*(Reserved|Private)/i)
badAbytes = badrecords.collect { |badrecord| badrecord[0,3].to_i }.sort
cases = badAbytes.collect { |a| "case #{a}: " }

code =<<_END_
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>

#include "types.h"

#define MASKA(ip)	(ip & htonl(0xff000000))
#define MASKB(ip)	((ip & htonl(0x00ff0000)) >> 8)
#define MASKB4(ip)	((ip & htonl(0x00f00000)) >> 8)

bool
is_reserved_A(u32 ip)
{
	switch(MASKA(ip)) {
		#{cases}
		return true;
	}
	return false;
}

bool
is_reserved_special(u32 ip)
{
	if (MASKA(ip) == 192 && MASKB(ip) == 168) return true;
	if (MASKA(ip) == 176 && MASKB4(ip) == 16) return true;
	return false;
}

int
main()
{
	u32 ip;

	while (read(STDIN_FILENO, (void *)&ip, sizeof(ip)) == sizeof(ip)) {
		if (is_reserved_A(ip) || is_reserved_special(ip)) continue;
		write(STDOUT_FILENO, (const void *)&ip, sizeof(ip));
	}

	return EXIT_SUCCESS;
}
_END_

print code
