#include <stdlib.h>
#include <limits.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <errno.h>

#include "cvt.h"
#include "types.h"

/* convert a cstring to u16
 * this function specifies special strtoul base 0, so hex and octal are allowed, among others
 */
bool
cvt_cs_u16(u16 *n, s8 *cs)
{
	s8 *cp;
	u32 n_tmp;

	errno = 0;
	n_tmp = strtoul(cs, &cp, 0);
	if (errno == ERANGE || n_tmp > 0xffff || cs == cp || *cp != '\0') return false;

	*n = n_tmp;
	return true;
}


/* convert a cstring to u32
 * this function specifies special strtoul base 0, so hex and octal are allowed, among others
 */
bool
cvt_cs_u32(u32 *n, s8 *cs)
{
	s8 *cp;
	u32 n_tmp;

	errno = 0;
	n_tmp = strtoul(cs, &cp, 0);
	if (errno == ERANGE || cs == cp || *cp != '\0') return false;

	*n = n_tmp;
	return true;
}


/* convert a cstring IP to u32 (NBO)
 */
bool
cvt_csip_u32(u32 *n, s8 *csip)
{
	return inet_aton(csip, (struct in_addr *)n) ? true : false;
}


/* convert a cstring to double
 */
bool
cvt_cs_dbl(double *d, s8 *cs)
{
	s8 *cp;
	double d_tmp;

	errno = 0;
	d_tmp = strtod(cs, &cp);
	if (errno == ERANGE || cs == cp || *cp != '\0') return false;

	*d = d_tmp;
	return true;
}
