#ifndef INCLUDED_FNV_H
#define INCLUDED_FNV_H

#include "types.h"

#define FNV32_INIT	(u32)0x811c9dc5
#define FNV32_PRIME	(u32)0x01000193

/* specialized FNV32 hash function for a u16 block and a u32 subkey block.
 */
__inline__
u32
fnv32_u16_subkey(const u16 n, const u32 subkey) {
	u32 digest = FNV32_INIT;
	u8	*np = (u8 *)&n,
		*sp = (u8 *)&subkey;

	digest *= FNV32_PRIME;	digest ^= (u32)*np++;
	digest *= FNV32_PRIME;	digest ^= (u32)*np;

	digest *= FNV32_PRIME;	digest ^= (u32)*sp++;
	digest *= FNV32_PRIME;	digest ^= (u32)*sp++;
	digest *= FNV32_PRIME;	digest ^= (u32)*sp++;
	digest *= FNV32_PRIME;	digest ^= (u32)*sp;

	return digest;
}

#endif	/* INCLUDED_FNV_H */
