#ifndef __CODES_H
#define __CODES_H

/*
 *     __   ___   _
 *    /  \ |   \ | | /\---------<ShellCode Generator Library>----------------->
 *   / /\ \| |\ \| |/ /
 *  / /__\ \    /|   /          libShellCode is an ORK's project!
 *  \______/ |\ \| | \          For comments, bug reports, etc ...
 *<--------|_| \_\_|\_\         contact me at orkmail<at>katamail<dot>com
 *
 *
 */

// Find the actual memory adress
char *JMP;
char *CALL;
char *POP_ESI;

// Zeroing a register
char *XOR_EAX_EAX;
char *XOR_EBX_EBX;
char *XOR_ECX_ECX;
char *XOR_EDX_EDX;

// Move a value to a register
char *MOV_IN_AL;
char *MOV_IN_CL;
char *MOV_IN_DL;
char *MOV_IN_CH;
char *MOV_IN_CX;

// Move a register to a register
char *MOV_EAX_EBX;
char *MOV_EAX_ECX;
char *MOV_ECX_EAX;
char *MOV_ESI_EBX;
char *MOV_ESI_ECX;
char *MOV_EDI_EBX;

// Move a register to memory
char *MOV_DL_nESI; 
char *MOV_AL_nESI; 
char *MOV_ESI_nESI;
char *MOV_EAX_nESI;
char *MOV_EBX_nESI;

// Increment, decrement a register
char *INC_EAX;
char *INC_EBX;

// Add and sub
char *ADD_BL;
char *ADD_ECX_ESI;
char *SUB_EBX;

// XOR  memory
char *XOR_AL_EBX;

// Lea
char *LEA_nEBX_ECX;
char *LEA_nESI_ECX; 
char *LEA_nESI_EDX;

// Loop
char *LOOP; 
char *CMP_EAX_EDX;
char *JNE;
// Interrupt call
char *INT_80;

// Completed System Calls
char *EXIT_0;
char *SETUID_0;
char *SETREUID_0_0;
char *SOCKET;
char *BIND;
char *LISTEN;
char *ACCEPT;
char *CONNECT;
char *DUP2;

#endif
