/* LibExploit
 *
 * FILENAME : misc.c
 * DATE     : 11/08/2002
 * CODER    : Simon Roses Femerling
 * ABSTRACT : Misc functions file.
 *
 * Copyright (C) 2002-2003. Simon Roses Femerling <sroses@ibsec.net>
*/

#include "../include/LibExploit.h"

/*************************************************************
* LibExploit Terminal Stuff
*************************************************************/

struct com {
	int opcode;
	char *name;
	char *usage;
};

struct com libexploit_cmd[DEFAULT] = {
{ QUIT,		"quit",		"\t\t-> End Terminal.\n"		  },
{ HELP,		"help", 	"\t\t-> Help.\n"		          },
{ SET,		"set", 		"\t\t-> set (host|port|type) data.\n"     },
{ STATUS,	"status", 	"\t\t-> Status.\n"	 	  	  },
{ CON,		"connect", 	"\t\t-> Connect.\n"			  },
{ DIS,		"disconnect", 	"\t-> Disconnect.\n"			  },
{ CMD,		"cmd", 		"\t\t-> cmd (command).\n"		  },
{ VERSION,	"version", 	"\t\t-> Terminal version.\n"		  },
{ CLEAR,	"clear", 	"\t\t-> Clear connection.\n"		  },
{ DEFAULT,	NULL,		NULL,					  },
};

/*************************************************************
* Global Variables
*************************************************************/

// With this variables we will keep track of status in the Terminal.
char t_host[LIBEXPLOIT_INTERNAL_SIZE];

int t_type;
int t_port;
int t_status;
int t_con;
int t_sock;

/*************************************************************
* Functions
*************************************************************/

/*
 * FUNCTION : void LibExploit_DoShell
 * PARAMS   : int Sock, char *test
 * RETURN   : ...
 * ABSTRACT : Connect and check if exploit worked.
*/
void LibExploit_DoShell(int Sock, char *test) {
        char snd[MAX1024], rcv[MAX1024];
        fd_set rset;
        int maxfd, n;

        strncpy(snd, test,MAX1024);
	LibExploit_Write(Sock, snd);

        for(;;){
                FD_SET(fileno(stdin), &rset);
                FD_SET(Sock, &rset);
                maxfd = LIBEXPLOIT_MAX(fileno(stdin), Sock) + 1;
                select(maxfd, &rset, NULL, NULL, NULL);
                if(FD_ISSET(fileno(stdin), &rset)){
                        bzero(snd, sizeof(snd));
                        fgets(snd, sizeof(snd)-2, stdin);
			LibExploit_Write(Sock, snd);
                }
                if(FD_ISSET(Sock, &rset)){
                        bzero(rcv, sizeof(rcv));
                        if((n = read(Sock, rcv, sizeof(rcv))) == 0) {
				snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "EOF");
                                exit(0);
                        }
                        if(n < 0){
				snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "read() error");
                                exit(-1);
                        }
                        fputs(rcv, stdout);
                }
        }
}

/*
 * FUNCTION : char *LibExploit_GetLocalOS
 * PARAMS   : ....
 * RETURN   : Return Local OS or
 *            NULL if fails.
 * ABSTRACT : Check the local OS given.
*/
char *LibExploit_GetLocalOS() {
	int ret;

	ret = uname(&name);
	if(ret == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "uname() error");
		return NULL;
	}	
	
return name.sysname;
}


/*
 * FUNCTION : char *LibExploit_GetLocalPlatform
 * PARAMS   : ...
 * RETURN   : Return local platform or
 *            NULL if fails.
 * ABSTRACT : Check the local platform given.
*/
char *LibExploit_GetLocalPlatform() {
	int ret;

	ret = uname(&name);
	if(ret == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "uname() error");
		return NULL;
	}	

return name.machine;
}

/*
 * FUNCTION : int LibExploit_MakeTrash
 * PARAMS   : char car, int size
 * RETURN   : A char * of the lenght defined.
 * ABSTRACT : Make trash to fill a buffer.
*/
char *LibExploit_MakeTrash(char car, int size) {
	char *tempbuf = NULL;	

	tempbuf=malloc(size);
	memset(tempbuf, car, size);

return(tempbuf);
}

/*
 * FUNCTION : int LibExploit_MakeTolower
 * PARAMS   : char *data, int size
 * RETURN   : ...
 * ABSTRACT : Make buffer to lower.
*/
void LibExploit_MakeTolower(char *data, int size) {
	int l=0;
	for(l=0;l<size;l++) if(data[l] != 0) data[l]=(char)tolower(data[l]);	
}

/*
 * FUNCTION : int LibExploit_MakeToupper
 * PARAMS   : char *data, int size
 * RETURN   : ...
 * ABSTRACT : Make buffer to upper.
*/
void LibExploit_MakeToupper(char *data, int size) {
	int l=0;
	for(l=0;l<size;l++) if(data[l] != 0) data[l]=(char)toupper(data[l]);	
}

/*
 * FUNCTION : int LibExploit_Error
 * PARAMS   : ...
 * RETURN   : A char * describing an error.
 * ABSTRACT : Return error.
*/
char *LibExploit_Error() {
	return error_msg;
}

/*
 * FUNCTION : char *LibExploit_InternalPrint
 * PARAMS   : char *msg
 * RETURN   : An int of bytes written or 
 *            -1 if fails.
 * ABSTRACT : Print a string.
*/
int LibExploit_InternalPrint(char *msg) {
	int er=0;
	const int len_msg = LIBEXPLOIT_INTERNAL_SIZE;
	char *imsg = NULL;

	if((imsg = (char *)malloc(len_msg)) == NULL) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "malloc() error");
		return -1;
	}
	
	strncpy(imsg, msg, len_msg);
	er = write(1, imsg, len_msg);
	if(er == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "write() error");
		return -1;
	}
	free(imsg);

return er;
}

/*
 * FUNCTION : int LibExploit_OpenTerminal
 * PARAMS   : ...
 * RETURN   : Return 0 if success or
 *           -1 if fails. 
 * ABSTRACT : Open a LibExploit Terminal.
*/
int LibExploit_OpenTerminal() {
	int er;
	int lets_exit;
	char cmd[LIBEXPLOIT_INTERNAL_SIZE];

	// Clean all Terminal info.
	LibExploit_InternalClearTerminal();

	er = LibExploit_InternalPrint("\n\tWelcome to LibExploit Terminal\n\n");
	if(er == -1) {
		return -1;
	}	

	//
	// Begin loop to simulate our terminal.
	//
	do {
	
		er = LibExploit_InternalPrint("let> ");
		if(er == -1) {
			return -1;
		}	
		
		fgets(cmd, LIBEXPLOIT_INTERNAL_SIZE, stdin);
		cmd[strlen(cmd)-1]='\0';

		er = LibExploit_DoRequest(cmd);
		if(er == 1) {
			return;
		}

	} while(1);
}

/*
 * FUNCTION : int LibExploit_DoRequest
 * PARAMS   : char cmd[]
 * RETURN   : Return 0 or 1 on success or
 *            -1 if fails.
 * ABSTRACT : Handle a command from the Terminal.
*/
int LibExploit_DoRequest(char cmd[]) {
	char maxdata[MAX1024];
	char arg1[MAX1024];
	char arg2[MAX1024];
	char arg3[MAX1024];
	int countspace = 0;
	int i;
	int x;
	int er;
	int len;
	int resu;
	char msg[LIBEXPLOIT_INTERNAL_SIZE];

	memset(maxdata, 0, MAX1024);	
	countspace = 0;
	i = 0;

	while(cmd[i] != '\0') {
		if(isspace(cmd[i]))
			countspace++;
		i++;
	}	

	if(countspace == 0) {

		if(!strcmp(cmd, "help")) {
			x=-1;
			while(libexploit_cmd[++x].opcode != DEFAULT) {
				len = strlen(libexploit_cmd[x].name) + strlen(libexploit_cmd[x].usage) + 1;		
				snprintf(maxdata, len, "%s%s", libexploit_cmd[x].name, libexploit_cmd[x].usage);
				er = LibExploit_InternalPrint(maxdata);
				if(er == -1) {
					return -1;
				}	
				memset(maxdata, 0, MAX1024);
			}
		}

		else if(!strcmp(cmd, "status")) {
			LibExploit_InternalCheckStatus();			
			resu = LibExploit_InternalPrintStatus();
			if(resu == -1) return -1;
		}		

		else if(!strcmp(cmd, "version")) {
			snprintf(msg,LIBEXPLOIT_INTERNAL_SIZE,"LibExploit Terminal Version : %s\n",LIBEXPLOITVER);
			er = LibExploit_InternalPrint(msg);
			if(er == -1) {
				return -1;
			}						
		}

		else if(!strcmp(cmd, "clear")) {
			LibExploit_InternalClearTerminal();
			snprintf(msg,LIBEXPLOIT_INTERNAL_SIZE,"Clear Terminal Information.\n");
			er = LibExploit_InternalPrint(msg);
			if(er == -1) {
				return -1;
			}					
		}

		else if(!strcmp(cmd, "connect")) {
			snprintf(msg,LIBEXPLOIT_INTERNAL_SIZE,"Open  connection.\n");
			er = LibExploit_InternalPrint(msg);
			if(er == -1) {
				return -1;
			}
			if(t_type == ICMP_SHELL) {
				t_sock = LibExploit_InternalConnectICMPClient(t_host);
				t_con = YES;
			}
			if(t_type == TCP_SHELL) {
				t_sock = LibExploit_Connect(t_host, t_port);
				t_con = YES;
			}
//			if(t_type == UDP_SHELL) {

//			}			
		}	

		else if(!strcmp(cmd, "disconnect")) {
			LibExploit_Close(t_sock);
			snprintf(msg,LIBEXPLOIT_INTERNAL_SIZE,"Connection close.\n");
			er = LibExploit_InternalPrint(msg);
			if(er == -1) {
				return -1;
			}
			t_con = NO;					
		}	

		else if(!strcmp(cmd, "quit")) {
			return(1);
		}
		else {
			er = LibExploit_InternalPrint("Error : command not found!!\n");
			if(er == -1) {
				return -1;
			}			
		}
	}

	else if(countspace == 1) {
		sscanf(cmd, "%s %s", arg1, arg2);		

		if(!strcmp(arg1, "cmd")) {
			
			if(t_con == YES) {
				if(t_type == ICMP_SHELL) {
					LibExploit_InternalCMDICMPClient(t_sock, arg2);
				}
				if(t_type == TCP_SHELL) {
					LibExploit_ConnectShell(t_sock);
				}	
//				if(t_type == UDP_SHELL) {

//				}
			} else {
				er = LibExploit_InternalPrint("Error : Connect first!!\n");
				if(er == -1) {
					return -1;
				}			
			}
		}
		else {
			er = LibExploit_InternalPrint("Error : command not found!!\n");
			if(er == -1) {
				return -1;
			}			
		}		
	}

	else if(countspace == 2) {
		sscanf(cmd, "%s %s %s", arg1, arg2, arg3);		

		if(!strcmp(arg1, "set")) {
			if(!strcmp(arg2,"host")) {
				strncpy(t_host,arg3,LIBEXPLOIT_INTERNAL_SIZE); 
			} else if(!strcmp(arg2, "port")) {
				t_port = atoi(arg3);
			} else if(!strcmp(arg2, "type")) {
				if(!strcmp(arg3,"icmp")) {
					t_type = ICMP_SHELL;
				} else if(!strcmp(arg2, "tcp")) {
					t_type = TCP_SHELL;
				} else if(!strcmp(arg2, "udp")) {
					t_type = UDP_SHELL;
				} else {
					er = LibExploit_InternalPrint("Error : Invalid shell type!!\n");
					if(er == -1) {
						return -1;
					}			
				}	
			} else {
				er = LibExploit_InternalPrint("Error : Invalid command!!\n");
				if(er == -1) {
					return -1;
				}			
			}
		}
		else {
			er = LibExploit_InternalPrint("Error : command not found!!\n");
			if(er == -1) {
				return -1;
			}			
		}		

	} else {
		er = LibExploit_InternalPrint("Error : command not found!!\n");
		if(er == -1) {
			return -1;
		}			
	}

return 0;
}

/*
 * FUNCTION : void LibExploit_InternalClearTerminal
 * PARAMS   : ...
 * RETURN   : ...
 * ABSTRACT : Clears all Terminal information.
*/
void LibExploit_InternalClearTerminal() {

	memset(t_host,0,LIBEXPLOIT_INTERNAL_SIZE);
	t_type = NO_SHELL;
	t_port = -1;
	t_status = NO;
	t_con = NO;
	t_sock = -1;
}

/*
 * FUNCTION : int LibExploit_InternalPrintStatus
 * PARAMS   : ...
 * RETURN   : Return 0 on success or
 *            -1 if fails.
 * ABSTRACT : Print current status.
*/
int LibExploit_InternalPrintStatus() {
	int er;	
	char *msg;

	if(t_status == YES) {
		if(t_con == YES) {
			sprintf(msg,"Current Status : Connected.\n");
		} 
		if(t_con == NO) {
			sprintf(msg,"Current Status : Not connected.\n");
		}
		er = LibExploit_InternalPrint(msg);
		if(er == -1) {
			return -1;
		}
		sprintf(msg,"Host : %s\n",t_host);
		er = LibExploit_InternalPrint(msg);
		if(er == -1) {
			return -1;
		}
		sprintf(msg,"Port : %d\n",t_port);
		er = LibExploit_InternalPrint(msg);
		if(er == -1) {
			return -1;
		}
		if(t_type == ICMP_SHELL) {
			sprintf(msg,"Shell Type : ICMP\n");
		} else if(t_type == TCP_SHELL) {
			sprintf(msg,"Shell Type : TCP\n");
		} else if(t_type == UDP_SHELL) {
			sprintf(msg,"Shell Type : UDP\n");
		} else {
			sprintf(msg,"Shell Type : Unknown??\n");
		}
		er = LibExploit_InternalPrint(msg);
		if(er == -1) {
			return -1;
		}
	}
	else { // Assume status == NO
		sprintf(msg,"Current Status : Not connected.\n");
		er = LibExploit_InternalPrint(msg);
		if(er == -1) {
			return -1;
		}
	}			
return 0;
}

/*
 * FUNCTION : int LibExploit_InternalCheckStatus
 * PARAMS   : ...
 * RETURN   : ...
 * ABSTRACT : Check current status.
*/
void LibExploit_InternalCheckStatus() {
	
	if((t_host == NULL) ||
//	   (t_port == -1) ||
	   (t_type == NO_SHELL)) {
		t_status = NO;
	} else {
		t_status = YES;
	}
}

/*
 * FUNCTION : int LibExploit_ConnectShell
 * PARAMS   : int sock
 * RETURN   : Return 0 on success or
 *            -1 if fails.
 * ABSTRACT : Connect to a bind shellcode.
*/
int LibExploit_ConnectShell(int sock) {
	fd_set  fd_read;
	char buff[1024];
	int n;
 
	while(1) {
 		FD_SET(sock,&fd_read);
  		FD_SET(0,&fd_read);
 
  		if(select(sock+1,&fd_read,NULL,NULL,NULL)<0) break;
 
  		if(FD_ISSET(sock, &fd_read)) {
   			n=read(sock,buff,sizeof(buff));
   			if (n == 0) {
				snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "Connection closed.");
       				return -1;
   			} else if (n < 0) {
       				snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "Remote read error.");
       				return -1;
   			}
   			write(1,buff,n);
  		}
 
  		if (FD_ISSET(0, &fd_read)) {
    			if((n=read(0,buff,sizeof(buff)))<=0) {
      				snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "User read error.");
      				return -1;
    			}
    			write(sock,buff,n);
  		}
 	} // End, while.
	
	close(sock);
return(0); 
}

/* SRF E0F */
