#include "libnet.h"
LPGINFO g_Info;
struct ArpLL	*arpcache;

BOOL WINAPI DllMain(HINSTANCE hinst, ULONG fdwReason, LPVOID lpReserved)
{
	switch (fdwReason)
	{
		case DLL_PROCESS_ATTACH:
		g_Info=malloc(sizeof(LPGINFO));
		break;
		case DLL_PROCESS_DETACH:
		PacketCloseAdapter(g_Info->lpAdapter);
		break;
	}
	return TRUE;
}

BOOL libnet_win32_init(int AdapterNum)
{
	BOOL ret;
	ret=libnet_win32_open_adapter(AdapterNum);
	if(ret==FALSE)
	{
		printf("Open adapter failed\n");
	}
	libnet_win32_get_hw_addr();
	libnet_win32_get_local_ip();
	return TRUE;	
}

BOOL libnet_win32_shutdown()
{
	PacketCloseAdapter(g_Info->lpAdapter);

	return TRUE;
}

void libnet_win32_get_hw_addr()
{
	ULONG      IoCtlBufferLength=(sizeof(PACKET_OID_DATA)+sizeof(ULONG)-1);
	PPACKET_OID_DATA OidData;
	BOOL	torf;
	
	OidData=(struct _PACKET_OID_DATA *) malloc(IoCtlBufferLength);
    if (OidData == NULL) {
        return;
    }
	OidData->Oid = OID_802_3_CURRENT_ADDRESS;
	OidData->Length = 6;
	torf=PacketRequest(g_Info->lpAdapter,FALSE,OidData);
	if(torf==FALSE)
	{
		memset(g_Info->MAC,0,6);
	}
	else
	{
		memcpy(g_Info->MAC,OidData->Data,6);
	}
	
}

void libnet_win32_get_local_ip()
{
	HKEY hKey;
	int nResult;
	char path[512];
	char *ip,*gateway;
	char val[100];
	strcpy(path,g_Info->Aname);
	nResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services",0,KEY_READ,&hKey);
	if( nResult == ERROR_SUCCESS )
	{
		nResult = RegOpenKeyEx(hKey,path,0,KEY_READ,&hKey);

			if( nResult == ERROR_SUCCESS )
			{
					nResult = RegOpenKeyEx(hKey,"Parameters\\Tcpip",0,KEY_READ,&hKey);
					if( nResult == ERROR_SUCCESS )
					{
						DWORD type=REG_DWORD;
						DWORD value;
						DWORD size=4;
						nResult=RegQueryValueEx(hKey,"EnableDHCP",0,&type,
								(LPBYTE)&value,&size);	
						

						if( nResult == ERROR_SUCCESS )
						{
							if(value==1)
							{
								//DHCP is used
								ip="DhcpIPaddress";
								gateway="DhcpDefaultGateway";
							}
							else
							{
								ip="IPaddress";
								gateway="DefaultGateway";
							};

							type=REG_SZ;

							size=100;
							
							//get our IP
							nResult=RegQueryValueEx(hKey,ip,0,&type,
								(LPBYTE)val,&size);	
							if( nResult == ERROR_SUCCESS )
							{
								g_Info->LocalIp=inet_addr(val);
								//printf("IP-1:%s",val);
							}
							else
							{
								printf("Error while getting own IP from registry\n");
							}

							//get gateway
							size=100;

							nResult=RegQueryValueEx(hKey,gateway,0,&type,
								(LPBYTE)val,&size);	
							if( nResult == ERROR_SUCCESS )
							{
								g_Info->DefaultGateway=inet_addr(val);
								//printf("GW-1:%s",val);
							}
							else
							{
								printf("Error while getting default gateway from registry\n");
							}

						}

					}

			}

		}
}

BOOL libnet_win32_open_adapter(int Open)
{
	int        i;
	DWORD      dwErrorCode;
	WCHAR		AdapterName[512];
	WCHAR		*temp,*temp1;
	char temp3[512];
	int			AdapterNum=0;
	ULONG		AdapterLength=512;
	char        AdapterList[10][1024];
	for(i=0;i<10;i++)
	{
		memset (AdapterList[i],0,1024);
	}
	i=0;
	PacketGetAdapterNames((char *)AdapterName,&AdapterLength);
	temp=AdapterName;
	temp1=AdapterName;
	while ((*temp!='\0')||(*(temp-1)!='\0'))
	{
		if (*temp=='\0') 
		{
			memcpy(AdapterList[i],temp1,(temp-temp1)*2);
			temp1=temp+1;
			i++;
		}
		temp++;
	}
	//copy the unicode chosen adapterlist to ascii
	wcstombs(temp3,(WCHAR *)AdapterList[Open-1],512);
	i=0;
	//fuill the g_aname with info 
	while(temp3[i]!='\0')
	{
		if(temp3[i]=='_')
		{
			strcpy(g_Info->Aname,&temp3[i+1]);	
			break;
		};
		i++;		
	}
	//open the adapter
	g_Info->lpAdapter = PacketOpenAdapter(AdapterList[Open-1]);
	if (!g_Info->lpAdapter || (g_Info->lpAdapter->hFile == INVALID_HANDLE_VALUE))
	{
		dwErrorCode=GetLastError();
		printf("Unable to open the driver, Error Code : %lx\n",dwErrorCode); 
		return FALSE;
	}
	//adjust the sending buffer
	PacketSetBuff(g_Info->lpAdapter,512000);
//	PacketSetNumWrites(g_Info->lpAdapter,100);

	return TRUE;
}


//fillarpLL