/*
Ryan@eEye.com Copyright 2000;
Low level Packet driver interface for libnet.
*/

#if (HAVE_CONFIG_H)
#include "../include/config.h"
#endif 
#include "../include/libnet.h"

extern LPGINFO g_Info;

struct libnet_link_int *
libnet_open_link_interface(char *device, char *ebuf)
{
	//fill the libnet inteface structure.  
	//We don't really use this, but at a later date, we could.
	register struct libnet_link_int *l;
	l = (struct libnet_link_int *)malloc(sizeof (*l));
    if (l == NULL)
    {
        sprintf(ebuf, "malloc: %s", ll_strerror(errno));
        return (NULL);
    }
    memset(l, 0, sizeof (*l));
	l->fd = 1;
	l->linktype = 1; //ethernet, which is all i am porting to        
	l->linkoffset = 0xe;
	l->device = g_Info->lpAdapter->SymbolicLink; 
	return (l);
}


int
libnet_close_link_interface(struct libnet_link_int *l)
{
    
	// close packet driver stuff
	return(0);
}


int
libnet_write_link_layer(struct libnet_link_int *l, const u_char *device,
            u_char *buf, int len)
{
	// define a pointer to a PACKET structure
	LPPACKET   lpPacket;
	if((lpPacket = PacketAllocatePacket())==NULL){
		printf("\nError:failed to allocate the LPPACKET structure.");
		return (-1);
	}
	//send the packet
	PacketInitPacket(lpPacket,buf,len);
	PacketSendPacket(g_Info->lpAdapter,lpPacket,TRUE);
	PacketFreePacket(lpPacket);
	return (0);
}



BYTE *
libnet_win32_get_remote_mac(DWORD IP)
{
	BYTE *MAC=malloc(6);
	BYTE bcastmac[]= {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
	MAC=libnet_win32_FindMAC(IP);
	if (MAC==NULL)
	{
		libnet_win32_send_arp(IP);
		Sleep(250);
		MAC=libnet_win32_FindMAC(IP);
		if (MAC==NULL)
		{
			MAC=libnet_win32_FindMAC(g_Info->DefaultGateway);
			if (MAC==NULL)
			{
				libnet_win32_send_arp(g_Info->DefaultGateway);
				Sleep(250);
				MAC=libnet_win32_FindMAC(g_Info->DefaultGateway);
				if (MAC==NULL)
				{
					MAC=bcastmac;
				}
			}
		}
	}
	return MAC;
}




BYTE * libnet_win32_FindMAC(DWORD IP)
{
	BYTE *MAC=NULL;
    int status,status2,ci,i;
    PMIB_IPNETTABLE pIpNetTable = NULL;
	PMIB_IPADDRTABLE pIpAddrTable = NULL;
	DWORD Size,Size2;
	BOOL fOrder=TRUE;

	Size = Size2 = 0;

    status = GetIpNetTable(pIpNetTable, &Size, fOrder);
	if (status == ERROR_INSUFFICIENT_BUFFER)
    {
        pIpNetTable = (PMIB_IPNETTABLE) malloc(Size);
        assert(pIpNetTable);        
        status = GetIpNetTable(pIpNetTable, &Size, fOrder);
    }

	if(status == NO_ERROR)
	{
	
		if (pIpNetTable == NULL)    
		{
			printf( "pIpNetTable == NULL in line %d\n", __LINE__);    
		}
	    status2 = GetIpAddrTable(pIpAddrTable, &Size2, fOrder);
		if (status2 == ERROR_INSUFFICIENT_BUFFER)
		{
			pIpAddrTable = (PMIB_IPADDRTABLE) malloc(Size2);
			assert(pIpAddrTable);        
			status2 = GetIpAddrTable(pIpAddrTable, &Size2, fOrder);
		}

		if ( status2 != NO_ERROR)
	    {
	        printf("GetIpAddrTable returned 0x%x\n", status2);
	        if (pIpAddrTable) free(pIpAddrTable);
	        MAC = NULL;
		}
		assert(pIpAddrTable);
		ci = pIpNetTable->table[0].dwIndex;

		
		for (i = 0; i < (int)pIpNetTable->dwNumEntries; ++i)
		{
			if ((int)pIpNetTable->table[i].dwIndex != ci)
			{
			    ci = (int)pIpNetTable->table[i].dwIndex;
			}

			if(pIpNetTable->table[i].dwAddr==IP)
			{
				return pIpNetTable->table[i].bPhysAddr;
			}        
		}
		free(pIpNetTable);
	}
    else if ( status == ERROR_NO_DATA)
    {
        printf("No entries in arp cache.\n");
        if (pIpNetTable)
            free (pIpNetTable);
		MAC=NULL;
//		memset(MAC,0,6);    
    }
    else
    {
        if (pIpNetTable)
            free (pIpNetTable);
        printf("mac lookup returned 0x%x\n", status);
		//memset(MAC,0,6);    
				MAC=NULL;
    }
return NULL;
}

BOOL libnet_win32_send_arp(DWORD IP)
{
	struct libnet_arp_hdr	arp_h;
	struct libnet_ethernet_hdr	eth_h;
	LPPACKET   lpPacket;
	int len;
	u_char	buf[42];
	BOOL ret;
	// build ether header
	memset(eth_h.ether_dhost,0xFF,6);
	memcpy(eth_h.ether_shost,g_Info->MAC,6);
	eth_h.ether_type =0x0608;
	//build arp header
	arp_h.ar_hrd=0x0100;

	arp_h.ar_pro=0x0008;                         /* format of protocol address */
	arp_h.ar_hln=6;                         /* length of hardware address */
    arp_h.ar_pln=4;                         /* length of protocol addres */
    arp_h.ar_op=0x0100 ;
	memcpy(arp_h.ar_sha,g_Info->MAC,6);
	memcpy(arp_h.ar_spa,&g_Info->LocalIp,4);
	memset(arp_h.ar_tha,0,6);
	memcpy(arp_h.ar_tpa,&IP,4);
	memcpy(buf,&eth_h,sizeof(struct libnet_ethernet_hdr));
	memcpy(buf+sizeof(struct libnet_ethernet_hdr),&arp_h,sizeof(struct libnet_arp_hdr));
	len=sizeof(struct libnet_ethernet_hdr)+sizeof(struct libnet_arp_hdr);

	if((lpPacket = PacketAllocatePacket())==NULL){
		printf("\nError:failed to allocate the LPPACKET structure.");
		return (-1);
	}
	PacketInitPacket(lpPacket,buf,len);
	ret=PacketSendPacket(g_Info->lpAdapter,lpPacket,TRUE);
	if(ret==FALSE)
	{
		printf("PacketSendPacket failed\n");
	}
	PacketFreePacket(lpPacket);

	return TRUE;
}

