dnl $Id: aclocal.m4,v 1.2 1999/01/28 21:18:03 route Exp $
dnl
dnl     Libnet specific autoconf macros
dnl     Copyright (c) 1998, 1999 route|daemon9 <route@infonexus.com>
dnl     All rights reserved.
dnl

dnl
dnl Checks to see if unaligned memory accesses fail
dnl (Pulled from libpcap)
dnl
dnl usage:
dnl
dnl     AC_LBL_UNALIGNED_ACCESS
dnl
dnl results:
dnl
dnl     LBL_ALIGN (DEFINED)
dnl
AC_DEFUN(AC_LBL_UNALIGNED_ACCESS,
    [AC_MSG_CHECKING(if unaligned accesses fail)
    AC_CACHE_VAL(ac_cv_lbl_unaligned_fail,
        [case "$target_cpu" in

        alpha|hp*|mips|sparc)
                ac_cv_lbl_unaligned_fail=yes
                ;;

        *)
                cat >conftest.c <<EOF
#               include <sys/types.h>
#               include <sys/wait.h>
#               include <stdio.h>
                unsigned char a[[5]] = { 1, 2, 3, 4, 5 };
                main() {
                unsigned int i;
                pid_t pid;
                int status;
                /* avoid "core dumped" message */
                pid = fork();
                if (pid <  0)
                        exit(2);
                if (pid > 0) {
                        /* parent */
                        pid = waitpid(pid, &status, 0);
                        if (pid < 0)
                                exit(3);
                        exit(!WIFEXITED(status));
                }
                /* child */
                i = *(unsigned int *)&a[[1]];
                printf("%d\n", i);
                exit(0);
                }
EOF
                ${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS \
                    conftest.c $LIBS >/dev/null 2>&1
                if test ! -x conftest ; then
                        dnl failed to compile for some reason
                        ac_cv_lbl_unaligned_fail=yes
                else
                        ./conftest >conftest.out
                        if test ! -s conftest.out ; then
                                ac_cv_lbl_unaligned_fail=yes
                        else
                                ac_cv_lbl_unaligned_fail=no
                        fi
                fi
                rm -f conftest* core core.conftest
                ;;
        esac])
    AC_MSG_RESULT($ac_cv_lbl_unaligned_fail)
    if test $ac_cv_lbl_unaligned_fail = yes ; then
            AC_DEFINE(LBL_ALIGN)
    fi])

dnl EOF
