/*
 *  $Id: icmp.c,v 1.3 1999/01/31 21:05:41 route Exp $
 *
 *  libnet
 *  icmp.c - Build an ICMP_HOSTMASK packet at the link layer
 *
 *  Copyright (c) 1998, 1999 route|daemon9 <route@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "../libnet_test.h"

void send_icmp(struct link_int *, u_char *);

int
main(int argc, char *argv[])
{
    int  c;
    char errbuf[256];
    char *device = NULL;
    struct link_int *l;

    while ((c = getopt(argc, argv, "i:")) != EOF)
    {
        switch (c)
        {
            case 'i':
                device = optarg;
                break;
            default:
                exit(EXIT_FAILURE);
        }
    }

    if (!device)
    {
        fprintf(stderr, "Specify a device\n");
        exit(EXIT_FAILURE);
    }
    if ((l = open_link_interface(device, errbuf)) == NULL)
    {
        fprintf(stderr, "open_link_interface: %s\n", errbuf);
        exit(EXIT_FAILURE);
    }
    send_icmp(l, device);
    exit(EXIT_SUCCESS);
}


void
send_icmp(struct link_int *l, u_char *device)
{
    int n;
    u_char *buf;

    buf = (u_char *)malloc(ICMP_MASK_H + IP_H + ETH_H);
    if (!buf)
    {
        perror("no packet memory");
        exit(EXIT_FAILURE);
    }
    memset(buf, 0, ICMP_MASK_H + IP_H + ETH_H);

    /*
     *  Ethernet header
     */
    build_ethernet(enet_dst, enet_src, ETHERTYPE_IP, NULL, 0, buf);

    build_ip(ICMP_MASK_H,
        0,                      /* IP tos */
        242,                    /* IP ID */
        0,                      /* Frag */
        64,                     /* TTL */
        IPPROTO_ICMP,           /* Transport protocol */
        name_resolve(IP1, 1),   /* Source IP */
        name_resolve(IP2, 1),   /* Destination IP */
        NULL,                   /* Pointer to payload (none) */
        0,
        buf + ETH_H);           /* Packet header memory */

/* ICMP_MASKREPLY == 18 */

    build_icmp_mask(18,                 /* type */
		    0,                  /* code */ 
		    242,                /* id */ 
		    0,                  /* seq */ 
		    0xffffffff,         /* mask */
		    NULL,               /* payload */ 
		    0,                  /* payload_s */ 
		    buf + ETH_H + IP_H);

    do_checksum(buf + ETH_H, IPPROTO_IP, IP_H);
    do_checksum(buf + ETH_H, IPPROTO_ICMP, ICMP_H);

    n = write_link_layer(l, device, buf, ETH_H + IP_H + ICMP_MASK_H);
    if (n != ETH_H + IP_H + ICMP_MASK_H)
    {
        fprintf(stderr, "Oopz.  Only wrote %d bytes\n", n);
    }
    else
    {
        printf("Wrote %d byte ICMP packet through linktype %d\n", n, l->linktype);
    }
    free(buf);
}

/* EOF */
