/*
 *  $Id$
 *
 *  daemon.c - Standards Stevens based daemonizing code.
 *
 *  route|daemon9 <route@infonexus.com>
 *
 *  $Log$
 */

#include "../include/libnet.h"

int
daemon(void){

    int fd    = 0;
    struct sigaction action;
    extern int errno;

    action.sa_handler   = SIG_IGN;
    action.sa_flags     = 0;
    sigemptyset(&action.sa_mask);

    if (sigaction(SIGTTOU, &action, NULL) == -1) 
    {
        perror("daemon: cannot ignore SIGTOU");
        return (-1);
    }
    if (sigaction(SIGTTIN, &action, NULL) == -1) 
    {
        perror("daemon: cannot ignore SIGTIN");
        return (-1);
    }
    if (sigaction(SIGTSTP, &action, NULL) == -1) 
    {
        perror("daemon: cannot ignore SIGSTP");
        return (-1);
    }

    switch((fork()))
    {
        case 0:                 /* Child */
            break;

        default:        
            exit(0);            /* Parent */

        case -1:
            perror("daemon: fork error");
            return (-1);
    }
#if (LINUX) || (SOLARIS)
    if (setpgrp() == -1)
#else   /* BSD */
    if (setpgrp(0, 0) == -1)
#endif
    {
        perror("daemon: setpgrp");
        return (-1);
    }
    if ((fd = open("/dev/tty", O_RDWR)) >= 0)
    {
        ioctl(fd, TIOCNOTTY,(char *)NULL);
        close(fd);
    }
    if (chdir("/") == -1)
    {
        perror("daemon: chdir");
        return (-1);
    }
    errno = 0;
    umask(0);
    return (1);
}

/* EOF */
