/*
 *  $Id$
 *
 *  inet.c - Various Internet network-type routines
 *
 *  route|daemon9 <route@infonexus.com>
 *
 *  $Log$
 */
  
#include "../include/libnet.h"

u_char *
host_lookup(u_long in)
{
    static u_char hostname[512], hostname2[512];
    static u_short which;
    u_char *p;
#ifdef  USE_NAME
    struct hostent *host_ent;
    struct in_addr addr;
#endif  /* USE_NAME */

    /*
     *  Swap to the other buffer.  We swap static buffers to avoid having to
     *  pass in a char *.  This makes the code that calls this function more
     *  intuitive, but makes this function ugly.  This function is seriously
     *  non-rentrant.
     */
    which++;

#ifdef  USE_NAME
    addr.s_addr = in;
    host_ent = gethostbyaddr((char *)&addr, sizeof(struct in_addr), AF_INET);
    if (!host_ent)
    {
#endif  /* USE_NAME */
        
    p = (u_char *)&in;
    sprintf(((which % 2) ? hostname : hostname2),  "%d.%d.%d.%d",
            (p[0] & 255), (p[1] & 255), (p[2] & 255), (p[3] & 255));

#ifdef  USE_NAME
    }
    else 
    {
        strncpy(((which % 2) ? hostname : hostname2), host_ent->h_name, 
                                                        sizeof(hostname));
    }
#endif  /* USE_NAME */
    return (which % 2) ? (hostname) : (hostname2);
}


u_long
name_resolve(u_char *host_name)
{

#ifdef  USE_NAME
    struct in_addr addr;
    struct hostent *host_ent; 
   
    if ((addr.s_addr = inet_addr(host_name)) == -1)
    {
        if (!(host_ent = gethostbyname(host_name))) return (-1);
        bcopy(host_ent->h_addr, (char *)&addr.s_addr, host_ent->h_length);
    }
    return (addr.s_addr);
#else   /* USE_NAME */
    u_long l;
    u_int val;
    int i;

    /*
     *  We only want dots 'n decimals.
     */
    if (!isdigit(host_name[0])) return (-1L);

    l = 0;
    for (i = 0; i < 4; i++)
    {
        l <<= 8;
        if (*host_name)
        {
            val = 0;
            while (*host_name && *host_name != '.')
            {
                val *= 10;
                val += *host_name - '0';
                host_name++;
            }
            l |= val;
            if (*host_name) host_name++;
        }
    }
    return (htonl(l));
#endif  /* USE_NAME */
}


u_short
tcp_check(struct tcphdr *th, int len, u_long saddr, u_long daddr)
{
    u_long sum;

    __asm__("\taddl %%ecx, %%ebx\n\t"
        "adcl %%edx, %%ebx\n\t"
        "adcl $0, %%ebx"
        : "=b"(sum)
        : "0"(daddr), "c"(saddr), "d"((ntohs(len) << 16) + IPPROTO_TCP * 256)
        : "bx", "cx", "dx" );

    __asm__("\tmovl %%ecx, %%edx\n\t"
            "cld\n\t"
            "cmpl $32, %%ecx\n\t"
            "jb 2f\n\t"
            "shrl $5, %%ecx\n\t"
            "clc\n"
            "1:\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "loop 1b\n\t"
            "adcl $0, %%ebx\n\t"
            "movl %%edx, %%ecx\n"
            "2:\t"
            "andl $28, %%ecx\n\t"
            "je 4f\n\t"
            "shrl $2, %%ecx\n\t"
            "clc\n"
            "3:\t"
            "lodsl\n\t"
            "adcl %%eax, %%ebx\n\t"
            "loop 3b\n\t"
            "adcl $0, %%ebx\n"
            "4:\t"
            "movl $0, %%eax\n\t"
            "testw $2, %%dx\n\t"
            "je 5f\n\t"
            "lodsw\n\t"
            "addl %%eax, %%ebx\n\t"
            "adcl $0, %%ebx\n\t"
            "movw $0, %%ax\n"
            "5:\t"
            "test $1, %%edx\n\t"
            "je 6f\n\t"
            "lodsb\n\t"
            "addl %%eax, %%ebx\n\t"
            "adcl $0, %%ebx\n"
            "6:\t"
            "movl %%ebx, %%eax\n\t"
            "shrl $16, %%eax\n\t"
            "addw %%ax, %%bx\n\t"
            "adcw $0, %%bx"
        : "=b"(sum)
        : "0"(sum), "c"(len), "S"(th)
        : "ax", "bx", "cx", "dx", "si" );

    return ((~sum) & 0xffff);
}


u_short
ip_check(u_short *buff, int len)
{
    u_long sum = 0;

    if (len > 3)
    {
        __asm__("clc\n"
        "1:\t"
        "lodsl\n\t"
        "adcl %%eax, %%ebx\n\t"
        "loop 1b\n\t"
        "adcl $0, %%ebx\n\t"
        "movl %%ebx, %%eax\n\t"
        "shrl $16, %%eax\n\t"
        "addw %%ax, %%bx\n\t"
        "adcw $0, %%bx"
        : "=b" (sum) , "=S" (buff)
        : "0" (sum), "c" (len >> 2) ,"1" (buff)
        : "ax", "cx", "si", "bx");
    }
    if (len & 2)
    {
        __asm__("lodsw\n\t"
        "addw %%ax, %%bx\n\t"
        "adcw $0, %%bx"
        : "=b" (sum) , "=S" (buff)
        : "0" (sum), "c" (len >> 2) ,"1" (buff)
        : "ax", "cx", "si", "bx");
    }
    if (len & 2)
    {
        __asm__("lodsw\n\t"
        "addw %%ax, %%bx\n\t"
        "adcw $0, %%bx"
        : "=b" (sum), "=S" (buff)
        : "0" (sum), "1" (buff)
        : "bx", "ax", "si");
    }
    if (len & 1)
    {
        __asm__("lodsb\n\t"
        "movb $0, %%ah\n\t"
        "addw %%ax, %%bx\n\t"
        "adcw $0, %%bx"
        : "=b" (sum), "=S" (buff)
        : "0" (sum), "1" (buff)
        : "bx", "ax", "si");
    }
    if (len & 1)
    {
        __asm__("lodsb\n\t"
        "movb $0, %%ah\n\t"
        "addw %%ax, %%bx\n\t"
        "adcw $0, %%bx"
        : "=b" (sum), "=S" (buff)
        : "0" (sum), "1" (buff)
        : "bx", "ax", "si");
    }
    sum  = ~sum;
    return (sum & 0xffff);
}

/* EOF */
