/*
 *  $Id$
 *
 *  build_tcp.c - Crude TCP packet assembler
 *
 *  route|daemon9 <route@infonexus.com>
 *
 *  $Log$
 */

#include "../include/libnet.h"

void
build_tcp(u_short sp, u_short dp, u_long seq, u_long ack, u_char control,
            u_short win, u_short urg, const u_char *payload, u_char *buf)
{
    struct tcphdr *tcp_hdr;    

    tcp_hdr = (struct tcphdr *)(buf);

    tcp_hdr->th_sport   = htons(sp);
    tcp_hdr->th_dport   = htons(dp);
    tcp_hdr->th_seq     = htonl(seq);
    tcp_hdr->th_ack     = htonl(ack);
    tcp_hdr->th_flags   = control;
    tcp_hdr->th_x2      = 0;    /* UNUSED */
    tcp_hdr->th_off     = 5;
    tcp_hdr->th_win     = htons(win);
    tcp_hdr->th_sum     = 0;
    tcp_hdr->th_urp     = urg;

    if (payload)
    {
        /* ... */
    }
}

/* EOF */
